/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.LatexDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFJsonLDDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;

public class OntologyFormatPanel
extends JPanel {
    private JComboBox<OWLDocumentFormat> formatComboBox;
    private JLabel messageLabel;

    public OntologyFormatPanel() {
        ArrayList<Object> formats = new ArrayList<Object>();
        formats.add(new RDFXMLDocumentFormat());
        formats.add(new TurtleDocumentFormat());
        formats.add(new OWLXMLDocumentFormat());
        formats.add(new FunctionalSyntaxDocumentFormat());
        formats.add(new ManchesterSyntaxDocumentFormat());
        formats.add(new OBODocumentFormat());
        formats.add(new LatexDocumentFormat());
        formats.add(new RDFJsonLDDocumentFormat());
        this.formatComboBox = new JComboBox<OWLDocumentFormat>(formats.toArray(new OWLDocumentFormat[formats.size()]));
        this.setLayout(new BorderLayout(12, 12));
        this.add(this.formatComboBox, "South");
        this.formatComboBox.setSelectedItem(formats.get(0));
    }

    public void setSelectedFormat(OWLDocumentFormat format) {
        if (format == null) {
            this.formatComboBox.setSelectedIndex(0);
        }
        for (int i = 0; i < this.formatComboBox.getModel().getSize(); ++i) {
            if (!((OWLDocumentFormat)this.formatComboBox.getModel().getElementAt(i)).equals(format)) continue;
            this.formatComboBox.setSelectedIndex(i);
            return;
        }
    }

    public void setMessage(String message) {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel(message);
            this.add((Component)this.messageLabel, "North");
        } else {
            this.messageLabel.setText(message);
        }
        this.revalidate();
    }

    public OWLDocumentFormat getSelectedFormat() {
        return (OWLDocumentFormat)this.formatComboBox.getSelectedItem();
    }

    public void addItemListener(ItemListener l) {
        this.formatComboBox.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.formatComboBox.removeItemListener(l);
    }

    public static Optional<OWLDocumentFormat> showDialog(OWLEditorKit editorKit, OWLDocumentFormat defaultFormat, String message) {
        OntologyFormatPanel panel = new OntologyFormatPanel();
        if (message != null) {
            panel.setMessage(message);
        }
        panel.setSelectedFormat(defaultFormat);
        OWLDocumentFormat selectedFormat = null;
        do {
            int ret;
            if ((ret = JOptionPane.showConfirmDialog((Component)((Object)editorKit.getWorkspace()), panel, "Select an ontology format", 2, -1)) == 0) continue;
            return Optional.empty();
        } while (!OntologyFormatPanel.isFormatOk(editorKit, selectedFormat = panel.getSelectedFormat()));
        return Optional.of(selectedFormat);
    }

    private static boolean isFormatOk(OWLEditorKit editorKit, OWLDocumentFormat format) {
        if (!(format instanceof ManchesterSyntaxDocumentFormat)) {
            return true;
        }
        int userSaysOk = JOptionPane.showConfirmDialog((Component)((Object)editorKit.getOWLWorkspace()), "The Manchester OWL Syntax can lose information such as GCI's and annotations of undeclared entities.  Continue?", "Warning", 0);
        return userSaysOk == 0;
    }
}

