/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.IUnionType;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class UnionType
extends TypeReference
implements IUnionType {
    private final List<TypeReference> _alternatives;
    private final String _simpleName;

    private UnionType(TypeReference ... alternatives) {
        this._alternatives = ArrayUtilities.asUnmodifiableList(VerifyArgument.noNullElementsAndNotEmpty(alternatives, "alternatives"));
        this._simpleName = this.appendName(new StringBuilder(), false, false).toString();
        this.setName(this._simpleName);
    }

    @Override
    public List<TypeReference> getAlternatives() {
        return this._alternatives;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        for (int i = 0; i < this._alternatives.size(); ++i) {
            TypeReference t = this._alternatives.get(i);
            if (i > 0) {
                sb.append(" | ");
            }
            t.appendName(sb, fullName, dottedName);
        }
        return sb;
    }

    @Override
    public <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitClassType(this, parameter);
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    public static TypeReference of(TypeReference ... types) {
        VerifyArgument.noNullElementsAndNotEmpty(types, "types");
        if (types.length == 1) {
            return types[0];
        }
        TypeReference[] alternatives = Arrays.copyOf(types, types.length);
        for (int i = 0; i < alternatives.length; ++i) {
            TypeReference alternative = alternatives[i];
            if (!(alternative instanceof IUnionType)) continue;
            TypeReference[] innerAlternatives = ((IUnionType)((Object)alternative)).getAlternatives().toArray(EMPTY_REFERENCES);
            alternatives = ArrayUtilities.insert(ArrayUtilities.remove(alternatives, i), i, innerAlternatives);
        }
        if ((alternatives = new LinkedHashSet<TypeReference>(Arrays.asList(alternatives)).toArray(EMPTY_REFERENCES)).length == 1) {
            return alternatives[0];
        }
        return new UnionType(alternatives);
    }
}

