/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.spark.rest.model.CreateAsyncQueryRequest;
import org.opensearch.sql.spark.transport.TransportCancelAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportCreateAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportGetAsyncQueryResultAction;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.GetAsyncQueryResultActionRequest;
import org.opensearch.sql.spark.transport.model.GetAsyncQueryResultActionResponse;

public class RestAsyncQueryManagementAction
extends BaseRestHandler {
    public static final String ASYNC_QUERY_ACTIONS = "async_query_actions";
    public static final String BASE_ASYNC_QUERY_ACTION_URL = "/_plugins/_async_query";
    private static final Logger LOG = LogManager.getLogger(RestAsyncQueryManagementAction.class);

    public String getName() {
        return ASYNC_QUERY_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, BASE_ASYNC_QUERY_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", BASE_ASYNC_QUERY_ACTION_URL, "queryId")), (Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", BASE_ASYNC_QUERY_ACTION_URL, "queryId")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        switch (restRequest.method()) {
            case POST: {
                return this.executePostRequest(restRequest, nodeClient);
            }
            case GET: {
                return this.executeGetAsyncQueryResultRequest(restRequest, nodeClient);
            }
            case DELETE: {
                return this.executeDeleteRequest(restRequest, nodeClient);
            }
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        CreateAsyncQueryRequest submitJobRequest = CreateAsyncQueryRequest.fromXContentParser(restRequest.contentParser());
        return restChannel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute(TransportCreateAsyncQueryRequestAction.ACTION_TYPE, (ActionRequest)new CreateAsyncQueryActionRequest(submitJobRequest), (ActionListener)new ActionListener<CreateAsyncQueryActionResponse>(){

            public void onResponse(CreateAsyncQueryActionResponse createAsyncQueryActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, "application/json; charset=UTF-8", createAsyncQueryActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestAsyncQueryManagementAction.this.handleException(e, restChannel);
            }
        }));
    }

    private BaseRestHandler.RestChannelConsumer executeGetAsyncQueryResultRequest(RestRequest restRequest, NodeClient nodeClient) {
        String queryId = restRequest.param("queryId");
        return restChannel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute(TransportGetAsyncQueryResultAction.ACTION_TYPE, (ActionRequest)new GetAsyncQueryResultActionRequest(queryId), (ActionListener)new ActionListener<GetAsyncQueryResultActionResponse>(){

            public void onResponse(GetAsyncQueryResultActionResponse getAsyncQueryResultActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", getAsyncQueryResultActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestAsyncQueryManagementAction.this.handleException(e, restChannel);
            }
        }));
    }

    private void handleException(Exception e, RestChannel restChannel) {
        if (e instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestAsyncQueryManagementAction.isClientError(e)) {
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
            } else {
                this.reportError(restChannel, e, RestStatus.SERVICE_UNAVAILABLE);
            }
        }
    }

    private BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest restRequest, NodeClient nodeClient) {
        String queryId = restRequest.param("queryId");
        return restChannel -> Scheduler.schedule((NodeClient)nodeClient, () -> nodeClient.execute(TransportCancelAsyncQueryRequestAction.ACTION_TYPE, (ActionRequest)new CancelAsyncQueryActionRequest(queryId), (ActionListener)new ActionListener<CancelAsyncQueryActionResponse>(){

            public void onResponse(CancelAsyncQueryActionResponse cancelAsyncQueryActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NO_CONTENT, "application/json; charset=UTF-8", cancelAsyncQueryActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                RestAsyncQueryManagementAction.this.handleException(e, restChannel);
            }
        }));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage((Throwable)e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalStateException;
    }
}

