/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.undeploy;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MLUndeployModelNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private Map<String, String> modelUndeployStatus;
    private Map<String, String[]> modelWorkerNodeBeforeRemoval;

    public MLUndeployModelNodeResponse(DiscoveryNode node, Map<String, String> modelUndeployStatus, Map<String, String[]> modelWorkerNodeBeforeRemoval) {
        super(node);
        this.modelUndeployStatus = modelUndeployStatus;
        this.modelWorkerNodeBeforeRemoval = modelWorkerNodeBeforeRemoval;
    }

    public MLUndeployModelNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelUndeployStatus = in.readMap(s -> s.readString(), s -> s.readString());
        }
        if (in.readBoolean()) {
            this.modelWorkerNodeBeforeRemoval = in.readMap(s -> s.readString(), s -> s.readOptionalStringArray());
        }
    }

    public static MLUndeployModelNodeResponse readStats(StreamInput in) throws IOException {
        return new MLUndeployModelNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.modelUndeployStatus != null) {
            out.writeBoolean(true);
            out.writeMap(this.modelUndeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelWorkerNodeBeforeRemoval != null) {
            out.writeBoolean(true);
            out.writeMap(this.modelWorkerNodeBeforeRemoval, StreamOutput::writeString, StreamOutput::writeOptionalStringArray);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (this.modelUndeployStatus != null) {
            for (Map.Entry<String, String> stat : this.modelUndeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.modelUndeployStatus == null || this.modelUndeployStatus.size() == 0;
    }

    @Generated
    public Map<String, String> getModelUndeployStatus() {
        return this.modelUndeployStatus;
    }

    @Generated
    public Map<String, String[]> getModelWorkerNodeBeforeRemoval() {
        return this.modelWorkerNodeBeforeRemoval;
    }
}

