/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.MLCommonsClassLoader;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.utils.StringUtils;

public interface Connector
extends ToXContentObject,
Writeable {
    public String getName();

    public String getProtocol();

    public User getOwner();

    public void setOwner(User var1);

    public AccessMode getAccess();

    public void setAccess(AccessMode var1);

    public List<String> getBackendRoles();

    public void setBackendRoles(List<String> var1);

    public Map<String, String> getParameters();

    public List<ConnectorAction> getActions();

    public String getPredictEndpoint(Map<String, String> var1);

    public String getPredictHttpMethod();

    public <T> T createPredictPayload(Map<String, String> var1);

    public void decrypt(Function<String, String> var1);

    public void encrypt(Function<String, String> var1);

    public Connector cloneConnector();

    public Optional<ConnectorAction> findPredictAction();

    public void removeCredential();

    public void writeTo(StreamOutput var1) throws IOException;

    public void update(MLCreateConnectorInput var1, Function<String, String> var2);

    public <T> void parseResponse(T var1, List<ModelTensor> var2, boolean var3) throws IOException;

    default public void validatePayload(String payload) {
        if (payload != null && payload.contains("${parameters")) {
            Pattern pattern = Pattern.compile("\\$\\{parameters\\.([^}]+)}");
            Matcher matcher = pattern.matcher(payload);
            StringBuilder errorBuilder = new StringBuilder();
            while (matcher.find()) {
                String parameter = matcher.group(1);
                errorBuilder.append(parameter).append(", ");
            }
            String error = errorBuilder.substring(0, errorBuilder.length() - 2).toString();
            throw new IllegalArgumentException("Some parameter placeholder not filled in payload: " + error);
        }
    }

    public static Connector fromStream(StreamInput in) throws IOException {
        String connectorProtocol = in.readString();
        return (Connector)MLCommonsClassLoader.initConnector(connectorProtocol, new Object[]{connectorProtocol, in}, String.class, StreamInput.class);
    }

    public static Connector createConnector(XContentBuilder builder, String connectorProtocol) throws IOException {
        String jsonStr = builder.toString();
        return Connector.createConnector(jsonStr, connectorProtocol);
    }

    public static Connector createConnector(XContentParser parser) throws IOException {
        String jsonStr;
        Map connectorMap = parser.map();
        try {
            jsonStr = AccessController.doPrivileged(() -> StringUtils.gson.toJson((Object)connectorMap));
        }
        catch (PrivilegedActionException e) {
            throw new IllegalArgumentException("wrong connector");
        }
        String connectorProtocol = (String)connectorMap.get("protocol");
        return Connector.createConnector(jsonStr, connectorProtocol);
    }

    private static Connector createConnector(String jsonStr, String connectorProtocol) throws IOException {
        Connector connector;
        block10: {
            XContentParser connectorParser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, jsonStr);
            try {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)connectorParser.nextToken(), (XContentParser)connectorParser);
                if (connectorProtocol == null) {
                    throw new IllegalArgumentException("connector protocol is null");
                }
                connector = (Connector)MLCommonsClassLoader.initConnector(connectorProtocol, new Object[]{connectorProtocol, connectorParser}, String.class, XContentParser.class);
                if (connectorParser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connectorParser != null) {
                        try {
                            connectorParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    if (ex instanceof IllegalArgumentException) {
                        throw ex;
                    }
                    return null;
                }
            }
            connectorParser.close();
        }
        return connector;
    }

    default public void validateConnectorURL(List<String> urlRegexes) {
        if (this.getActions() == null) {
            throw new IllegalArgumentException("No actions configured for this connector");
        }
        Map<String, String> parameters = this.getParameters();
        for (ConnectorAction action : this.getActions()) {
            StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
            String url = substitutor.replace(action.getUrl());
            boolean hasMatchedUrl = false;
            for (String urlRegex : urlRegexes) {
                Pattern pattern = Pattern.compile(urlRegex);
                Matcher matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                hasMatchedUrl = true;
                break;
            }
            if (hasMatchedUrl) continue;
            throw new IllegalArgumentException("Connector URL is not matching the trusted connector endpoint regex, URL is: " + url);
        }
    }

    public Map<String, String> getDecryptedHeaders();
}

