/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types.base;

import java.util.Objects;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.BaseType;

public class OpenSearchIndex
implements BaseType {
    private final String indexName;
    private final IndexType indexType;

    public OpenSearchIndex(String indexName, IndexType indexType) {
        this.indexName = indexName;
        this.indexType = indexType;
    }

    public IndexType type() {
        return this.indexType;
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public boolean isCompatible(Type other) {
        return this.equals(other);
    }

    @Override
    public String usage() {
        return this.indexType.name();
    }

    public String toString() {
        return this.indexType + " [" + this.indexName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchIndex index = (OpenSearchIndex)o;
        return Objects.equals(this.indexName, index.indexName) && this.indexType == index.indexType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexName, this.indexType});
    }

    public static enum IndexType {
        INDEX,
        NESTED_FIELD,
        INDEX_PATTERN;

    }
}

