/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatsType;

public enum ReaderMetrics implements MeasurementSet
{
    METRICSDB_FILE_SIZE("MetricsdbFileSize", "bytes", StatsType.STATS_DATA, Arrays.asList(Statistics.MAX, Statistics.MEAN)),
    METRICSDB_NUM_FILES("MetricsdbNumFiles", "count", StatsType.STATS_DATA, Statistics.SAMPLE),
    METRICSDB_SIZE_FILES("MetricsdbSizeFiles", "bytes", StatsType.STATS_DATA, Statistics.SAMPLE),
    METRICSDB_NUM_UNCOMPRESSED_FILES("MetricsdbNumUncompressedFiles", "count", StatsType.STATS_DATA, Statistics.SAMPLE),
    METRICSDB_SIZE_UNCOMPRESSED_FILES("MetricsdbSizeUncompressedFiles", "bytes", StatsType.STATS_DATA, Statistics.SAMPLE),
    BATCH_METRICS_ENABLED("BatchMetricsEnabled", "count", StatsType.STATS_DATA, Statistics.SAMPLE),
    BATCH_METRICS_HTTP_SUCCESS("BatchMetricsHttpSuccess"),
    BATCH_METRICS_QUERY_PROCESSING_TIME("BatchMetricsQueryProcessingTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    READER_METRICS_EMIT_TIME("ReaderMetricsEmitTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    READER_OS_METRICS_EMIT_TIME("ReaderOSMetricsEmitTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    READER_METRICS_PROCESS_TIME("ReaderMetricsProcessTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    GC_INFO_EMITTER_EXECUTION_TIME("GCInfoEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    WORKLOAD_METRICS_EMITTER_EXECUTION_TIME("WorkloadMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    THREAD_NAME_METRICS_EMITTER_EXECUTION_TIME("ThreadNameMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    AGGREGATED_OS_METRICS_EMITTER_EXECUTION_TIME("AggregatedOSMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    SHARD_REQUEST_METRICS_EMITTER_EXECUTION_TIME("ShardRequestMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    HTTP_METRICS_EMITTER_EXECUTION_TIME("HTTPMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    ADMISSION_CONTROL_METRICS_EMITTER_EXECUTION_TIME("AdmissionControlMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    CLUSTER_MANAGER_EVENT_METRICS_EMITTER_EXECUTION_TIME("ClusterManagerEventMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    NODE_METRICS_EMITTER_EXECUTION_TIME("NodeMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    SHARD_STATE_EMITTER_EXECUTION_TIME("ShardStateEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    CLUSTER_MANAGER_THROTTLING_EMITTER_EXECUTION_TIME("ClusterManagerThrottlingEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM),
    FAULT_DETECTION_METRICS_EMITTER_EXECUTION_TIME("FaultDetectionMetricsEmitterExecutionTime", "millis", StatsType.LATENCIES, Statistics.SUM);

    private String name;
    private String unit;
    private StatsType statsType;
    private List<Statistics> statsList;

    private ReaderMetrics(String name) {
        this(name, "count", StatsType.STATS_DATA, Collections.singletonList(Statistics.COUNT));
    }

    private ReaderMetrics(String name, String unit, StatsType statType, Statistics stats) {
        this(name, unit, statType, Collections.singletonList(stats));
    }

    private ReaderMetrics(String name, String unit, StatsType statType, List<Statistics> stats) {
        this.name = name;
        this.unit = unit;
        this.statsType = statType;
        this.statsList = stats;
    }

    public String toString() {
        return this.name + "-" + this.unit;
    }

    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    public StatsType getStatsType() {
        return this.statsType;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }
}

