/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.KeyNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.KeyPairIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyPairsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeKeyPairsRequest> {
    private static final SdkField<List<String>> KEY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyNames").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::keyNames)).setter(DescribeKeyPairsRequest.setter(Builder::keyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build(), ListTrait.builder().memberLocationName("KeyName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEY_PAIR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPairIds").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::keyPairIds)).setter(DescribeKeyPairsRequest.setter(Builder::keyPairIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("KeyPairId").build(), ListTrait.builder().memberLocationName("KeyPairId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("KeyPairId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePublicKey").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::includePublicKey)).setter(DescribeKeyPairsRequest.setter(Builder::includePublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePublicKey").unmarshallLocationName("IncludePublicKey").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::dryRun)).setter(DescribeKeyPairsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeKeyPairsRequest.getter(DescribeKeyPairsRequest::filters)).setter(DescribeKeyPairsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAMES_FIELD, KEY_PAIR_IDS_FIELD, INCLUDE_PUBLIC_KEY_FIELD, DRY_RUN_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeKeyPairsRequest.memberNameToFieldInitializer();
    private final List<String> keyNames;
    private final List<String> keyPairIds;
    private final Boolean includePublicKey;
    private final Boolean dryRun;
    private final List<Filter> filters;

    private DescribeKeyPairsRequest(BuilderImpl builder) {
        super(builder);
        this.keyNames = builder.keyNames;
        this.keyPairIds = builder.keyPairIds;
        this.includePublicKey = builder.includePublicKey;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
    }

    public final boolean hasKeyNames() {
        return this.keyNames != null && !(this.keyNames instanceof SdkAutoConstructList);
    }

    public final List<String> keyNames() {
        return this.keyNames;
    }

    public final boolean hasKeyPairIds() {
        return this.keyPairIds != null && !(this.keyPairIds instanceof SdkAutoConstructList);
    }

    public final List<String> keyPairIds() {
        return this.keyPairIds;
    }

    public final Boolean includePublicKey() {
        return this.includePublicKey;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyNames() ? this.keyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPairIds() ? this.keyPairIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest)((Object)obj);
        return this.hasKeyNames() == other.hasKeyNames() && Objects.equals(this.keyNames(), other.keyNames()) && this.hasKeyPairIds() == other.hasKeyPairIds() && Objects.equals(this.keyPairIds(), other.keyPairIds()) && Objects.equals(this.includePublicKey(), other.includePublicKey()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeyPairsRequest").add("KeyNames", this.hasKeyNames() ? this.keyNames() : null).add("KeyPairIds", this.hasKeyPairIds() ? this.keyPairIds() : null).add("IncludePublicKey", (Object)this.includePublicKey()).add("DryRun", (Object)this.dryRun()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyNames": {
                return Optional.ofNullable(clazz.cast(this.keyNames()));
            }
            case "KeyPairIds": {
                return Optional.ofNullable(clazz.cast(this.keyPairIds()));
            }
            case "IncludePublicKey": {
                return Optional.ofNullable(clazz.cast(this.includePublicKey()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyName", KEY_NAMES_FIELD);
        map.put("KeyPairId", KEY_PAIR_IDS_FIELD);
        map.put("IncludePublicKey", INCLUDE_PUBLIC_KEY_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsRequest, T> g) {
        return obj -> g.apply((DescribeKeyPairsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> keyNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyPairIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean includePublicKey;
        private Boolean dryRun;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsRequest model) {
            super(model);
            this.keyNames(model.keyNames);
            this.keyPairIds(model.keyPairIds);
            this.includePublicKey(model.includePublicKey);
            this.dryRun(model.dryRun);
            this.filters(model.filters);
        }

        public final Collection<String> getKeyNames() {
            if (this.keyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyNames;
        }

        public final void setKeyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
        }

        @Override
        public final Builder keyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyNames(String ... keyNames) {
            this.keyNames(Arrays.asList(keyNames));
            return this;
        }

        public final Collection<String> getKeyPairIds() {
            if (this.keyPairIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyPairIds;
        }

        public final void setKeyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
        }

        @Override
        public final Builder keyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairIds(String ... keyPairIds) {
            this.keyPairIds(Arrays.asList(keyPairIds));
            return this;
        }

        public final Boolean getIncludePublicKey() {
            return this.includePublicKey;
        }

        public final void setIncludePublicKey(Boolean includePublicKey) {
            this.includePublicKey = includePublicKey;
        }

        @Override
        public final Builder includePublicKey(Boolean includePublicKey) {
            this.includePublicKey = includePublicKey;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeKeyPairsRequest build() {
            return new DescribeKeyPairsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyPairsRequest> {
        public Builder keyNames(Collection<String> var1);

        public Builder keyNames(String ... var1);

        public Builder keyPairIds(Collection<String> var1);

        public Builder keyPairIds(String ... var1);

        public Builder includePublicKey(Boolean var1);

        public Builder dryRun(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

