"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiDatePopoverButton", {
  enumerable: true,
  get: function get() {
    return _date_popover_button.EuiDatePopoverButton;
  }
});
exports.OuiDatePopoverButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _popover = require("../../../popover");

var _pretty_duration = require("../pretty_duration");

var _date_popover_content = require("./date_popover_content");

var _date_popover_button = require("../../../../eui_components/date_picker/super_date_picker/date_popover/date_popover_button");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-line import/named
var OuiDatePopoverButton = function OuiDatePopoverButton(props) {
  var position = props.position,
      isDisabled = props.isDisabled,
      isInvalid = props.isInvalid,
      needsUpdating = props.needsUpdating,
      value = props.value,
      buttonProps = props.buttonProps,
      roundUp = props.roundUp,
      onChange = props.onChange,
      locale = props.locale,
      dateFormat = props.dateFormat,
      utcOffset = props.utcOffset,
      timeFormat = props.timeFormat,
      isOpen = props.isOpen,
      onPopoverToggle = props.onPopoverToggle,
      onPopoverClose = props.onPopoverClose,
      compressed = props.compressed,
      rest = (0, _objectWithoutProperties2.default)(props, ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed"]);
  var classes = (0, _classnames.default)(['ouiDatePopoverButton', "ouiDatePopoverButton--".concat(position), {
    'ouiDatePopoverButton-isSelected': isOpen,
    'ouiDatePopoverButton-isInvalid': isInvalid,
    'ouiDatePopoverButton-needsUpdating': needsUpdating,
    'ouiDatePopoverButton-disabled': isDisabled,
    'ouiDatePopoverButton-compressed': compressed
  }]);
  var title = value;

  if (isInvalid) {
    title = "Invalid date: ".concat(title);
  } else if (needsUpdating) {
    title = "Update needed: ".concat(title);
  }

  var button = /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps), (0, _pretty_duration.formatTimeString)(value, dateFormat, roundUp, locale));

  return /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, (0, _extends2.default)({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest), /*#__PURE__*/_react.default.createElement(_date_popover_content.OuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset
  }));
};

exports.OuiDatePopoverButton = OuiDatePopoverButton;
OuiDatePopoverButton.propTypes = {
  className: _propTypes.default.string,
  buttonProps: _propTypes.default.any,
  dateFormat: _propTypes.default.string.isRequired,
  isDisabled: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isOpen: _propTypes.default.bool.isRequired,
  needsUpdating: _propTypes.default.bool,
  locale: _propTypes.default.any,
  onChange: _propTypes.default.any.isRequired,
  onPopoverClose: _propTypes.default.func.isRequired,
  onPopoverToggle: _propTypes.default.func.isRequired,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired,
  roundUp: _propTypes.default.bool,
  timeFormat: _propTypes.default.string.isRequired,
  value: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number,
  compressed: _propTypes.default.bool
};
OuiDatePopoverButton.displayName = 'OuiDatePopoverButton';
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */