/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.metadata.store;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.replication.metadata.store.AddReplicationMetadataRequest;
import org.opensearch.replication.metadata.store.DeleteReplicationMetadataRequest;
import org.opensearch.replication.metadata.store.GetReplicationMetadataRequest;
import org.opensearch.replication.metadata.store.GetReplicationMetadataResponse;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.metadata.store.ReplicationMetadataStore;
import org.opensearch.replication.metadata.store.UpdateReplicationMetadataRequest;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u00018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0015H\u0014J\b\u0010$\u001a\u00020\u0015H\u0014J\b\u0010%\u001a\u00020\u0015H\u0014J\"\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00010'2\u0006\u0010*\u001a\u00020'H\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u00100J\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00192\u0006\u00101\u001a\u000202J\n\u00103\u001a\u0004\u0018\u00010'H\u0002J\u0016\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u000206H\u0086@\u00a2\u0006\u0002\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00069"}, d2={"Lorg/opensearch/replication/metadata/store/ReplicationMetadataStore;", "Lorg/opensearch/common/lifecycle/AbstractLifecycleComponent;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "namedXContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getNamedXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "addMetadata", "Lorg/opensearch/action/index/IndexResponse;", "addReq", "Lorg/opensearch/replication/metadata/store/AddReplicationMetadataRequest;", "(Lorg/opensearch/replication/metadata/store/AddReplicationMetadataRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndUpdateMapping", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAndWaitForStoreHealth", "configStoreExists", "", "configStoreSettings", "Lorg/opensearch/common/settings/Settings;", "createIndex", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "deleteMetadata", "Lorg/opensearch/action/delete/DeleteResponse;", "delMetadataReq", "Lorg/opensearch/replication/metadata/store/DeleteReplicationMetadataRequest;", "(Lorg/opensearch/replication/metadata/store/DeleteReplicationMetadataRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doClose", "doStart", "doStop", "getId", "", "metadataType", "connectionName", "resourceName", "getMetadata", "Lorg/opensearch/replication/metadata/store/GetReplicationMetadataResponse;", "getMetadataReq", "Lorg/opensearch/replication/metadata/store/GetReplicationMetadataRequest;", "fetch_from_primary", "(Lorg/opensearch/replication/metadata/store/GetReplicationMetadataRequest;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "timeout", "", "getPreferenceOnPrimaryNode", "updateMetadata", "updateMetadataReq", "Lorg/opensearch/replication/metadata/store/UpdateReplicationMetadataRequest;", "(Lorg/opensearch/replication/metadata/store/UpdateReplicationMetadataRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nReplicationMetadataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplicationMetadataStore.kt\norg/opensearch/replication/metadata/store/ReplicationMetadataStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1#2:292\n1855#3:293\n288#3,2:294\n1856#3:296\n*S KotlinDebug\n*F\n+ 1 ReplicationMetadataStore.kt\norg/opensearch/replication/metadata/store/ReplicationMetadataStore\n*L\n203#1:293\n204#1:294,2\n203#1:296\n*E\n"})
public final class ReplicationMetadataStore
extends AbstractLifecycleComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry namedXContentRegistry;
    @NotNull
    public static final String REPLICATION_CONFIG_SYSTEM_INDEX = ".replication-metadata-store";
    @NotNull
    public static final String MAPPING_TYPE = "_doc";
    @NotNull
    public static final String MAPPING_META = "_meta";
    @NotNull
    public static final String MAPPING_SCHEMA_VERSION = "schema_version";
    public static final int DEFAULT_SCHEMA_VERSION = 1;
    @NotNull
    private static final String REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING;
    private static int REPLICATION_STORE_MAPPING_VERSION;
    private static final Logger log;

    public ReplicationMetadataStore(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry namedXContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)namedXContentRegistry, (String)"namedXContentRegistry");
        this.client = client;
        this.clusterService = clusterService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getNamedXContentRegistry() {
        return this.namedXContentRegistry;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object addMetadata(@NotNull AddReplicationMetadataRequest var1_1, @NotNull Continuation<? super IndexResponse> var2_2) {
        if (!(var2_2 instanceof addMetadata.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addMetadata(null, (Continuation<? super IndexResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.configStoreExists()) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = addReq;
                    $continuation.label = 1;
                    v0 = this.createIndex((Continuation<? super CreateIndexResponse>)$continuation);
                    ** if (v0 != var8_5) goto lbl21
lbl20:
                    // 1 sources

                    return var8_5;
                }
lbl21:
                // 3 sources

                ** GOTO lbl33
            }
            case 1: {
                addReq = (AddReplicationMetadataRequest)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception ex) {
                    if (ExceptionsHelper.unwrapCause((Throwable)ex) instanceof ResourceAlreadyExistsException) ** GOTO lbl33
                    throw ex;
                }
lbl33:
                // 3 sources

                $continuation.L$0 = this;
                $continuation.L$1 = addReq;
                $continuation.label = 2;
                v1 = this.checkAndWaitForStoreHealth((Continuation<? super Unit>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl45
            }
            case 2: {
                addReq = (AddReplicationMetadataRequest)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl45:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = addReq;
                $continuation.label = 3;
                v2 = this.checkAndUpdateMapping((Continuation<? super Unit>)$continuation);
                if (v2 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl57
            }
            case 3: {
                addReq = (AddReplicationMetadataRequest)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl57:
                // 2 sources

                id = this.getId(addReq.getReplicationMetadata().getMetadataType(), addReq.getReplicationMetadata().getConnectionName(), addReq.getReplicationMetadata().getFollowerContext().getResource());
                v3 = this.client.prepareIndex(".replication-metadata-store").setId(id);
                v4 = addReq.getReplicationMetadata();
                var5_8 = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)var5_8, (String)"jsonBuilder(...)");
                v5 = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"EMPTY_PARAMS");
                indexReqBuilder = v3.setSource(v4.toXContent(var5_8, v5));
                Intrinsics.checkNotNull((Object)indexReqBuilder);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 4;
                v6 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<String, ActionListener<IndexResponse>, Unit>((Object)indexReqBuilder){

                    public final void invoke(@NotNull String p0, @NotNull ActionListener<IndexResponse> p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        ExtensionsKt.execute((IndexRequestBuilder)this.receiver, p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v6 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl76
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl76:
                // 2 sources

                $continuation.label = 5;
                v7 = ((Function2)v6).invoke((Object)"replication", (Object)$continuation);
                if (v7 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl84
            }
            case 5: {
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl84:
                // 2 sources

                return v7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkAndUpdateMapping(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof checkAndUpdateMapping.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ReplicationMetadataStore.access$checkAndUpdateMapping(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                currentSchemaVersion = 1;
                var4_6 = this.clusterService.state().getMetadata().getIndices().getOrDefault(".replication-metadata-store", null);
                if (var4_6 == null) {
                    throw new ResourceNotFoundException("Index metadata doesn't exist for .replication-metadata-store", new Object[0]);
                }
                indexMetadata = var4_6;
                v0 = indexMetadata.mapping();
                v1 = v0 != null && (v0 = v0.getSourceAsMap()) != null ? v0.get("_meta") : (mappingMetadata = null);
                if (mappingMetadata != null && mappingMetadata instanceof HashMap) {
                    v2 = ((Map)mappingMetadata).get("schema_version");
                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Int");
                    currentSchemaVersion = (Integer)v2;
                }
                if (ReplicationMetadataStore.REPLICATION_STORE_MAPPING_VERSION <= currentSchemaVersion) ** GOTO lbl49
                var6_8 = new String[]{".replication-metadata-store"};
                putMappingReq = new PutMappingRequest(var6_8).source(ReplicationMetadataStore.REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING, (MediaType)XContentType.JSON);
                var7_10 = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"indices(...)");
                $continuation.L$0 = putMappingReq;
                $continuation.label = 1;
                v3 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<PutMappingRequest, ActionListener<AcknowledgedResponse>, Unit>((Object)var7_10){

                    public final void invoke(PutMappingRequest p0, ActionListener<AcknowledgedResponse> p1) {
                        ((IndicesAdminClient)this.receiver).putMapping(p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v3 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl38
            }
            case 1: {
                putMappingReq = (PutMappingRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl38:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v4 = ((Function2)v3).invoke((Object)putMappingReq, (Object)$continuation);
                if (v4 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl47
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl47:
                // 2 sources

                if (!(putMappingRes = (AcknowledgedResponse)v4).isAcknowledged()) {
                    ReplicationMetadataStore.log.error("Mapping update failed for replication store - .replication-metadata-store");
                }
lbl49:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getMetadata(@NotNull GetReplicationMetadataRequest var1_1, boolean var2_2, @NotNull Continuation<? super GetReplicationMetadataResponse> var3_3) {
        if (!(var3_3 instanceof getMetadata.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getMetadata(null, false, (Continuation<? super GetReplicationMetadataResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = this.getId(getMetadataReq.getMetadataType(), getMetadataReq.getConnectionName(), getMetadataReq.getResourceName());
                if (!this.configStoreExists()) {
                    throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.Z$0 = fetch_from_primary;
                $continuation.label = 1;
                v0 = this.checkAndWaitForStoreHealth((Continuation<? super Unit>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                fetch_from_primary = $continuation.Z$0;
                id = (String)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                getReq = new GetRequest(".replication-metadata-store", id);
                getReq.realtime(true);
                getReq.refresh(true);
                if (fetch_from_primary) {
                    v1 = this.getPreferenceOnPrimaryNode();
                    if (v1 == null) {
                        throw new IllegalStateException("Primary shard to fetch id[" + id + "] in index[.replication-metadata-store] doesn't exist");
                    }
                    preference = v1;
                    getReq.preference(preference);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = getReq;
                $continuation.label = 2;
                v2 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<GetRequest, ActionListener<GetResponse>, Unit>((Object)this.client){

                    public final void invoke(GetRequest p0, ActionListener<GetResponse> p1) {
                        ((Client)this.receiver).get(p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl55
            }
            case 2: {
                getReq = (GetRequest)$continuation.L$2;
                id = (String)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v3 = ((Function2)v2).invoke((Object)getReq, (Object)$continuation);
                if (v3 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl68
            }
            case 3: {
                id = (String)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl68:
                // 2 sources

                if ((getRes = (GetResponse)v3).getSourceAsBytesRef() == null) {
                    throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
                }
                parser = XContentHelper.createParser((NamedXContentRegistry)this.namedXContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getRes.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                Intrinsics.checkNotNull((Object)parser);
                return new GetReplicationMetadataResponse(ReplicationMetadata.Companion.fromXContent(parser), getRes.getSeqNo(), getRes.getPrimaryTerm());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GetReplicationMetadataResponse getMetadata(@NotNull GetReplicationMetadataRequest getMetadataReq, boolean fetch_from_primary, long timeout) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)getMetadataReq, (String)"getMetadataReq");
        String id = this.getId(getMetadataReq.getMetadataType(), getMetadataReq.getConnectionName(), getMetadataReq.getResourceName());
        if (!this.configStoreExists()) {
            throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
        }
        String[] stringArray = new String[]{REPLICATION_CONFIG_SYSTEM_INDEX};
        ClusterHealthRequest clusterHealthReq = new ClusterHealthRequest(stringArray).waitForYellowStatus();
        ClusterHealthResponse clusterHealthRes = (ClusterHealthResponse)this.client.admin().cluster().health(clusterHealthReq).actionGet(timeout);
        boolean bl2 = bl = clusterHealthRes.getStatus().compareTo((Enum)ClusterHealthStatus.YELLOW) <= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ReplicationMetadataStore$getMetadata$32 = false;
            String $i$a$-assert-ReplicationMetadataStore$getMetadata$32 = "Replication metadata store is unhealthy";
            throw new AssertionError((Object)$i$a$-assert-ReplicationMetadataStore$getMetadata$32);
        }
        GetRequest getReq = new GetRequest(REPLICATION_CONFIG_SYSTEM_INDEX, id);
        getReq.realtime(true);
        getReq.refresh(true);
        if (fetch_from_primary) {
            String string = this.getPreferenceOnPrimaryNode();
            if (string == null) {
                throw new IllegalStateException("Primary shard to fetch id[" + id + "] in index[.replication-metadata-store] doesn't exist");
            }
            String preference = string;
            getReq.preference(preference);
        }
        ThreadContext.StoredContext storedContext = null;
        try {
            storedContext = this.client.threadPool().getThreadContext().stashContext();
            GetResponse getRes2 = (GetResponse)this.client.get(getReq).actionGet(timeout);
            if (getRes2.getSourceAsBytesRef() == null) {
                throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
            }
            XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)this.namedXContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getRes2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
            Intrinsics.checkNotNull((Object)parser);
            GetReplicationMetadataResponse getReplicationMetadataResponse = new GetReplicationMetadataResponse(ReplicationMetadata.Companion.fromXContent(parser), getRes2.getSeqNo(), getRes2.getPrimaryTerm());
            return getReplicationMetadataResponse;
        }
        finally {
            block8: {
                ThreadContext.StoredContext storedContext2 = storedContext;
                if (storedContext2 == null) break block8;
                storedContext2.close();
            }
        }
    }

    private final String getPreferenceOnPrimaryNode() {
        String[] stringArray = new String[]{REPLICATION_CONFIG_SYSTEM_INDEX};
        GroupShardsIterator groupShardsIterator = this.clusterService.state().getRoutingTable().activePrimaryShardsGrouped(stringArray, false);
        Intrinsics.checkNotNullExpressionValue((Object)groupShardsIterator, (String)"activePrimaryShardsGrouped(...)");
        Iterable $this$forEach$iv = (Iterable)groupShardsIterator;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShardRouting shardRouting;
            Object v2;
            block2: {
                ShardIterator it = (ShardIterator)element$iv;
                boolean bl = false;
                List list = it.getShardRoutings();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getShardRoutings(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    ShardRouting shardRouting2 = (ShardRouting)element$iv2;
                    boolean bl2 = false;
                    if (!(shardRouting2.currentNodeId() != null)) continue;
                    v2 = element$iv2;
                    break block2;
                }
                v2 = null;
            }
            if ((shardRouting = (ShardRouting)v2) == null) continue;
            log.debug("_only_nodes to fetch metdata[.replication-metadata-store] - " + shardRouting.currentNodeId());
            return "_only_nodes:" + shardRouting.currentNodeId();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object deleteMetadata(@NotNull DeleteReplicationMetadataRequest var1_1, @NotNull Continuation<? super DeleteResponse> var2_2) {
        if (!(var2_2 instanceof deleteMetadata.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteMetadata(null, (Continuation<? super DeleteResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = this.getId(delMetadataReq.getMetadataType(), delMetadataReq.getConnectionName(), delMetadataReq.getResourceName());
                if (!this.configStoreExists()) {
                    throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.label = 1;
                v0 = this.checkAndWaitForStoreHealth((Continuation<? super Unit>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                id = (String)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                delReq = new DeleteRequest(".replication-metadata-store", id);
                $continuation.L$0 = delReq;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<DeleteRequest, ActionListener<DeleteResponse>, Unit>((Object)this.client){

                    public final void invoke(DeleteRequest p0, ActionListener<DeleteResponse> p1) {
                        ((Client)this.receiver).delete(p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl39
            }
            case 2: {
                delReq = (DeleteRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 3;
                v2 = ((Function2)v1).invoke((Object)delReq, (Object)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl48
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl48:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"invoke(...)");
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateMetadata(@NotNull UpdateReplicationMetadataRequest var1_1, @NotNull Continuation<? super IndexResponse> var2_2) {
        if (!(var2_2 instanceof updateMetadata.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateMetadata(null, (Continuation<? super IndexResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                metadata = updateMetadataReq.getReplicationMetadata();
                id = this.getId(metadata.getMetadataType(), metadata.getConnectionName(), metadata.getFollowerContext().getResource());
                if (!this.configStoreExists()) {
                    throw new ResourceNotFoundException("Metadata for " + id + " doesn't exist", new Object[0]);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = updateMetadataReq;
                $continuation.L$2 = id;
                $continuation.label = 1;
                v0 = this.checkAndWaitForStoreHealth((Continuation<? super Unit>)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                id = (String)$continuation.L$2;
                updateMetadataReq = (UpdateReplicationMetadataRequest)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = updateMetadataReq;
                $continuation.L$2 = id;
                $continuation.label = 2;
                v1 = this.checkAndUpdateMapping((Continuation<? super Unit>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                id = (String)$continuation.L$2;
                updateMetadataReq = (UpdateReplicationMetadataRequest)$continuation.L$1;
                this = (ReplicationMetadataStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                v2 = this.client.prepareIndex(".replication-metadata-store").setId(id);
                v3 = updateMetadataReq.getReplicationMetadata();
                v4 = XContentFactory.jsonBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"jsonBuilder(...)");
                v5 = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"EMPTY_PARAMS");
                indexReqBuilder = v2.setSource(v3.toXContent(v4, v5)).setIfSeqNo(updateMetadataReq.getIfSeqno()).setIfPrimaryTerm(updateMetadataReq.getIfPrimaryTerm());
                Intrinsics.checkNotNull((Object)indexReqBuilder);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v6 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<String, ActionListener<IndexResponse>, Unit>((Object)indexReqBuilder){

                    public final void invoke(@NotNull String p0, @NotNull ActionListener<IndexResponse> p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        ExtensionsKt.execute((IndexRequestBuilder)this.receiver, p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v6 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl63
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl63:
                // 2 sources

                $continuation.label = 4;
                v7 = ((Function2)v6).invoke((Object)"replication", (Object)$continuation);
                if (v7 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl71
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl71:
                // 2 sources

                return v7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getId(String metadataType, String connectionName, String resourceName) {
        Object id = resourceName;
        if (Intrinsics.areEqual((Object)metadataType, (Object)"AUTO_FOLLOW")) {
            boolean bl;
            boolean bl2 = bl = connectionName != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            id = connectionName + ":" + resourceName;
        }
        return id;
    }

    /*
     * Unable to fully structure code
     */
    private final Object createIndex(Continuation<? super CreateIndexResponse> var1_1) {
        if (!(var1_1 instanceof createIndex.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ReplicationMetadataStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ReplicationMetadataStore.access$createIndex(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                createIndexReq = new CreateIndexRequest(".replication-metadata-store", this.configStoreSettings()).mapping(ReplicationMetadataStore.REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING, XContentType.JSON);
                var3_6 = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"indices(...)");
                $continuation.L$0 = createIndexReq;
                $continuation.label = 1;
                v0 = CoroutinesKt.suspending$default(this.client, (Function2)new Function2<CreateIndexRequest, ActionListener<CreateIndexResponse>, Unit>((Object)var3_6){

                    public final void invoke(CreateIndexRequest p0, ActionListener<CreateIndexResponse> p1) {
                        ((IndicesAdminClient)this.receiver).create(p0, p1);
                    }
                }, false, true, (Continuation)$continuation, 2, null);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                createIndexReq = (CreateIndexRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = ((Function2)v0).invoke((Object)createIndexReq, (Object)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl34
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"invoke(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean configStoreExists() {
        return this.clusterService.state().routingTable().hasIndex(REPLICATION_CONFIG_SYSTEM_INDEX);
    }

    private final Settings configStoreSettings() {
        Settings settings = Settings.builder().put(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put(IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.getKey(), "0-1").put(IndexMetadata.INDEX_PRIORITY_SETTING.getKey(), Integer.MAX_VALUE).put(IndexMetadata.INDEX_HIDDEN_SETTING.getKey(), true).build();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"build(...)");
        return settings;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    private final Object checkAndWaitForStoreHealth(Continuation<? super Unit> $completion) {
        if (!this.configStoreExists()) {
            return Unit.INSTANCE;
        }
        String[] stringArray = new String[]{REPLICATION_CONFIG_SYSTEM_INDEX};
        ClusterHealthRequest clusterHealthReq = new ClusterHealthRequest(stringArray).waitForYellowStatus();
        ClusterHealthAction clusterHealthAction = ClusterHealthAction.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)clusterHealthAction, (String)"INSTANCE");
        ActionType actionType = (ActionType)clusterHealthAction;
        ActionRequest actionRequest = (ActionRequest)clusterHealthReq;
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        Object object = ExtensionsKt.suspendExecuteWithRetries$default(this.client, null, actionType, actionRequest, 0, 0L, 0L, 0.0, logger, null, false, true, $completion, 888, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$checkAndUpdateMapping(ReplicationMetadataStore $this, Continuation $completion) {
        return $this.checkAndUpdateMapping((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$createIndex(ReplicationMetadataStore $this, Continuation $completion) {
        return $this.createIndex((Continuation<? super CreateIndexResponse>)$completion);
    }

    public static final /* synthetic */ Object access$checkAndWaitForStoreHealth(ReplicationMetadataStore $this, Continuation $completion) {
        return $this.checkAndWaitForStoreHealth((Continuation<? super Unit>)$completion);
    }

    static {
        URL uRL = ReplicationMetadataStore.class.getClassLoader().getResource("mappings/replication-metadata-store.json");
        Intrinsics.checkNotNull((Object)uRL);
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING = new String(byArray, charset);
        REPLICATION_STORE_MAPPING_VERSION = ReplicationMetadataStore.Companion.getSchemaVersion(ReplicationMetadataStore.REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING);
        log = LogManager.getLogger(ReplicationMetadataStore.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/replication/metadata/store/ReplicationMetadataStore$Companion;", "", "()V", "DEFAULT_SCHEMA_VERSION", "", "MAPPING_META", "", "MAPPING_SCHEMA_VERSION", "MAPPING_TYPE", "REPLICATION_CONFIG_SYSTEM_INDEX", "REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING", "getREPLICATION_CONFIG_SYSTEM_INDEX_MAPPING", "()Ljava/lang/String;", "REPLICATION_STORE_MAPPING_VERSION", "getREPLICATION_STORE_MAPPING_VERSION", "()I", "setREPLICATION_STORE_MAPPING_VERSION", "(I)V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getSchemaVersion", "mapping", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getREPLICATION_CONFIG_SYSTEM_INDEX_MAPPING() {
            return REPLICATION_CONFIG_SYSTEM_INDEX_MAPPING;
        }

        public final int getREPLICATION_STORE_MAPPING_VERSION() {
            return REPLICATION_STORE_MAPPING_VERSION;
        }

        public final void setREPLICATION_STORE_MAPPING_VERSION(int n) {
            REPLICATION_STORE_MAPPING_VERSION = n;
        }

        private final int getSchemaVersion(String mapping) {
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (!Intrinsics.areEqual((Object)xcp.currentName(), (Object)ReplicationMetadataStore.MAPPING_META)) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (Intrinsics.areEqual((Object)xcp.currentName(), (Object)ReplicationMetadataStore.MAPPING_SCHEMA_VERSION)) {
                                int version = xcp.intValue();
                                if (!(version > -1)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

