/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.ScoringStrategy;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import lombok.Generated;

public class ThresholdedRandomCutForest {
    RCFComputeDescriptor lastAnomalyDescriptor;
    protected ForestMode forestMode = ForestMode.STANDARD;
    protected TransformMethod transformMethod = TransformMethod.NONE;
    protected ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
    protected RandomCutForest forest;
    protected PredictorCorrector predictorCorrector;
    protected IPreprocessor preprocessor;

    public ThresholdedRandomCutForest(Builder<?> builder) {
        this.forestMode = builder.forestMode;
        this.transformMethod = builder.transformMethod;
        this.scoringStrategy = builder.scoringStrategy;
        Object preprocessorBuilder = ((Preprocessor.Builder)((Preprocessor.Builder)Preprocessor.builder().shingleSize(builder.shingleSize)).transformMethod(builder.transformMethod)).forestMode(builder.forestMode);
        if (builder.forestMode == ForestMode.TIME_AUGMENTED) {
            int inputLength = builder.dimensions / builder.shingleSize;
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(inputLength);
            builder.dimensions += builder.shingleSize;
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(builder.normalizeTime);
            builder.internalShinglingEnabled = Optional.of(true);
        } else if (builder.forestMode == ForestMode.STREAMING_IMPUTE) {
            CommonUtils.checkArgument((builder.shingleSize > 1 ? 1 : 0) != 0, (String)" shingle size 1 is not useful in impute");
            int inputLength = builder.dimensions / builder.shingleSize;
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(inputLength);
            ((Preprocessor.Builder)preprocessorBuilder).imputationMethod(builder.imputationMethod);
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(true);
            if (builder.fillValues != null) {
                ((Preprocessor.Builder)preprocessorBuilder).fillValues(builder.fillValues);
            }
            builder.internalShinglingEnabled = Optional.of(false);
            ((Preprocessor.Builder)preprocessorBuilder).useImputedFraction(builder.useImputedFraction.orElse(0.5));
        } else {
            boolean smallInput = builder.internalShinglingEnabled.orElse(false);
            int inputLength = smallInput ? builder.dimensions / builder.shingleSize : builder.dimensions;
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(inputLength);
        }
        this.forest = builder.buildForest();
        this.validateNonNegativeArray(builder.weights);
        ((Preprocessor.Builder)preprocessorBuilder).weights(builder.weights);
        ((Preprocessor.Builder)preprocessorBuilder).weightTime(builder.weightTime.orElse(1.0));
        ((Preprocessor.Builder)preprocessorBuilder).timeDecay(builder.transformDecay.orElse(1.0 / (double)builder.sampleSize));
        ((Preprocessor.Builder)preprocessorBuilder).randomSeed(builder.randomSeed.orElse(0L) + 1L);
        ((Preprocessor.Builder)preprocessorBuilder).dimensions(builder.dimensions);
        ((Preprocessor.Builder)preprocessorBuilder).stopNormalization(builder.stopNormalization.orElse(Preprocessor.DEFAULT_STOP_NORMALIZATION));
        ((Preprocessor.Builder)preprocessorBuilder).startNormalization(builder.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION));
        this.preprocessor = ((Preprocessor.Builder)preprocessorBuilder).build();
        this.predictorCorrector = new PredictorCorrector(this.forest.getTimeDecay(), builder.anomalyRate, builder.autoAdjust, builder.dimensions / builder.shingleSize, builder.randomSeed.orElse(0L));
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, 0L, builder.forestMode, builder.transformMethod, builder.imputationMethod);
        this.predictorCorrector.setAbsoluteThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_ABSOLUTE_THRESHOLD));
        this.predictorCorrector.setZfactor(builder.zFactor);
        this.predictorCorrector.setScoreDifferencing(builder.scoreDifferencing.orElse(BasicThresholder.DEFAULT_SCORE_DIFFERENCING));
        builder.ignoreNearExpectedFromAbove.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromAbove);
        builder.ignoreNearExpectedFromBelow.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromBelow);
        builder.ignoreNearExpectedFromAboveByRatio.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromAboveByRatio);
        builder.ignoreNearExpectedFromBelowByRatio.ifPresent(this.predictorCorrector::setIgnoreNearExpectedFromBelowByRatio);
        this.predictorCorrector.setLastStrategy(builder.scoringStrategy);
        this.predictorCorrector.setIgnoreDrift(builder.alertOnceInDrift);
    }

    void validateNonNegativeArray(double[] array) {
        if (array != null) {
            for (double element : array) {
                CommonUtils.checkArgument((element >= 0.0 ? 1 : 0) != 0, (String)" has to be non-negative");
            }
        }
    }

    public ThresholdedRandomCutForest(ForestMode forestMode, TransformMethod transformMethod, ScoringStrategy scoringStrategy, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor) {
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
        this.scoringStrategy = scoringStrategy;
        this.forest = forest;
        this.predictorCorrector = predictorCorrector;
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = descriptor;
    }

    public ThresholdedRandomCutForest(RandomCutForest forest, double futureAnomalyRate, List<Double> values) {
        this.forest = forest;
        int dimensions = forest.getDimensions();
        int inputLength = forest.isInternalShinglingEnabled() ? dimensions / forest.getShingleSize() : forest.getDimensions();
        Preprocessor preprocessor = ((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)new Preprocessor.Builder().transformMethod(TransformMethod.NONE)).dimensions(dimensions)).shingleSize(forest.getShingleSize())).inputLength(inputLength)).build();
        this.predictorCorrector = new PredictorCorrector(new BasicThresholder(values, futureAnomalyRate), inputLength);
        preprocessor.setValuesSeen((int)forest.getTotalUpdates());
        preprocessor.getDataQuality()[0].update(1.0);
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, forest.getTotalUpdates());
    }

    protected <T extends AnomalyDescriptor> boolean saveDescriptor(T lastDescriptor) {
        return lastDescriptor.getAnomalyGrade() > 0.0;
    }

    public <T extends AnomalyDescriptor> T singleStepProcess(T input, IPreprocessor preprocessor, Function<T, T> core) {
        return (T)preprocessor.postProcess((AnomalyDescriptor)core.apply(preprocessor.preProcess(input, this.lastAnomalyDescriptor, this.forest)), this.lastAnomalyDescriptor, this.forest);
    }

    public AnomalyDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnomalyDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        Function<AnomalyDescriptor, AnomalyDescriptor> function = x -> this.predictorCorrector.detect(x, this.lastAnomalyDescriptor, this.forest);
        AnomalyDescriptor description = new AnomalyDescriptor(inputPoint, timestamp);
        description.setScoringStrategy(this.scoringStrategy);
        boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            if (missingValues != null) {
                CommonUtils.checkArgument((missingValues.length <= inputPoint.length ? 1 : 0) != 0, (String)" incorrect data");
                for (int i = 0; i < missingValues.length; ++i) {
                    CommonUtils.checkArgument((missingValues[i] >= 0 && missingValues[i] < inputPoint.length ? 1 : 0) != 0, (String)" incorrect positions ");
                }
                description.setMissingValues(missingValues);
            }
            description = this.singleStepProcess(description, this.preprocessor, function);
        }
        finally {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        if (this.saveDescriptor(description)) {
            this.lastAnomalyDescriptor = description.copyOf();
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnomalyDescriptor> processSequentially(double[][] data, Function<AnomalyDescriptor, Boolean> filter) {
        ArrayList<AnomalyDescriptor> answer = new ArrayList<AnomalyDescriptor>();
        Function<AnomalyDescriptor, AnomalyDescriptor> function = x -> this.predictorCorrector.detect(x, this.lastAnomalyDescriptor, this.forest);
        if (data != null && data.length > 0) {
            boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
            try {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(1.0);
                }
                long timestamp = this.preprocessor.getInternalTimeStamp();
                int length = this.preprocessor.getInputLength();
                for (double[] point : data) {
                    CommonUtils.checkArgument((point.length == length ? 1 : 0) != 0, (String)" nonuniform lengths ");
                    AnomalyDescriptor description = new AnomalyDescriptor(point, timestamp++);
                    description.setScoringStrategy(this.scoringStrategy);
                    description = this.singleStepProcess(description, this.preprocessor, function);
                    if (this.saveDescriptor(description)) {
                        this.lastAnomalyDescriptor = description.copyOf();
                    }
                    if (!filter.apply(description).booleanValue()) continue;
                    answer.add(description);
                }
            }
            finally {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(0.0);
                }
            }
        }
        return answer;
    }

    public List<AnomalyDescriptor> processSequentially(double[][] data) {
        return this.processSequentially(data, x -> x.anomalyGrade > 0.0);
    }

    public TimedRangeVector extrapolate(int horizon, boolean correct, double centrality) {
        int shingleSize = this.preprocessor.getShingleSize();
        CommonUtils.checkArgument((shingleSize > 1 ? 1 : 0) != 0, (String)"extrapolation is not meaningful for shingle size = 1");
        int dimensions = this.forest.getDimensions();
        int blockSize = dimensions / shingleSize;
        double[] lastPoint = this.preprocessor.getLastShingledPoint();
        if (this.forest.isOutputReady()) {
            int gap = (int)((long)this.preprocessor.getInternalTimeStamp() - this.lastAnomalyDescriptor.getInternalTimeStamp());
            float[] newPoint = CommonUtils.toFloatArray((double[])lastPoint);
            if (gap <= shingleSize && correct && this.lastAnomalyDescriptor.getExpectedRCFPoint() != null) {
                newPoint = gap == 1 ? CommonUtils.toFloatArray((double[])this.lastAnomalyDescriptor.getExpectedRCFPoint()) : this.predictorCorrector.applyPastCorrector(newPoint, gap, shingleSize, blockSize, this.preprocessor.getScale(), this.transformMethod, this.lastAnomalyDescriptor);
            }
            RangeVector answer = this.forest.extrapolateFromShingle(newPoint, horizon, blockSize, centrality);
            return this.preprocessor.invertForecastRange(answer, this.lastAnomalyDescriptor);
        }
        return new TimedRangeVector(new TimedRangeVector(horizon * blockSize, horizon));
    }

    public TimedRangeVector extrapolate(int horizon) {
        return this.extrapolate(horizon, true, 1.0);
    }

    public RandomCutForest getForest() {
        return this.forest;
    }

    public void setZfactor(double factor) {
        this.predictorCorrector.setZfactor(factor);
    }

    public void setLowerThreshold(double lower) {
        this.predictorCorrector.setAbsoluteThreshold(lower);
    }

    @Deprecated
    public void setHorizon(double horizon) {
        this.predictorCorrector.setScoreDifferencing(1.0 - horizon);
    }

    public void setScoreDifferencing(double scoreDifferencing) {
        this.predictorCorrector.setScoreDifferencing(scoreDifferencing);
    }

    public void setIgnoreNearExpectedFromAbove(double[] ignoreSimilarFromAbove) {
        this.predictorCorrector.setIgnoreNearExpectedFromAbove(ignoreSimilarFromAbove);
    }

    public void setIgnoreNearExpectedFromAboveByRatio(double[] ignoreSimilarFromAbove) {
        this.predictorCorrector.setIgnoreNearExpectedFromAboveByRatio(ignoreSimilarFromAbove);
    }

    public void setIgnoreNearExpectedFromBelow(double[] ignoreSimilarFromBelow) {
        this.predictorCorrector.setIgnoreNearExpectedFromBelow(ignoreSimilarFromBelow);
    }

    public void setIgnoreNearExpectedFromBelowByRatio(double[] ignoreSimilarFromBelow) {
        this.predictorCorrector.setIgnoreNearExpectedFromBelowByRatio(ignoreSimilarFromBelow);
    }

    public void setScoringStrategy(ScoringStrategy strategy) {
        this.scoringStrategy = strategy;
    }

    @Deprecated
    public void setInitialThreshold(double initial) {
        this.predictorCorrector.setInitialThreshold(initial);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public RCFComputeDescriptor getLastAnomalyDescriptor() {
        return this.lastAnomalyDescriptor;
    }

    @Generated
    public ForestMode getForestMode() {
        return this.forestMode;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    @Generated
    public PredictorCorrector getPredictorCorrector() {
        return this.predictorCorrector;
    }

    @Generated
    public IPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    @Generated
    public void setLastAnomalyDescriptor(RCFComputeDescriptor lastAnomalyDescriptor) {
        this.lastAnomalyDescriptor = lastAnomalyDescriptor;
    }

    @Generated
    public void setForestMode(ForestMode forestMode) {
        this.forestMode = forestMode;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setForest(RandomCutForest forest) {
        this.forest = forest;
    }

    @Generated
    public void setPredictorCorrector(PredictorCorrector predictorCorrector) {
        this.predictorCorrector = predictorCorrector;
    }

    @Generated
    public void setPreprocessor(IPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int sampleSize = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected Optional<Integer> startNormalization = Optional.empty();
        protected Optional<Integer> stopNormalization = Optional.empty();
        protected int numberOfTrees = 50;
        protected Optional<Double> timeDecay = Optional.empty();
        protected Optional<Double> scoreDifferencing = Optional.empty();
        protected Optional<Double> lowerThreshold = Optional.empty();
        protected Optional<Double> weightTime = Optional.empty();
        protected Optional<Long> randomSeed = Optional.empty();
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected boolean parallelExecutionEnabled = false;
        protected Optional<Integer> threadPoolSize = Optional.empty();
        protected Precision precision = RandomCutForest.DEFAULT_PRECISION;
        protected double boundingBoxCacheFraction = 1.0;
        protected int shingleSize = 1;
        protected Optional<Boolean> internalShinglingEnabled = Optional.empty();
        protected double initialAcceptFraction = 1.0;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
        protected boolean normalizeTime = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected boolean autoAdjust = false;
        protected double zFactor = BasicThresholder.DEFAULT_Z_FACTOR;
        protected boolean alertOnceInDrift = false;
        protected Optional<Double> transformDecay = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromAbove = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromBelow = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromAboveByRatio = Optional.empty();
        protected Optional<double[]> ignoreNearExpectedFromBelowByRatio = Optional.empty();

        void validate() {
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                if (this.internalShinglingEnabled.isPresent()) {
                    CommonUtils.checkArgument((this.shingleSize == 1 || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" shingle size has to be 1 or internal shingling must turned on");
                    CommonUtils.checkArgument((this.transformMethod == TransformMethod.NONE || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" internal shingling must turned on for transforms");
                } else {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            } else if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                CommonUtils.checkArgument((this.shingleSize > 1 ? 1 : 0) != 0, (String)"imputation with shingle size 1 is not meaningful");
                this.internalShinglingEnabled.ifPresent(x -> CommonUtils.checkArgument((boolean)x, (String)" input cannot be shingled (even if internal representation is different) "));
            } else {
                if (!this.internalShinglingEnabled.isPresent()) {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            }
            if (this.startNormalization.isPresent()) {
                if (this.outputAfter.isPresent()) {
                    CommonUtils.checkArgument((this.outputAfter.get() + this.shingleSize - 1 > this.startNormalization.get() ? 1 : 0) != 0, (String)"output after has to wait till normalization, reduce normalization");
                } else {
                    int n = this.startNormalization.get();
                    CommonUtils.checkArgument((n > 0 ? 1 : 0) != 0, (String)" startNormalization has to be positive");
                    this.outputAfter = Optional.of(Math.max(Math.max(1, (int)((double)this.sampleSize * 0.25)), n - this.shingleSize + 1));
                }
            } else if (this.outputAfter.isPresent()) {
                this.startNormalization = Optional.of(Math.min(Preprocessor.DEFAULT_START_NORMALIZATION, this.outputAfter.get()));
            }
        }

        public ThresholdedRandomCutForest build() {
            this.validate();
            return new ThresholdedRandomCutForest(this);
        }

        protected RandomCutForest buildForest() {
            RandomCutForest.Builder builder = new RandomCutForest.Builder().dimensions(this.dimensions).sampleSize(this.sampleSize).numberOfTrees(this.numberOfTrees).compact(true).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled).centerOfMassEnabled(this.centerOfMassEnabled).parallelExecutionEnabled(this.parallelExecutionEnabled).precision(this.precision).boundingBoxCacheFraction(this.boundingBoxCacheFraction).shingleSize(this.shingleSize).internalShinglingEnabled(this.internalShinglingEnabled.get().booleanValue()).initialAcceptFraction(this.initialAcceptFraction);
            if (this.forestMode != ForestMode.STREAMING_IMPUTE) {
                this.outputAfter.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).outputAfter(arg_0));
            } else {
                this.outputAfter.ifPresent(n -> {
                    int num = Math.max(this.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION), n) - this.shingleSize + 1;
                    CommonUtils.checkArgument((num > 0 ? 1 : 0) != 0, (String)(" max(start normalization, output after) should be at least " + this.shingleSize));
                    builder.outputAfter(num);
                });
            }
            this.timeDecay.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).timeDecay(arg_0));
            this.randomSeed.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).randomSeed(arg_0));
            this.threadPoolSize.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).threadPoolSize(arg_0));
            return builder.build();
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = Optional.of(startNormalization);
            return (T)this;
        }

        public T stopNormalization(int stopNormalization) {
            this.stopNormalization = Optional.of(stopNormalization);
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T transformDecay(double transformDecay) {
            this.transformDecay = Optional.of(transformDecay);
            return (T)this;
        }

        public T zFactor(double zFactor) {
            this.zFactor = zFactor;
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        @Deprecated
        public T compact(boolean compact) {
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = Optional.of(internalShinglingEnabled);
            return (T)this;
        }

        public T precision(Precision precision) {
            this.precision = precision;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }

        public T anomalyRate(double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T scoreDifferencing(double persistence) {
            this.scoreDifferencing = Optional.of(persistence);
            return (T)this;
        }

        public T autoAdjust(boolean autoAdjust) {
            this.autoAdjust = autoAdjust;
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = Optional.of(value);
            return (T)this;
        }

        public T ignoreNearExpectedFromAbove(double[] ignoreSimilarFromAbove) {
            this.ignoreNearExpectedFromAbove = Optional.ofNullable(ignoreSimilarFromAbove);
            return (T)this;
        }

        public T ignoreNearExpectedFromBelow(double[] ignoreSimilarFromBelow) {
            this.ignoreNearExpectedFromBelow = Optional.ofNullable(ignoreSimilarFromBelow);
            return (T)this;
        }

        public T ignoreNearExpectedFromAboveByRatio(double[] ignoreSimilarFromAboveByRatio) {
            this.ignoreNearExpectedFromAboveByRatio = Optional.ofNullable(ignoreSimilarFromAboveByRatio);
            return (T)this;
        }

        public T ignoreNearExpectedFromBelowByRatio(double[] ignoreSimilarFromBelowByRatio) {
            this.ignoreNearExpectedFromBelowByRatio = Optional.ofNullable(ignoreSimilarFromBelowByRatio);
            return (T)this;
        }

        public T scoringStrategy(ScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return (T)this;
        }

        public T alertOnce(boolean alertOnceInDrift) {
            this.alertOnceInDrift = alertOnceInDrift;
            return (T)this;
        }
    }
}

