/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.action.StepListener;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationTarget;

public class SegmentReplicationTarget
extends ReplicationTarget {
    private final ReplicationCheckpoint checkpoint;
    private final SegmentReplicationSource source;
    private final SegmentReplicationState state;
    protected final MultiFileWriter multiFileWriter;
    public static final String REPLICATION_PREFIX = "replication.";

    public SegmentReplicationTarget(IndexShard indexShard, ReplicationCheckpoint checkpoint, SegmentReplicationSource source, ReplicationListener listener) {
        super("replication_target", indexShard, new ReplicationLuceneIndex(), listener);
        this.checkpoint = checkpoint;
        this.source = source;
        this.state = new SegmentReplicationState(indexShard.routingEntry(), this.stateIndex, this.getId(), source.getDescription(), indexShard.recoveryState().getTargetNode());
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, this.getPrefix(), this.logger, () -> this.ensureRefCount());
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            super.closeInternal();
        }
    }

    @Override
    protected void onCancel(String reason) {
        try {
            this.notifyListener(new ReplicationFailedException(reason), false);
        }
        finally {
            this.source.cancel();
            this.cancellableThreads.cancel(reason);
        }
    }

    @Override
    protected String getPrefix() {
        return REPLICATION_PREFIX + UUIDs.randomBase64UUID() + ".";
    }

    @Override
    protected void onDone() {
        this.state.setStage(SegmentReplicationState.Stage.DONE);
    }

    @Override
    public SegmentReplicationState state() {
        return this.state;
    }

    @Override
    public SegmentReplicationTarget retryCopy() {
        return new SegmentReplicationTarget(this.indexShard, this.checkpoint, this.source, this.listener);
    }

    @Override
    public String description() {
        return String.format(Locale.ROOT, "Id:[%d] Checkpoint [%s] Shard:[%s] Source:[%s]", this.getId(), this.getCheckpoint(), this.shardId(), this.source.getDescription());
    }

    @Override
    public void notifyListener(ReplicationFailedException e, boolean sendShardFailure) {
        this.listener.onFailure(this.state(), e, sendShardFailure);
    }

    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        return false;
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.multiFileWriter.writeFileChunk(metadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void startReplication(ActionListener<Void> listener, BiConsumer<ReplicationCheckpoint, IndexShard> checkpointUpdater) {
        this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
            throw new CancellableThreads.ExecutionCancelledException("replication was canceled reason [" + reason + "]");
        });
        this.state.setStage(SegmentReplicationState.Stage.REPLICATING);
        StepListener checkpointInfoListener = new StepListener();
        StepListener getFilesListener = new StepListener();
        this.logger.trace((Message)new ParameterizedMessage("Starting Replication Target: {}", (Object)this.description()));
        this.state.setStage(SegmentReplicationState.Stage.GET_CHECKPOINT_INFO);
        this.cancellableThreads.checkForCancel();
        this.source.getCheckpointMetadata(this.getId(), this.checkpoint, (ActionListener<CheckpointInfoResponse>)checkpointInfoListener);
        checkpointInfoListener.whenComplete(checkpointInfo -> {
            checkpointUpdater.accept(checkpointInfo.getCheckpoint(), this.indexShard);
            List<StoreFileMetadata> filesToFetch = this.getFiles((CheckpointInfoResponse)((Object)checkpointInfo));
            this.state.setStage(SegmentReplicationState.Stage.GET_FILES);
            this.cancellableThreads.checkForCancel();
            this.source.getSegmentFiles(this.getId(), checkpointInfo.getCheckpoint(), filesToFetch, this.indexShard, this::updateFileRecoveryBytes, (ActionListener<GetSegmentFilesResponse>)getFilesListener);
        }, arg_0 -> listener.onFailure(arg_0));
        getFilesListener.whenComplete(response -> {
            this.finalizeReplication((CheckpointInfoResponse)((Object)((Object)checkpointInfoListener.result())));
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private List<StoreFileMetadata> getFiles(CheckpointInfoResponse checkpointInfo) throws IOException {
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FILE_DIFF);
        if (this.indexShard.indexSettings().isWarmIndex()) {
            return Collections.emptyList();
        }
        Store.RecoveryDiff diff = Store.segmentReplicationDiff(checkpointInfo.getMetadataMap(), this.indexShard.getSegmentMetadataMap());
        Set<String> localFiles = Set.of(this.indexShard.store().directory().listAll());
        Set reuseFiles = diff.missing.stream().filter(storeFileMetadata -> localFiles.contains(storeFileMetadata.name())).filter(this::validateLocalChecksum).map(StoreFileMetadata::name).collect(Collectors.toSet());
        List<StoreFileMetadata> missingFiles = diff.missing.stream().filter(md -> !reuseFiles.contains(md.name())).collect(Collectors.toList());
        this.logger.trace(() -> new ParameterizedMessage("Replication diff for checkpoint {} {} {}", new Object[]{checkpointInfo.getCheckpoint(), missingFiles, diff.different}));
        if (!diff.different.isEmpty()) {
            throw new OpenSearchCorruptionException(new ParameterizedMessage("Shard {} has local copies of segments that differ from the primary {}", (Object)this.indexShard.shardId(), diff.different).getFormattedMessage());
        }
        for (StoreFileMetadata file : missingFiles) {
            this.state.getIndex().addFileDetail(file.name(), file.length(), false);
        }
        return missingFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateLocalChecksum(StoreFileMetadata file) {
        try (IndexInput indexInput = this.indexShard.store().directory().openInput(file.name(), IOContext.READONCE);){
            String checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
            if (file.checksum().equals(checksum)) {
                boolean bl2 = true;
                return bl2;
            }
            this.store.deleteQuiet(file.name());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logger.warn("Error reading " + String.valueOf(file), (Throwable)e);
            try {
                this.indexShard.store().directory().deleteFile(file.name());
                return false;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Error reading " + String.valueOf(file), e);
            }
        }
    }

    private void updateFileRecoveryBytes(String fileName, long bytesRecovered) {
        ReplicationLuceneIndex index = this.state.getIndex();
        if (index != null) {
            index.addRecoveredBytesToFile(fileName, bytesRecovered);
        }
        this.setLastAccessTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeReplication(CheckpointInfoResponse checkpointInfoResponse) throws OpenSearchCorruptionException {
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FINALIZE_REPLICATION);
        if (checkpointInfoResponse.getInfosBytes() == null) {
            return;
        }
        Store store = null;
        try {
            store = this.store();
            store.incRef();
            this.multiFileWriter.renameAllTempFiles();
            SegmentInfos infos = store.buildSegmentInfos(checkpointInfoResponse.getInfosBytes(), checkpointInfoResponse.getCheckpoint().getSegmentsGen());
            this.indexShard.finalizeReplication(infos);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            try {
                try {
                    store.removeCorruptionMarker();
                }
                finally {
                    Lucene.cleanLuceneIndex(store.directory());
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to clean lucene index", (Throwable)e);
                ex.addSuppressed(e);
            }
            throw new OpenSearchCorruptionException(ex);
        }
        catch (AlreadyClosedException ex) {
            this.logger.warn("Shard is already closed, closing replication");
        }
        catch (CancellableThreads.ExecutionCancelledException ex) {
            assert (this.cancellableThreads.isCancelled()) : "Replication target cancelled but cancellable threads not cancelled";
        }
        catch (Exception ex) {
            throw new ReplicationFailedException(ex);
        }
        finally {
            if (store != null) {
                store.decRef();
            }
        }
    }
}

