/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.AccumulativeRunnable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class SwingWorker<T, V>
implements Future<T>,
Runnable {
    private static final int MAX_WORKER_THREADS = 10;
    private volatile int progress;
    private volatile StateValue state;
    private final FutureTask<T> future;
    private final PropertyChangeSupport propertyChangeSupport;
    private AccumulativeRunnable<V> doProcess;
    private AccumulativeRunnable<Integer> doNotifyProgressChange;
    private static final AccumulativeRunnable<Runnable> doSubmit = new DoSubmitAccumulativeRunnable();
    private static ExecutorService executorService = null;

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setState(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.doneEDT();
                SwingWorker.this.setState(StateValue.DONE);
            }
        };
        this.state = StateValue.PENDING;
        this.propertyChangeSupport = new SwingWorkerPropertyChangeSupport(this);
        this.doProcess = null;
        this.doNotifyProgressChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.future.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... chunks) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doProcess == null) {
                this.doProcess = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(List<V> args2) {
                        SwingWorker.this.process(args2);
                    }

                    @Override
                    protected void submit() {
                        doSubmit.add(this);
                    }
                };
            }
        }
        this.doProcess.add(chunks);
    }

    protected void process(List<V> chunks) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        if (this.progress == progress) {
            return;
        }
        int oldProgress = this.progress;
        this.progress = progress;
        if (!this.getPropertyChangeSupport().hasListeners("progress")) {
            return;
        }
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doNotifyProgressChange == null) {
                this.doNotifyProgressChange = new AccumulativeRunnable<Integer>(){

                    @Override
                    public void run(List<Integer> args2) {
                        SwingWorker.this.firePropertyChange("progress", args2.get(0), args2.get(args2.size() - 1));
                    }

                    @Override
                    protected void submit() {
                        doSubmit.add(this);
                    }
                };
            }
        }
        this.doNotifyProgressChange.add((Integer[])new Integer[]{oldProgress, progress});
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void execute() {
        SwingWorker.getWorkersExecutorService().execute(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout2, unit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.state;
    }

    private void setState(StateValue state) {
        StateValue old = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)old, (Object)state);
    }

    private void doneEDT() {
        Runnable doDone = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doDone.run();
        } else {
            doSubmit.add((Runnable[])new Runnable[]{doDone});
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        if (executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    StringBuilder name = new StringBuilder("SwingWorker-pool-");
                    name.append(System.identityHashCode(this));
                    name.append("-thread-");
                    name.append(this.threadNumber.getAndIncrement());
                    Thread t = new Thread(r, name.toString());
                    if (t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            executorService = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock pauseLock = new ReentrantLock();
                private final Condition unpaused = this.pauseLock.newCondition();
                private boolean isPaused = false;
                private final ReentrantLock executeLock = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(Runnable command) {
                    this.executeLock.lock();
                    try {
                        this.pauseLock.lock();
                        try {
                            this.isPaused = true;
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(command);
                        this.setCorePoolSize(0);
                        this.pauseLock.lock();
                        try {
                            this.isPaused = false;
                            this.unpaused.signalAll();
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                    }
                    finally {
                        this.executeLock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void afterExecute(Runnable r, Throwable t) {
                    super.afterExecute(r, t);
                    this.pauseLock.lock();
                    try {
                        while (this.isPaused) {
                            this.unpaused.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.pauseLock.unlock();
                    }
                }
            };
        }
        return executorService;
    }

    private class SwingWorkerPropertyChangeSupport
    extends PropertyChangeSupport {
        SwingWorkerPropertyChangeSupport(Object source2) {
            super(source2);
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(evt);
            } else {
                doSubmit.add(new Runnable(){

                    @Override
                    public void run() {
                        SwingWorkerPropertyChangeSupport.this.firePropertyChange(evt);
                    }
                });
            }
        }
    }

    private static class DoSubmitAccumulativeRunnable
    extends AccumulativeRunnable<Runnable>
    implements ActionListener {
        private static final int DELAY = 33;

        private DoSubmitAccumulativeRunnable() {
        }

        @Override
        protected void run(List<Runnable> args2) {
            for (Runnable runnable2 : args2) {
                runnable2.run();
            }
        }

        @Override
        protected void submit() {
            Timer timer = new Timer(33, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.run();
        }
    }

    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

