/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.ejt.internal.gui.LookAndFeelChangeUtil;
import com.ejt.internal.gui.ScreenSizeUtil;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.UIManager;

public abstract class CustomDialog
extends JDialog {
    protected CustomDialog(Window parentWindow) {
        super(parentWindow);
        UiUtil.getLookAndFeelEnhancer().prepareWindow(this);
        LookAndFeelChangeUtil.registerWindow(this);
        LookAndFeelChangeUtil.onLookAndFeelChangeAndNow(this, CustomDialog::updateTitleBar);
        if (Util.isMacOS()) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    CustomDialog.this.repaint();
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    CustomDialog.this.repaint();
                }
            });
        } else if (Util.isLinux()) {
            this.addWindowListener(new WindowAdapter(){
                boolean activated = false;

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!this.activated) {
                        this.activated = true;
                        CustomDialog.this.setBounds(CustomDialog.this.getFrameBounds());
                    }
                }
            });
        }
    }

    private void updateTitleBar() {
        this.getRootPane().putClientProperty("JRootPane.titleBarBackground", this.getTitlePaneBackgroundColor());
    }

    protected Color getTitlePaneBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    protected abstract int getFrameHeight();

    protected abstract int getFrameWidth();

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GUIHelper.applyComponentOrientation(this);
        }
        super.setVisible(visible);
    }

    public Rectangle getFrameBounds() {
        float factor = 1.0f;
        if (InstallerUtil.isLinux() || InstallerUtil.isSolaris()) {
            factor = 1.2f;
        }
        int width = (int)(factor * (float)this.getFrameWidth());
        int height = (int)(factor * (float)this.getFrameHeight());
        if (width < 0 || height < 0) {
            this.pack();
            if (width < 0) {
                width = Math.max(-width, this.getWidth());
            }
            if (height < 0) {
                height = Math.max(-height, this.getHeight());
            }
        }
        return this.getFrameBounds(width, height);
    }

    public Rectangle getFrameBounds(int width, int height) {
        return ScreenSizeUtil.getFrameBounds(width, height, this.getParentWindow());
    }

    public Window getParentWindow() {
        return (Window)this.getParent();
    }

    @Override
    protected JRootPane createRootPane() {
        if (Util.isMacOS() && VersionCheck.checkCompatible("10.11", InstallerUtil.OS_VERSION)) {
            JRootPane rootPane = new JRootPane(){

                @Override
                public void setDefaultButton(JButton defaultButton) {
                    if (defaultButton != null) {
                        Color oldForeground = defaultButton.getForeground();
                        Color correctedForeground = Color.WHITE;
                        defaultButton.setForeground(correctedForeground);
                        defaultButton.addPropertyChangeListener("Frame.active", event -> defaultButton.setForeground((Boolean)event.getNewValue() != false ? correctedForeground : oldForeground));
                    }
                    super.setDefaultButton(defaultButton);
                }
            };
            rootPane.setOpaque(true);
            return rootPane;
        }
        return super.createRootPane();
    }
}

