/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.launching.DirectOutputRedirection;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VolumeInfo {
    private static final String DOWNLOAD_SUFFIX = ".download";

    public static Map<String, String> getMountPointToDiskFile() {
        HashMap<String, String> mountPointToDiskFile = new HashMap<String, String>();
        StringBuffer output = new StringBuffer();
        try {
            int returnCode = Execution.executeWithReturnCode(new String[]{"/usr/bin/hdiutil", "info", "-plist"}, output, true);
            if (returnCode != 0) {
                return mountPointToDiskFile;
            }
            Document document = XmlHelper.parseString(output.toString(), false, false);
            Element element = document.getDocumentElement();
            element = PlistHelper.getFirstChild(PlistHelper.getFirstChild(element, "dict"), "array");
            block6: for (Element diskImageElement : XmlHelper.childElements(element)) {
                try {
                    String imagePath = XmlHelper.getTextValue(PlistHelper.findValue(diskImageElement, "image-path"));
                    Element systemEntities = PlistHelper.findValue(diskImageElement, "system-entities");
                    for (Element dictElement : XmlHelper.childElements(systemEntities)) {
                        try {
                            String mountPoint = XmlHelper.getTextValue(PlistHelper.findValue(dictElement, "mount-point"));
                            String path = VolumeInfo.removeDownloadSuffix(imagePath);
                            mountPointToDiskFile.put(mountPoint, path);
                            Logger.getInstance().info(VolumeInfo.class, "image: " + path + ", mountPoint: " + mountPoint);
                            continue block6;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (Exception e) {
                    Logger.getInstance().info(VolumeInfo.class, "Could not get volume info: " + e);
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance().error(VolumeInfo.class, "Could not get volume info: " + e);
        }
        return mountPointToDiskFile;
    }

    private static String removeDownloadSuffix(String imagePath) {
        File parentFile = new File(imagePath).getParentFile();
        if (parentFile.getName().endsWith(DOWNLOAD_SUFFIX)) {
            String path = parentFile.getAbsolutePath();
            return path.substring(0, path.length() - DOWNLOAD_SUFFIX.length());
        }
        return imagePath;
    }

    @Nullable
    public static File attachDmg(File dmgFile, boolean noBrowse) throws IOException {
        String mountPoint;
        Logger.getExistingInstance().info(null, "mounting dmg");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("attach");
        if (noBrowse) {
            arguments.add("-nobrowse");
        }
        arguments.add(dmgFile.getAbsolutePath());
        arguments.add("-plist");
        LaunchHelper.LaunchResult launchResult = LaunchHelper.launchApplicationWithResult(new LaunchDescriptor(new File("/usr/bin/hdiutil")).arguments(arguments).wait(true).stdoutRedirection(new DirectOutputRedirection()));
        if (launchResult == null) {
            Logger.getInstance().error(null, "could not execute hdiutil");
            return null;
        }
        if (launchResult.getReturnCode() == 0 && launchResult.getOutput() != null && (mountPoint = VolumeInfo.parseMountPoint(launchResult.getOutput())) != null) {
            return new File(mountPoint);
        }
        return null;
    }

    @Nullable
    public static File findAttachedDmg(File dmgFile) throws IOException {
        Map<String, String> mountPointToDiskFile = VolumeInfo.getMountPointToDiskFile();
        if (mountPointToDiskFile != null) {
            for (int tryCount = 0; tryCount < 5; ++tryCount) {
                for (Map.Entry<String, String> entry : mountPointToDiskFile.entrySet()) {
                    if (!Objects.equals(new File(entry.getValue()).getCanonicalFile(), dmgFile.getCanonicalFile())) continue;
                    File mountPoint = new File(entry.getKey());
                    for (int dirTryCount = 0; !mountPoint.isDirectory() && dirTryCount < 5; ++dirTryCount) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return mountPoint;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                mountPointToDiskFile = VolumeInfo.getMountPointToDiskFile();
            }
            Logger.getInstance().error(null, "could not find mount point");
        } else {
            Logger.getInstance().error(null, "could not mount dmg file or retrieve mount points");
        }
        return null;
    }

    private static String parseMountPoint(String attachOutput) {
        try {
            Document document = XmlHelper.parseString(attachOutput, false, false);
            Element arrayElement = PlistHelper.getFirstChild(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "array");
            for (Element partitionElement : XmlHelper.childElements(arrayElement)) {
                try {
                    return XmlHelper.getTextValue(PlistHelper.findValue(partitionElement, "mount-point"));
                }
                catch (PlistHelper.NotFoundException notFoundException) {
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
        }
        return null;
    }

    public static boolean detach(File mountPoint) {
        Integer ret = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/hdiutil")).arguments("detach", mountPoint.getAbsolutePath()).wait(true));
        return ret != null && ret == 0;
    }
}

