/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Point;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SheetSettings
implements OfficeConstants {
    private Document settings = null;
    private String sheetName;
    private int cursorX = 0;
    private int cursorY = 0;
    private int splitTypeX;
    private int splitTypeY;
    private int splitPointX = 0;
    private int splitPointY = 0;
    private int posLeft = 0;
    private int posTop = 0;
    private int paneNumber = 2;
    private static final int SPLIT = 1;
    private static final int FREEZE = 2;

    public SheetSettings() {
    }

    public SheetSettings(Node node) {
        this.readNode(node);
    }

    public SheetSettings(String string) {
        this.sheetName = string;
    }

    public void setCursor(Point point) {
        this.cursorX = (int)point.getX();
        this.cursorY = (int)point.getY();
    }

    public Point getCursor() {
        return new Point(this.cursorX, this.cursorY);
    }

    public void setFreeze(Point point) {
        this.splitTypeX = 2;
        this.splitTypeY = 2;
        this.splitPointX = (int)point.getX();
        this.splitPointY = (int)point.getY();
    }

    public void setSplit(Point point) {
        this.splitTypeX = 1;
        this.splitTypeY = 1;
        this.splitPointX = (int)point.getX();
        this.splitPointY = (int)point.getY();
    }

    public Point getSplit() {
        return new Point(this.splitPointX, this.splitPointY);
    }

    public Point getSplitType() {
        return new Point(this.splitTypeX, this.splitTypeY);
    }

    public int getLeft() {
        return this.posLeft;
    }

    public int getTop() {
        return this.posTop;
    }

    public int getPaneNumber() {
        return this.paneNumber;
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public void setPaneNumber(int n) {
        this.paneNumber = n;
    }

    private String getSheetName() {
        return this.sheetName;
    }

    private void addConfigItem(Node node, String string, String string2, String string3) {
        Element element = this.settings.createElement("config:config-item");
        element.setAttribute("config:name", string);
        element.setAttribute("config:type", string2);
        element.appendChild(this.settings.createTextNode(string3));
        node.appendChild(element);
    }

    public void writeNode(Document document, Node node) {
        this.settings = document;
        Element element = document.createElement("config:config-item-map-entry");
        element.setAttribute("config:name", this.getSheetName());
        this.addConfigItem(element, "CursorPositionX", "int", Integer.toString(this.cursorX));
        this.addConfigItem(element, "CursorPositionY", "int", Integer.toString(this.cursorY));
        String string = Integer.toString(this.splitTypeX);
        if (this.splitPointX == 0) {
            string = "0";
        }
        this.addConfigItem(element, "HorizontalSplitMode", "short", string);
        string = Integer.toString(this.splitTypeY);
        if (this.splitPointY == 0) {
            string = "0";
        }
        this.addConfigItem(element, "VerticalSplitMode", "short", string);
        this.addConfigItem(element, "HorizontalSplitPosition", "int", Integer.toString(this.splitPointX));
        this.addConfigItem(element, "VerticalSplitPosition", "int", Integer.toString(this.splitPointY));
        this.addConfigItem(element, "ActiveSplitRange", "short", Integer.toString(this.paneNumber));
        this.addConfigItem(element, "PositionLeft", "int", "0");
        this.addConfigItem(element, "PositionRight", "int", Integer.toString(this.posLeft));
        this.addConfigItem(element, "PositionTop", "int", "0");
        this.addConfigItem(element, "PositionBottom", "int", Integer.toString(this.posTop));
        node.appendChild(element);
    }

    private void addAttribute(String string, String string2) {
        if (string.equals("CursorPositionX")) {
            this.cursorX = Integer.parseInt(string2);
        } else if (string.equals("CursorPositionY")) {
            this.cursorY = Integer.parseInt(string2);
        } else if (string.equals("HorizontalSplitPosition")) {
            this.splitPointX = Integer.parseInt(string2);
        } else if (string.equals("VerticalSplitPosition")) {
            this.splitPointY = Integer.parseInt(string2);
        } else if (string.equals("ActiveSplitRange")) {
            this.paneNumber = Integer.parseInt(string2);
        } else if (string.equals("PositionRight")) {
            this.posLeft = Integer.parseInt(string2);
        } else if (string.equals("PositionBottom")) {
            this.posTop = Integer.parseInt(string2);
        } else if (string.equals("HorizontalSplitMode")) {
            this.splitTypeX = Integer.parseInt(string2);
        } else if (string.equals("VerticalSplitMode")) {
            this.splitTypeY = Integer.parseInt(string2);
        }
    }

    private void readNode(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("config:name");
        this.sheetName = node2.getNodeValue();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1 || !(string = node3.getNodeName()).equals("config:config-item")) continue;
                NamedNodeMap namedNodeMap2 = node3.getAttributes();
                Node node4 = namedNodeMap2.getNamedItem("config:name");
                String string2 = node4.getNodeValue();
                NodeList nodeList2 = node3.getChildNodes();
                int n2 = nodeList2.getLength();
                String string3 = "";
                for (int j = 0; j < n2; ++j) {
                    Node node5 = nodeList2.item(j);
                    if (node5.getNodeType() != 3) continue;
                    string3 = node5.getNodeValue();
                }
                this.addAttribute(string2, string3);
            }
        }
    }
}

