/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;

class MMFFVDWCalc
extends Calculation {
    MMFFVDWCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ia, int ib, double dd) {
        this.a = this.calcs.minAtoms[ia];
        this.b = this.calcs.minAtoms[ib];
        double[] dataA = (double[])this.calcs.getParameter(this.a.vdwKey);
        double[] dataB = (double[])this.calcs.getParameter(this.b.vdwKey);
        if (dataA == null || dataB == null) {
            return;
        }
        double alpha_a = dataA[0];
        double N_a = dataA[1];
        double A_a = dataA[2];
        double G_a = dataA[3];
        int DA_a = (int)dataA[4];
        double alpha_b = dataB[0];
        double N_b = dataB[1];
        double A_b = dataB[2];
        double G_b = dataB[3];
        int DA_b = (int)dataB[4];
        double rs_aa = A_a * Math.pow(alpha_a, 0.25);
        double rs_bb = A_b * Math.pow(alpha_b, 0.25);
        double gamma = (rs_aa - rs_bb) / (rs_aa + rs_bb);
        double rs = 0.5 * (rs_aa + rs_bb);
        if (DA_a != 68 && DA_b != 68) {
            rs *= 1.0 + 0.2 * (1.0 - Math.exp(-12.0 * gamma * gamma));
        }
        double eps = 181.16 * G_a * G_b * alpha_a * alpha_b / (Math.sqrt(alpha_a / N_a) + Math.sqrt(alpha_b / N_b)) * Math.pow(rs, -6.0);
        if (DA_a + DA_b == 133) {
            rs *= 0.8;
            eps *= 0.5;
        }
        calc.addLast(new Object[]{new int[]{ia, ib}, new double[]{rs, eps}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        this.calcs.setPairVariables(this);
        double rs = this.dData[0];
        double eps = this.dData[1];
        double r_rs = this.rab / rs;
        double f1 = 1.07 / (r_rs + 0.07);
        double f2 = 1.12 / (Math.pow(r_rs, 7.0) + 0.12);
        this.energy = eps * Math.pow(f1, 7.0) * (f2 - 2.0);
        if (this.calcs.gradients) {
            this.dE = -7.0 * eps * Math.pow(f1, 7.0) / rs * (f1 / 1.07 * (f2 - 2.0) + f2 * f2 * Math.pow(r_rs, 6.0));
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging && Math.abs(this.energy) > 0.1) {
            this.calcs.appendLogData(this.calcs.getDebugLine(5, this));
        }
        return this.energy;
    }
}

