/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.security.cert.Certificate;
import java.util.Enumeration;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JNLPPolicy
extends Policy {
    private static CodeSource shellSource;
    private static CodeSource systemSource;
    private static Policy systemPolicy;
    private final URI jreExtDir;
    private Policy systemJnlpPolicy = null;
    private Policy userJnlpPolicy = null;

    protected JNLPPolicy() {
        shellSource = JNLPPolicy.class.getProtectionDomain().getCodeSource();
        systemSource = Policy.class.getProtectionDomain().getCodeSource();
        systemPolicy = Policy.getPolicy();
        this.systemJnlpPolicy = this.getPolicyFromConfig("deployment.system.security.policy");
        this.userJnlpPolicy = this.getPolicyFromUrl(PathsAndFiles.JAVA_POLICY.getFullPath());
        String jre = System.getProperty("java.home");
        this.jreExtDir = new File(jre + File.separator + "lib" + File.separator + "ext").toURI();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        if (source.equals(systemSource) || source.equals(shellSource)) {
            return this.getAllPermissions();
        }
        if (this.isSystemJar(source)) {
            return this.getAllPermissions();
        }
        if (JNLPRuntime.getApplication() != null && JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader cl = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            PermissionCollection clPermissions = cl.getPermissions(source);
            CodeSource appletCS = new CodeSource(JNLPRuntime.getApplication().getJNLPFile().getSourceLocation(), (Certificate[])null);
            Enumeration<Permission> e = systemPolicy.getPermissions(appletCS).elements();
            while (e.hasMoreElements()) {
                clPermissions.add(e.nextElement());
            }
            if (this.systemJnlpPolicy != null) {
                e = this.systemJnlpPolicy.getPermissions(appletCS).elements();
                while (e.hasMoreElements()) {
                    clPermissions.add(e.nextElement());
                }
            }
            if (this.userJnlpPolicy != null) {
                e = this.userJnlpPolicy.getPermissions(appletCS).elements();
                while (e.hasMoreElements()) {
                    clPermissions.add(e.nextElement());
                }
                CodeSource appletCodebaseSource = new CodeSource(JNLPRuntime.getApplication().getJNLPFile().getCodeBase(), (Certificate[])null);
                e = this.userJnlpPolicy.getPermissions(appletCodebaseSource).elements();
                while (e.hasMoreElements()) {
                    clPermissions.add(e.nextElement());
                }
            }
            return clPermissions;
        }
        return systemPolicy.getPermissions(source);
    }

    @Override
    public void refresh() {
        if (this.userJnlpPolicy != null) {
            this.userJnlpPolicy.refresh();
        }
    }

    private Permissions getAllPermissions() {
        Permissions result = new Permissions();
        result.add(new AllPermission());
        return result;
    }

    private boolean isSystemJar(CodeSource source) {
        if (source == null || source.getLocation() == null) {
            return false;
        }
        String sourceProtocol = source.getLocation().getProtocol();
        String sourcePath = source.getLocation().getPath();
        if (sourceProtocol.toUpperCase().equals("FILE") && sourcePath.startsWith(this.jreExtDir.getRawPath())) {
            return true;
        }
        return sourceProtocol.equalsIgnoreCase("jrt");
    }

    private Policy getPolicyFromConfig(String key) {
        DeploymentConfiguration config = JNLPRuntime.getConfiguration();
        String policyLocation = config.getProperty(key);
        return this.getPolicyFromUrl(policyLocation);
    }

    private Policy getPolicyFromUrl(String policyLocation) {
        Policy policy = null;
        if (policyLocation != null) {
            try {
                URI policyUri = policyLocation.startsWith("file://") ? new File(policyLocation).toURI() : new URI(policyLocation.replace("\\", "/"));
                policy = JNLPPolicy.getInstance("JavaPolicy", new URIParameter(policyUri));
            }
            catch (IllegalArgumentException | URISyntaxException | NoSuchAlgorithmException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
        return policy;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc = this.getPermissions(domain.getCodeSource());
        return super.implies(domain, permission) || pc.implies(permission);
    }
}

