/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.WorkSource;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

@NonNullApi
public class DefaultPlanExecutor
implements PlanExecutor,
Stoppable {
    public static final String STAT_PROPERTY_NAME = "org.gradle.internal.executor.stats";
    private static final Logger LOGGER = Logging.getLogger(DefaultPlanExecutor.class);
    private final int executorCount;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;
    private final ManagedExecutor executor;
    private final MergedQueues queue;
    private final ExecutorState state = new ExecutorState();
    private final ExecutorStats stats;

    public DefaultPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService, StartParameter startParameter) {
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
        this.stats = startParameter.getSystemPropertiesArgs().getOrDefault(STAT_PROPERTY_NAME, "false").equalsIgnoreCase("true") ? new CollectingExecutorStats(this.state) : this.state;
        this.queue = new MergedQueues(coordinationService, false);
        this.executor = executorFactory.create("Execution worker");
    }

    public void stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.queue, this.executor}).stop();
        }
        finally {
            this.stats.report();
        }
    }

    @Override
    public <T> ExecutionResult<Void> process(WorkSource<T> workSource, Action<T> worker) {
        PlanDetails planDetails = new PlanDetails((WorkSource)Cast.uncheckedCast(workSource), (Action<Object>)((Action)Cast.uncheckedCast(worker)));
        this.queue.add(planDetails);
        this.maybeStartWorkers(this.queue, (Executor)this.executor);
        WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
        MergedQueues thisPlanOnly = new MergedQueues(this.coordinationService, true);
        thisPlanOnly.add(planDetails);
        new ExecutorWorker(thisPlanOnly, currentWorkerLease, this.cancellationToken, this.coordinationService, this.workerLeaseService, this.stats).run();
        ArrayList failures = new ArrayList();
        this.awaitCompletion(workSource, currentWorkerLease, failures);
        return ExecutionResult.maybeFailed(failures);
    }

    @Override
    public void assertHealthy() {
        ExecutorState.HealthState healthState;
        Instant expiry = Instant.now().plus(2L, ChronoUnit.SECONDS);
        do {
            if ((healthState = (ExecutorState.HealthState)this.coordinationService.withStateLock(() -> this.state.healthCheck(this.queue))) == null) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        } while (expiry.compareTo(Instant.now()) > 0);
        System.out.println(healthState.detailMessage);
        IllegalStateException failure = new IllegalStateException("Unable to make progress running work. There are items queued for execution but none of them can be started");
        this.coordinationService.withStateLock(() -> this.queue.abortAllAndFail(failure));
    }

    private void awaitCompletion(WorkSource<?> workSource, WorkerLeaseRegistry.WorkerLease workerLease, Collection<? super Throwable> failures) {
        this.coordinationService.withStateLock(resourceLockState -> {
            if (workSource.allExecutionComplete()) {
                if (!workerLease.isLockedByCurrentThread() && !workerLease.tryLock()) {
                    return ResourceLockState.Disposition.RETRY;
                }
                workSource.collectFailures(failures);
                this.queue.removeFinishedPlans();
                return ResourceLockState.Disposition.FINISHED;
            }
            workerLease.unlock();
            return ResourceLockState.Disposition.RETRY;
        });
    }

    private void maybeStartWorkers(MergedQueues queue, Executor executor) {
        this.state.maybeStartWorkers(() -> {
            LOGGER.debug("Using {} parallel executor threads", (Object)this.executorCount);
            for (int i = 1; i < this.executorCount; ++i) {
                executor.execute(new ExecutorWorker(queue, null, this.cancellationToken, this.coordinationService, this.workerLeaseService, this.stats));
            }
        });
    }

    private static class CollectingWorkerStats
    implements WorkerStats {
        final long startTime;
        private final CollectingExecutorStats owner;
        private final WorkerState delegate;
        long finishTime;
        long startCurrentOperation;
        long totalSelectTime;
        long totalExecuteTime;
        long totalMarkFinishedTime;

        public CollectingWorkerStats(CollectingExecutorStats owner, WorkerState delegate) {
            this.owner = owner;
            this.delegate = delegate;
            this.startTime = System.nanoTime();
        }

        @Override
        public void finish() {
            this.finishTime = System.nanoTime();
            this.owner.workerFinished(this);
        }

        @Override
        public void startSelect() {
            this.startCurrentOperation = System.nanoTime();
        }

        @Override
        public void finishSelect() {
            long duration = System.nanoTime() - this.startCurrentOperation;
            if (duration > 0L) {
                this.totalSelectTime += duration;
            }
        }

        @Override
        public void startExecute() {
            this.startCurrentOperation = System.nanoTime();
        }

        @Override
        public void finishExecute() {
            long duration = System.nanoTime() - this.startCurrentOperation;
            if (duration > 0L) {
                this.totalExecuteTime += duration;
            }
        }

        @Override
        public void startMarkFinished() {
            this.startCurrentOperation = System.nanoTime();
        }

        @Override
        public void finishMarkFinished() {
            long duration = System.nanoTime() - this.startCurrentOperation;
            if (duration > 0L) {
                this.totalMarkFinishedTime += duration;
            }
        }

        @Override
        public void startWaitingForNextItem() {
            this.delegate.startWaitingForNextItem();
        }

        @Override
        public void finishWaitingForNextItem() {
            this.delegate.finishWaitingForNextItem();
        }
    }

    private static class CollectingExecutorStats
    implements ExecutorStats {
        private final List<CollectingWorkerStats> completedWorkers = new CopyOnWriteArrayList<CollectingWorkerStats>();
        private final ExecutorState delegate;

        public CollectingExecutorStats(ExecutorState delegate) {
            this.delegate = delegate;
        }

        @Override
        public WorkerStats startWorker() {
            return new CollectingWorkerStats(this, this.delegate.startWorker());
        }

        void workerFinished(CollectingWorkerStats stats) {
            this.completedWorkers.add(stats);
        }

        @Override
        public void report() {
            LOGGER.lifecycle("WORKER THREAD STATISTICS");
            int workerCount = this.completedWorkers.size();
            LOGGER.lifecycle("worker count: " + workerCount);
            if (workerCount > 0) {
                LOGGER.lifecycle("average select time: " + this.format(stats -> stats.totalSelectTime));
                LOGGER.lifecycle("average execute time: " + this.format(stats -> stats.totalExecuteTime));
                LOGGER.lifecycle("average finish time: " + this.format(stats -> stats.totalMarkFinishedTime));
            }
            this.completedWorkers.clear();
        }

        private String format(ToLongFunction<CollectingWorkerStats> statsProperty) {
            BigDecimal averageNanos = BigDecimal.valueOf(this.completedWorkers.stream().mapToLong(statsProperty).sum() / (long)this.completedWorkers.size());
            return DecimalFormat.getNumberInstance().format(averageNanos.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP)) + "ms";
        }
    }

    private static class ExecutorState
    implements ExecutorStats {
        private final AtomicReference<List<WorkerState>> allWorkers = new AtomicReference();

        private ExecutorState() {
        }

        public void maybeStartWorkers(Runnable startAction) {
            if (this.allWorkers.get() != null) {
                return;
            }
            if (this.allWorkers.compareAndSet(null, new CopyOnWriteArrayList())) {
                startAction.run();
            }
        }

        @Override
        public WorkerStats startWorker() {
            WorkerState state = new WorkerState();
            this.allWorkers.get().add(state);
            return state;
        }

        @Override
        public void report() {
        }

        @Nullable
        public HealthState healthCheck(MergedQueues queues) {
            if (queues.nothingQueued()) {
                return null;
            }
            List<WorkerState> workers = this.allWorkers.get();
            if (workers == null || workers.isEmpty()) {
                return null;
            }
            int waitingWorkers = 0;
            int stoppedWorkers = 0;
            for (WorkerState worker : workers) {
                ExecutionState currentState = (ExecutionState)((Object)worker.state.get());
                if (currentState == ExecutionState.Running) {
                    return null;
                }
                if (currentState == ExecutionState.Waiting) {
                    ++waitingWorkers;
                    continue;
                }
                if (currentState != ExecutionState.Stopped) continue;
                ++stoppedWorkers;
            }
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Unable to make progress running work. The following items are queued for execution but none of them can be started:");
            formatter.startChildren();
            queues.appendHealthDiagnostics(formatter);
            formatter.node("Workers waiting for work: " + waitingWorkers);
            formatter.node("Stopped workers: " + stoppedWorkers);
            formatter.endChildren();
            return new HealthState(formatter);
        }

        private static class WorkerState
        implements WorkerStats {
            private final AtomicReference<ExecutionState> state = new AtomicReference<ExecutionState>(ExecutionState.Running);

            private WorkerState() {
            }

            @Override
            public void startSelect() {
            }

            @Override
            public void finishSelect() {
            }

            @Override
            public void startExecute() {
            }

            @Override
            public void finishExecute() {
            }

            @Override
            public void startMarkFinished() {
            }

            @Override
            public void finishMarkFinished() {
            }

            @Override
            public void finish() {
                this.state.set(ExecutionState.Stopped);
            }

            @Override
            public void startWaitingForNextItem() {
                if (!this.state.compareAndSet(ExecutionState.Running, ExecutionState.Waiting)) {
                    throw new IllegalStateException("Unexpected state for worker.");
                }
            }

            @Override
            public void finishWaitingForNextItem() {
                if (this.state.get() == ExecutionState.Stopped) {
                    throw new IllegalStateException("Unexpected state for worker.");
                }
                this.state.set(ExecutionState.Running);
            }
        }

        private static class HealthState {
            final TreeFormatter detailMessage;

            public HealthState(TreeFormatter detailMessage) {
                this.detailMessage = detailMessage;
            }
        }

        static enum ExecutionState {
            Running,
            Waiting,
            Stopped;

        }
    }

    private static interface WorkerStats
    extends WorkerState {
        public void startSelect();

        public void finishSelect();

        public void startExecute();

        public void finishExecute();

        public void startMarkFinished();

        public void finishMarkFinished();

        public void finish();
    }

    private static interface WorkerState {
        public void startWaitingForNextItem();

        public void finishWaitingForNextItem();
    }

    private static interface ExecutorStats {
        public void report();

        public WorkerStats startWorker();
    }

    private static class ExecutorWorker
    implements Runnable {
        private final MergedQueues queue;
        private WorkerLeaseRegistry.WorkerLease workerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;
        private final WorkerLeaseService workerLeaseService;
        private final WorkerStats stats;

        private ExecutorWorker(MergedQueues queue, @Nullable WorkerLeaseRegistry.WorkerLease workerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService, WorkerLeaseService workerLeaseService, ExecutorStats executorStats) {
            this.queue = queue;
            this.workerLease = workerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
            this.workerLeaseService = workerLeaseService;
            this.stats = executorStats.startWorker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WorkItem workItem;
                boolean releaseLeaseOnCompletion;
                if (this.workerLease == null) {
                    this.workerLease = this.workerLeaseService.newWorkerLease();
                    releaseLeaseOnCompletion = true;
                } else {
                    releaseLeaseOnCompletion = false;
                }
                while ((workItem = this.getNextItem(this.workerLease)) != null) {
                    Object selected = workItem.selection.getItem();
                    LOGGER.info("{} ({}) started.", selected, (Object)Thread.currentThread());
                    this.execute(selected, workItem.plan, workItem.executor);
                }
                if (releaseLeaseOnCompletion) {
                    this.coordinationService.withStateLock(() -> this.workerLease.unlock());
                }
            }
            finally {
                this.stats.finish();
            }
        }

        @Nullable
        private WorkItem getNextItem(WorkerLeaseRegistry.WorkerLease workerLease) {
            MutableReference selected;
            this.stats.startSelect();
            try {
                selected = MutableReference.empty();
                this.coordinationService.withStateLock(resourceLockState -> {
                    WorkSource.Selection<WorkItem> workItem;
                    WorkSource.State state;
                    this.stats.finishWaitingForNextItem();
                    if (this.cancellationToken.isCancellationRequested()) {
                        this.queue.cancelExecution();
                    }
                    if ((state = this.queue.executionState()) == WorkSource.State.NoMoreWorkToStart) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    if (!workerLease.tryLock()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    if (state == WorkSource.State.NoWorkReadyToStart) {
                        this.stats.startWaitingForNextItem();
                        workerLease.unlock();
                        return ResourceLockState.Disposition.RETRY;
                    }
                    try {
                        workItem = this.queue.selectNext();
                    }
                    catch (Throwable t) {
                        resourceLockState.releaseLocks();
                        this.queue.abortAllAndFail(t);
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    if (workItem.isNoMoreWorkToStart()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    if (workItem.isNoWorkReadyToStart()) {
                        this.stats.startWaitingForNextItem();
                        workerLease.unlock();
                        return ResourceLockState.Disposition.RETRY;
                    }
                    selected.set((Object)workItem.getItem());
                    return ResourceLockState.Disposition.FINISHED;
                });
            }
            finally {
                this.stats.finishSelect();
            }
            return (WorkItem)selected.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Object selected, WorkSource<Object> executionPlan, Action<Object> worker) {
            Throwable failure = null;
            try {
                this.stats.startExecute();
                try {
                    worker.execute(selected);
                }
                catch (Throwable t) {
                    failure = t;
                }
                finally {
                    this.stats.finishExecute();
                }
                this.markFinished(selected, executionPlan, failure);
            }
            catch (Throwable throwable) {
                this.markFinished(selected, executionPlan, failure);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markFinished(Object selected, WorkSource<Object> executionPlan, @Nullable Throwable failure) {
            this.stats.startMarkFinished();
            try {
                this.coordinationService.withStateLock(() -> {
                    try {
                        executionPlan.finishedExecuting(selected, failure);
                    }
                    catch (Throwable t) {
                        this.queue.abortAllAndFail(t);
                    }
                    this.coordinationService.notifyStateChange();
                });
            }
            finally {
                this.stats.finishMarkFinished();
            }
        }
    }

    private static class MergedQueues
    implements Closeable {
        private final ResourceLockCoordinationService coordinationService;
        private final boolean autoFinish;
        private boolean finished;
        private final LinkedList<PlanDetails> queues = new LinkedList();

        public MergedQueues(ResourceLockCoordinationService coordinationService, boolean autoFinish) {
            this.coordinationService = coordinationService;
            this.autoFinish = autoFinish;
        }

        public WorkSource.State executionState() {
            this.coordinationService.assertHasStateLock();
            Iterator iterator = this.queues.iterator();
            while (iterator.hasNext()) {
                PlanDetails details = (PlanDetails)iterator.next();
                WorkSource.State state = details.source.executionState();
                if (state == WorkSource.State.NoMoreWorkToStart) {
                    if (!details.source.allExecutionComplete()) continue;
                    iterator.remove();
                    continue;
                }
                if (state != WorkSource.State.MaybeWorkReadyToStart) continue;
                return WorkSource.State.MaybeWorkReadyToStart;
            }
            if (this.nothingMoreToStart()) {
                return WorkSource.State.NoMoreWorkToStart;
            }
            return WorkSource.State.NoWorkReadyToStart;
        }

        public WorkSource.Selection<WorkItem> selectNext() {
            this.coordinationService.assertHasStateLock();
            Iterator iterator = this.queues.iterator();
            while (iterator.hasNext()) {
                PlanDetails details = (PlanDetails)iterator.next();
                WorkSource.Selection<Object> selection = details.source.selectNext();
                if (selection.isNoMoreWorkToStart()) {
                    if (!details.source.allExecutionComplete()) continue;
                    iterator.remove();
                    continue;
                }
                if (selection.isNoWorkReadyToStart()) continue;
                return WorkSource.Selection.of(new WorkItem(selection, details.source, details.worker));
            }
            if (this.nothingMoreToStart()) {
                return WorkSource.Selection.noMoreWorkToStart();
            }
            return WorkSource.Selection.noWorkReadyToStart();
        }

        private boolean nothingMoreToStart() {
            return this.finished || this.autoFinish && this.queues.isEmpty();
        }

        public void add(PlanDetails planDetails) {
            this.coordinationService.withStateLock(() -> {
                if (this.finished) {
                    throw new IllegalStateException("This queue has been closed.");
                }
                this.queues.addFirst(planDetails);
                this.coordinationService.notifyStateChange();
            });
        }

        public void removeFinishedPlans() {
            this.coordinationService.assertHasStateLock();
            this.queues.removeIf(details -> details.source.allExecutionComplete());
        }

        @Override
        public void close() throws IOException {
            this.coordinationService.withStateLock(() -> {
                this.finished = true;
                if (!this.queues.isEmpty()) {
                    throw new IllegalStateException("Not all work has completed.");
                }
                this.coordinationService.notifyStateChange();
            });
        }

        public void cancelExecution() {
            this.coordinationService.assertHasStateLock();
            for (PlanDetails details : this.queues) {
                details.source.cancelExecution();
            }
        }

        public void abortAllAndFail(Throwable t) {
            this.coordinationService.assertHasStateLock();
            for (PlanDetails details : this.queues) {
                details.source.abortAllAndFail(t);
            }
            this.coordinationService.notifyStateChange();
        }

        public boolean nothingQueued() {
            this.coordinationService.assertHasStateLock();
            for (PlanDetails queue : this.queues) {
                if (queue.source.executionState() == WorkSource.State.NoMoreWorkToStart) continue;
                return false;
            }
            return true;
        }

        public void appendHealthDiagnostics(TreeFormatter formatter) {
            this.coordinationService.assertHasStateLock();
            ArrayList<WorkSource.Diagnostics> allDiagnostics = new ArrayList<WorkSource.Diagnostics>(this.queues.size());
            for (PlanDetails details : this.queues) {
                allDiagnostics.add(details.source.healthDiagnostics());
            }
            for (WorkSource.Diagnostics diagnostics : allDiagnostics) {
                diagnostics.describeTo(formatter);
            }
        }
    }

    private static class WorkItem {
        final WorkSource.Selection<Object> selection;
        final WorkSource<Object> plan;
        final Action<Object> executor;

        public WorkItem(WorkSource.Selection<Object> selection, WorkSource<Object> plan, Action<Object> executor) {
            this.selection = selection;
            this.plan = plan;
            this.executor = executor;
        }
    }

    private static class PlanDetails {
        final WorkSource<Object> source;
        final Action<Object> worker;

        public PlanDetails(WorkSource<Object> source, Action<Object> worker) {
            this.source = source;
            this.worker = worker;
        }
    }
}

