/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u000eH\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkArgumentAndReport", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isArray", "", "cannotBeReified", "isReifiedTypeParameterOrFromKotlinArray", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "checkers"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments2 = expression2.getTypeArguments();
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(calleReference);
        if (firCallableSymbol == null || (firCallableSymbol = firCallableSymbol.getTypeParameterSymbols()) == null) {
            return;
        }
        FirCallableSymbol<?> typeParameters2 = firCallableSymbol;
        int count = Math.min(typeArguments2.size(), typeParameters2.size());
        for (int index2 = 0; index2 < count; ++index2) {
            FirTypeProjection typeArgumentProjection = typeArguments2.get(index2);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = calleReference.getSource();
            }
            KtSourceElement source = ktSourceElement;
            ConeKotlinType typeArgument = ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection));
            FirTypeParameterSymbol typeParameter = (FirTypeParameterSymbol)typeParameters2.get(index2);
            if (source == null || !this.isReifiedTypeParameterOrFromKotlinArray(typeParameter)) continue;
            this.checkArgumentAndReport(typeArgument, source, false, context, reporter);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, KtSourceElement source, boolean isArray, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = typeArgument;
        if (Intrinsics.areEqual((Object)(coneKotlinType != null ? ConeTypeUtilsKt.getClassId(coneKotlinType) : null), (Object)StandardClassIds.INSTANCE.getArray())) {
            this.checkArgumentAndReport(ConeTypeProjectionKt.getType(typeArgument.getTypeArguments()[0]), source, true, context, reporter);
            return;
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            KtDiagnosticFactory1 factory2 = isArray ? (KtDiagnosticFactory1)KtDiagnosticReportHelpersKt.chooseFactory((KtDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED();
            FirTypeParameterSymbol symbol2 = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol2.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, (Object)symbol2, (DiagnosticContext)context, null, 16, null);
            }
        } else if (typeArgument != null && this.cannotBeReified(typeArgument)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, (DiagnosticContext)context, null, 16, null);
            return;
        }
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified) {
        return ConeBuiltinTypeUtilsKt.isNothing($this$cannotBeReified) || ConeBuiltinTypeUtilsKt.isNullableNothing($this$cannotBeReified) || $this$cannotBeReified instanceof ConeCapturedType;
    }
}

