/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestSpec;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.util.internal.CollectionUtils;

class TestExecutionBuildConfigurationAction
implements EntryTaskSelector {
    private final TestExecutionRequestAction testExecutionRequest;

    public TestExecutionBuildConfigurationAction(TestExecutionRequestAction testExecutionRequest) {
        this.testExecutionRequest = testExecutionRequest;
    }

    public void applyTasksTo(EntryTaskSelector.Context context, ExecutionPlan plan) {
        LinkedHashSet<Task> allTasksToRun = new LinkedHashSet<Task>();
        allTasksToRun.addAll(this.configureBuildForTestDescriptors(context, this.testExecutionRequest));
        allTasksToRun.addAll(this.configureBuildForInternalJvmTestRequest(context.getGradle(), this.testExecutionRequest));
        allTasksToRun.addAll(this.configureBuildForTestTasks(context, this.testExecutionRequest));
        this.configureTestTasks(allTasksToRun);
        for (Task task : allTasksToRun) {
            plan.addEntryTask(task);
        }
    }

    private void configureTestTasks(Set<Task> tasks) {
        for (Task task : tasks) {
            if (!(task instanceof Test)) continue;
            Test test = (Test)task;
            test.setIgnoreFailures(true);
            test.getFilter().setFailOnNoMatchingTests(false);
            task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
            final InternalDebugOptions debugOptions = this.testExecutionRequest.getDebugOptions();
            if (!debugOptions.isDebugMode()) continue;
            test.debugOptions((Action)new Action<JavaDebugOptions>(){

                public void execute(JavaDebugOptions javaDebugOptions) {
                    DefaultJavaDebugOptions options = (DefaultJavaDebugOptions)javaDebugOptions;
                    options.getEnabled().set((Object)true);
                    options.getPort().set((Object)debugOptions.getPort());
                    options.getServer().set((Object)false);
                    options.getSuspend().set((Object)false);
                }
            });
        }
    }

    private List<Task> configureBuildForTestDescriptors(EntryTaskSelector.Context context, TestExecutionRequestAction testExecutionRequest) {
        Map taskAndTests = testExecutionRequest.getTaskAndTests();
        ArrayList<Task> tasksToRun = new ArrayList<Task>();
        for (Map.Entry entry : taskAndTests.entrySet()) {
            String testTaskPath = (String)entry.getKey();
            for (Test testTask : this.queryTestTasks(context, testTaskPath)) {
                for (InternalJvmTestRequest jvmTestRequest : (List)entry.getValue()) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
                tasksToRun.add((Task)testTask);
            }
        }
        for (InternalTaskSpec taskSpec : testExecutionRequest.getTaskSpecs()) {
            if (taskSpec instanceof InternalTestSpec) {
                InternalTestSpec testSpec = (InternalTestSpec)taskSpec;
                Set<Test> tasks = this.queryTestTasks(context, taskSpec.getTaskPath());
                for (Test task : tasks) {
                    tasksToRun.add((Task)task);
                    DefaultTestFilter filter = (DefaultTestFilter)task.getFilter();
                    for (String string : testSpec.getClasses()) {
                        filter.includeCommandLineTest(string, null);
                    }
                    for (Map.Entry entry : testSpec.getMethods().entrySet()) {
                        String cls = (String)entry.getKey();
                        for (String method : (List)entry.getValue()) {
                            filter.includeCommandLineTest(cls, method);
                        }
                    }
                    filter.getCommandLineIncludePatterns().addAll(testSpec.getPatterns());
                    for (String string : testSpec.getPackages()) {
                        filter.getCommandLineIncludePatterns().add(string + ".*");
                    }
                }
                continue;
            }
            tasksToRun.addAll(this.queryTasks(context, taskSpec.getTaskPath()));
        }
        return tasksToRun;
    }

    private List<Test> configureBuildForTestTasks(EntryTaskSelector.Context context, TestExecutionRequestAction testExecutionRequest) {
        Set testDescriptors = testExecutionRequest.getTestExecutionDescriptors();
        List testTaskPaths = CollectionUtils.collect((Iterable)testDescriptors, (Transformer)new Transformer<String, InternalTestDescriptor>(){

            public String transform(InternalTestDescriptor testDescriptor) {
                return ((DefaultTestDescriptor)testDescriptor).getTaskPath();
            }
        });
        ArrayList<Test> testTasksToRun = new ArrayList<Test>();
        for (String testTaskPath : testTaskPaths) {
            for (Test testTask : this.queryTestTasks(context, testTaskPath)) {
                for (InternalTestDescriptor testDescriptor : testDescriptors) {
                    DefaultTestDescriptor defaultTestDescriptor = (DefaultTestDescriptor)testDescriptor;
                    if (!defaultTestDescriptor.getTaskPath().equals(testTaskPath)) continue;
                    String className = defaultTestDescriptor.getClassName();
                    String methodName = defaultTestDescriptor.getMethodName();
                    if (className == null && methodName == null) {
                        testTask.getFilter().includeTestsMatching("*");
                        continue;
                    }
                    testTask.getFilter().includeTest(className, methodName);
                }
                testTasksToRun.add(testTask);
            }
        }
        return testTasksToRun;
    }

    private Set<Task> queryTasks(EntryTaskSelector.Context context, String testTaskPath) {
        TaskSelection taskSelection;
        try {
            taskSelection = context.getSelection(testTaskPath);
        }
        catch (TaskSelectionException e) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        Set tasks = taskSelection.getTasks();
        if (tasks.isEmpty()) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        return tasks;
    }

    private Set<Test> queryTestTasks(EntryTaskSelector.Context context, String testTaskPath) {
        LinkedHashSet<Test> result = new LinkedHashSet<Test>();
        for (Task task : this.queryTasks(context, testTaskPath)) {
            if (!(task instanceof Test)) {
                throw new TestExecutionException(String.format("Task '%s' of type '%s' not supported for executing tests via TestLauncher API.", testTaskPath, task.getClass().getName()));
            }
            result.add((Test)task);
        }
        return result;
    }

    private List<Test> configureBuildForInternalJvmTestRequest(GradleInternal gradle, TestExecutionRequestAction testExecutionRequest) {
        Set internalJvmTestRequests = testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Test> tasksToExecute = new ArrayList<Test>();
        gradle.getOwner().ensureProjectsConfigured();
        for (ProjectState projectState : gradle.getOwner().getProjects().getAllProjects()) {
            projectState.ensureConfigured();
            projectState.applyToMutableState(project -> {
                TaskCollection testTasks = project.getTasks().withType(Test.class);
                for (Test testTask : testTasks) {
                    for (InternalJvmTestRequest jvmTestRequest : internalJvmTestRequests) {
                        TestFilter filter = testTask.getFilter();
                        filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                    }
                }
                tasksToExecute.addAll((Collection<Test>)testTasks);
            });
        }
        return tasksToExecute;
    }
}

