/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.topografix.gpx._1._0.BoundsType;
import com.topografix.gpx._1._0.Gpx;
import com.topografix.gpx._1._0.ObjectFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fibs.geotag.util.BoundsTypeUtil;

public final class TrackStore {
    private static final TrackStore TRACKSTORE = new TrackStore();
    private Map<Gpx.Trk.Trkseg, BoundsType> segmentBounds = new HashMap<Gpx.Trk.Trkseg, BoundsType>();
    private Gpx gpx;
    private List<Gpx.Trk.Trkseg> segmentList = null;

    private TrackStore() {
    }

    public static TrackStore getTrackStore() {
        return TRACKSTORE;
    }

    public void addGPX(Gpx newGpx) {
        if (this.gpx == null) {
            this.gpx = newGpx;
        } else {
            this.gpx.getTrk().addAll(newGpx.getTrk());
        }
        ArrayList<Gpx.Trk.Trkseg> newSegmentList = new ArrayList<Gpx.Trk.Trkseg>();
        for (Gpx.Trk track : this.gpx.getTrk()) {
            for (Gpx.Trk.Trkseg segment : track.getTrkseg()) {
                ArrayList<Gpx.Trk.Trkseg.Trkpt> trackpointList = new ArrayList<Gpx.Trk.Trkseg.Trkpt>();
                for (Gpx.Trk.Trkseg.Trkpt trackpoint : segment.getTrkpt()) {
                    if (trackpoint.getTime() == null) continue;
                    trackpointList.add(trackpoint);
                }
                if (trackpointList.size() <= 0) continue;
                newSegmentList.add(segment);
            }
        }
        SegmentComparator comparator = new SegmentComparator();
        Collections.sort(newSegmentList, comparator);
        this.segmentList = new ArrayList<Gpx.Trk.Trkseg>();
        Gpx.Trk.Trkseg lastUniqueSegment = null;
        for (Gpx.Trk.Trkseg segment : newSegmentList) {
            if (lastUniqueSegment != null && comparator.compare(lastUniqueSegment, segment) == 0) continue;
            this.segmentList.add(segment);
            lastUniqueSegment = segment;
        }
        this.createTrackSegmentBounds(this.segmentList);
    }

    private void createTrackSegmentBounds(List<Gpx.Trk.Trkseg> segments) {
        this.segmentBounds.clear();
        ObjectFactory objectFactory = new ObjectFactory();
        for (Gpx.Trk.Trkseg segment : segments) {
            if (segment.getTrkpt().size() <= 0) continue;
            BoundsType bounds = objectFactory.createBoundsType();
            for (Gpx.Trk.Trkseg.Trkpt trackpoint : segment.getTrkpt()) {
                BigDecimal latitude = trackpoint.getLat();
                BigDecimal longitude = trackpoint.getLon();
                if (bounds.getMinlat() == null || latitude.compareTo(bounds.getMinlat()) < 0) {
                    bounds.setMinlat(latitude);
                }
                if (bounds.getMaxlat() == null || latitude.compareTo(bounds.getMaxlat()) > 0) {
                    bounds.setMaxlat(latitude);
                }
                if (bounds.getMinlon() == null || longitude.compareTo(bounds.getMinlon()) < 0) {
                    bounds.setMinlon(longitude);
                }
                if (bounds.getMaxlon() != null && longitude.compareTo(bounds.getMaxlon()) <= 0) continue;
                bounds.setMaxlon(longitude);
            }
            this.segmentBounds.put(segment, bounds);
        }
    }

    public boolean hasTracks() {
        return this.gpx != null && this.gpx.getTrk().size() > 0;
    }

    public Gpx getGpx() {
        return this.gpx;
    }

    public List<Gpx.Trk> getTracks() {
        if (this.gpx != null) {
            return this.gpx.getTrk();
        }
        return null;
    }

    public List<Gpx.Trk.Trkseg> getTrackSegments() {
        return this.segmentList;
    }

    BoundsType getSegmentBounds(Gpx.Trk.Trkseg segment) {
        return this.segmentBounds.get(segment);
    }

    public List<Gpx.Trk.Trkseg> getIntersectingTrackSegments(BoundsType mapBounds) {
        ArrayList<Gpx.Trk.Trkseg> result = new ArrayList<Gpx.Trk.Trkseg>();
        if (this.gpx != null) {
            for (Gpx.Trk track : this.gpx.getTrk()) {
                for (Gpx.Trk.Trkseg segment : track.getTrkseg()) {
                    BoundsType bounds = this.segmentBounds.get(segment);
                    if (bounds == null || !BoundsTypeUtil.intersect(mapBounds, bounds)) continue;
                    result.add(segment);
                }
            }
        }
        return result;
    }

    static class SegmentComparator
    implements Comparator<Gpx.Trk.Trkseg>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SegmentComparator() {
        }

        @Override
        public int compare(Gpx.Trk.Trkseg segment1, Gpx.Trk.Trkseg segment2) {
            return segment1.getTrkpt().get(0).getTime().compare(segment2.getTrkpt().get(0).getTime());
        }
    }
}

