# this needs RadiRoot to be loaded
gap> START_TEST("Factorisation of polynomials using PARI/GP");  

# some splitting fields
gap> pol := UnivariatePolynomial( Rationals, [ -1, 0, 0, 0, 1, 0, 1 ] );;
gap> SplittingField( pol );
<algebraic extension over the Rationals of degree 24>
gap> pol := UnivariatePolynomial( Rationals, [ 4, -1, 0, 6, -1, -2, 2, 1 ] );;
gap> SplittingField( pol );
<algebraic extension over the Rationals of degree 42>
gap> pol := UnivariatePolynomial( Rationals, [ 4, 0, 4, 0, -3, 0, -1, 0, 1 ] );;
gap> SplittingField( pol );
<algebraic extension over the Rationals of degree 24>
gap> pol := UnivariatePolynomial(Rationals, 
>                                [ -3, 1, -1, 2, 1, 3, -2, -1, 0, 1 ]);;
gap> SplittingField( pol );
<algebraic extension over the Rationals of degree 54>
gap> pol := UnivariatePolynomial(Rationals, 
>                                [ 47, 0, 103, 0, 41, 0, 7, 0, -2, 0, 1 ]);;
gap> SplittingField( pol );
<algebraic extension over the Rationals of degree 10>

# example from email to Bill Allombert (10/05/11)
gap> pol := UnivariatePolynomial( Rationals, [ 1, 2, 2, 2, 2, 1, 1 ] );
x_1^6+x_1^5+2*x_1^4+2*x_1^3+2*x_1^2+2*x_1+1
gap> f := UnivariatePolynomial( Rationals, [ 1, 1, 1 ] );
x_1^2+x_1+1
gap> K := SplittingField( pol );
<algebraic extension over the Rationals of degree 48>
gap> FactorsPolynomialAlgExt( K, f );
[ x_1^2+x_1+!1 ]

# example from Bill Allombert (10/05/11)
gap> pol := UnivariatePolynomial( Rationals, [ 20736, 0, 4147200, 0, 60632064, 
> 0, 347286528, 0, 1078555392, 0, 2069549568, 0, 2613917952, 0, 2241209088, 0,
> 1318874976, 0, 530669952, 0, 143684928, 0, 25510464, 0, 2872752, 0, 195936, 0,
> 7536, 0, 144, 0, 1 ] );;
gap> L := FieldByPolynomial( pol );
<algebraic extension over the Rationals of degree 32>
gap> FactorsPolynomialAlgExt( L, pol );
[ x_1+(-a), x_1+a, 
  x_1+(-6288932627/383229886464*a^31-676177676227/287422414848*a^29-7022199070\
4813/574844829696*a^27-8348368690499/2661318656*a^25-1441172196882701/31935823\
872*a^23-3110641133376895/7983955968*a^21-33644661220339553/15967911936*a^19-4\
4007416662454225/5987966976*a^17-134869088235956483/7983955968*a^15-1718798162\
7387251/665329664*a^13-104251404159613535/3991977984*a^11-8461693903983139/498\
997248*a^9-4412765111459797/665329664*a^7-226547531784319/166332416*a^5-343306\
15506473/332664832*a^3-22369886387/41583104*a), 
  x_1+(-2623944199/287422414848*a^31-752270973133/574844829696*a^29-1084917582\
523/15967911936*a^27-501373355503273/287422414848*a^25-600865108225135/2395186\
7904*a^23-3456869752501177/15967911936*a^21-14012209706995975/11975933952*a^19\
-97667468483551439/23951867904*a^17-18687613575472417/1995988992*a^15-57083251\
530607471/3991977984*a^13-4801094662490959/332664832*a^11-6222754679697441/665\
329664*a^9-606939117179801/166332416*a^7-248383159824721/332664832*a^5-4670807\
290457/83166208*a^3-45215963389/166332416*a), 
  x_1+(-4042744285/574844829696*a^31-32187975751/31935823872*a^29-187930960382\
9/35927801856*a^27-6027429086209/4490975232*a^25-102640701975317/5322637312*a^\
23-3980858518472945/23951867904*a^21-3579804831537031/3991977984*a^19-23344372\
34591057/748495872*a^17-9507239943635953/1330659328*a^15-7243398225169135/6653\
29664*a^13-1823743331458969/166332416*a^11-884899113733991/124749312*a^9-91978\
1706076915/332664832*a^7-94151627687003/166332416*a^5-3557954556085/83166208*a\
^3-2410591001/10395776*a), 
  x_1+(-7880365675/1149689659392*a^31-188274995653/191614943232*a^29-293260045\
19411/574844829696*a^27-125492280368065/95807471616*a^25-1804896180880669/9580\
7471616*a^23-7788995206315909/47903735808*a^21-4678435793811693/5322637312*a^1\
9-73397761769467337/23951867904*a^17-18735311636618035/2661318656*a^15-4295498\
8154550349/3991977984*a^13-43399863656624497/3991977984*a^11-4694298451896531/\
665329664*a^9-1834984794705831/665329664*a^7-188249142918295/332664832*a^5-142\
21659697487/332664832*a^3-33912557555/166332416*a), 
  x_1+(-316262345/47903735808*a^31-544230109085/574844829696*a^29-294523748095\
/5987966976*a^27-13456452507369/10645274624*a^25-218036972525605/11975933952*a\
^23-7542152297609335/47903735808*a^21-851557088264065/997994496*a^19-794081458\
3462665/2661318656*a^17-6863185088448505/997994496*a^15-42093757889236855/3991\
977984*a^13-666391408259905/62374656*a^11-13870926281619145/1995988992*a^9-226\
342997006495/83166208*a^7-186214113220445/332664832*a^5-887160368835/20791552*\
a^3-41420818635/166332416*a), 
  x_1+(-2387137355/383229886464*a^31-21379846115/23951867904*a^29-266252046601\
91/574844829696*a^27-18971202107023/15967911936*a^25-1634798202318467/95807471\
616*a^23-586712369596199/3991977984*a^21-37953053904796037/47903735808*a^19-32\
957719683582179/11975933952*a^17-50248197399127811/7983955968*a^15-23874012896\
00347/249498624*a^13-38361960915954509/3991977984*a^11-6182680666015153/997994\
496*a^9-1599684611167905/665329664*a^7-40727317600665/83166208*a^5-12224183282\
407/332664832*a^3-14461675125/83166208*a), 
  x_1+(-5547064829/1149689659392*a^31-198762412763/287422414848*a^29-687805206\
0577/191614943232*a^27-66195296164295/71855603712*a^25-422860607398109/3193582\
3872*a^23-2734647045526303/23951867904*a^21-29525685083133233/47903735808*a^19\
-1070262029839043/498997248*a^17-39246102262072279/7983955968*a^15-14954029348\
555949/1995988992*a^13-30121333647352985/3991977984*a^11-811853901110489/16633\
2416*a^9-1265993859283069/665329664*a^7-64933325713737/166332416*a^5-994739332\
6731/332664832*a^3-4354897295/20791552*a), 
  x_1+(-1493492281/383229886464*a^31-160514320315/287422414848*a^29-1850898333\
073/63871647744*a^27-106825758746347/143711207424*a^25-1022851334391265/958074\
71616*a^23-2202616032440041/23951867904*a^21-2638673511500635/5322637312*a^19-\
20623565958794069/11975933952*a^17-31445530093829441/7983955968*a^15-119534865\
23818433/1995988992*a^13-24012406658831515/3991977984*a^11-3870740056784281/99\
7994496*a^9-1001785753542603/665329664*a^7-51027717583475/166332416*a^5-765396\
7570241/332664832*a^3-8156784591/83166208*a), 
  x_1+(-1176118997/383229886464*a^31-42103685309/95807471616*a^29-145463013063\
5/63871647744*a^27-5236653866203/8981950464*a^25-799848997639121/95807471616*a\
^23-1715063680384769/23951867904*a^21-18384601179268157/47903735808*a^19-39619\
96504288151/2993983488*a^17-23952780632541893/7983955968*a^15-3005369284948071\
/665329664*a^13-5973296703083771/1330659328*a^11-29747379769841/10395776*a^9-7\
29603726117555/665329664*a^7-36518045255243/166332416*a^5-5255833154455/332664\
832*a^3-169535573/20791552*a), 
  x_1+(-487272313/287422414848*a^31-1289482523/5322637312*a^29-56183079677/449\
0975232*a^27-5085577912535/15967911936*a^25-36112639728673/7983955968*a^23-318\
9272954073/83166208*a^21-201995692295219/997994496*a^19-8201495758804571/11975\
933952*a^17-1011557716960833/665329664*a^15-2236739767280741/997994496*a^13-17\
7408973720/81217*a^11-1367869689663401/997994496*a^9-86490266015385/166332416*\
a^7-4321493733575/41583104*a^5-158216669023/20791552*a^3-1969866461/83166208*a\
), 
  x_1+(-1735709399/1149689659392*a^31-1291280693/5987966976*a^29-6396264585293\
/574844829696*a^27-2541087861115/8981950464*a^25-42685514533805/10645274624*a^\
23-704635388807/20791552*a^21-8528391072853951/47903735808*a^19-59698260155388\
5/997994496*a^17-10498421268613349/7983955968*a^15-119301033109277/62374656*a^\
13-2438287006999709/1330659328*a^11-140483039438057/124749312*a^9-277904882474\
087/665329664*a^7-852607404283/10395776*a^5-2022868142885/332664832*a^3-305498\
175/20791552*a), 
  x_1+(-52845581/47903735808*a^31-30349276577/191614943232*a^29-2370092990123/\
287422414848*a^27-20371368115427/95807471616*a^25-73720217065361/23951867904*a\
^23-1284352243605749/47903735808*a^21-3515944432549699/23951867904*a^19-124647\
74961780559/23951867904*a^17-304582431030689/249498624*a^15-7638974691417553/3\
991977984*a^13-3976728128662661/1995988992*a^11-891742205717041/665329664*a^9-\
91079389663493/166332416*a^7-39686017807615/332664832*a^5-1693131733677/166332\
416*a^3-26987157165/166332416*a), 
  x_1+(-95357711/95807471616*a^31-20543292065/143711207424*a^29-2140273073569/\
287422414848*a^27-13808606859559/71855603712*a^25-33352760105135/11975933952*a\
^23-24246999544157/997994496*a^21-3191274428266445/23951867904*a^19-1416208296\
425783/2993983488*a^17-738659504338743/665329664*a^15-578329556918107/33266483\
2*a^13-3600060517219415/1995988992*a^11-600817089113611/498997248*a^9-20130393\
478933/41583104*a^7-4219074351067/41583104*a^5-1247460863147/166332416*a^3-490\
31553/10395776*a), 
  x_1+(-1043517431/1149689659392*a^31-74714039867/574844829696*a^29-4302063456\
83/63871647744*a^27-49554089624131/287422414848*a^25-236438682180409/958074716\
16*a^23-1012923427454521/47903735808*a^21-5416054381750501/47903735808*a^19-92\
91109071900473/23951867904*a^17-6956535335235565/7983955968*a^15-5157390068325\
457/3991977984*a^13-1669406523173923/1330659328*a^11-515188561816595/665329664\
*a^9-189478179665259/665329664*a^7-18185272393811/332664832*a^5-1320914859311/\
332664832*a^3-4174999491/166332416*a), 
  x_1+(-14238539/71855603712*a^31-1791495523/63871647744*a^29-409329863627/287\
422414848*a^27-10140395897419/287422414848*a^25-11497774568405/23951867904*a^2\
3-182536292326145/47903735808*a^21-435878351900119/23951867904*a^19-1269052703\
115137/23951867904*a^17-31290683416997/332664832*a^15-391730738093537/39919779\
84*a^13-102831548431165/1995988992*a^11-4563805780177/1995988992*a^9+191935332\
3659/166332416*a^7+1774692313829/332664832*a^5+142041834383/166332416*a^3+7904\
567461/166332416*a), 
  x_1+(14238539/71855603712*a^31+1791495523/63871647744*a^29+409329863627/2874\
22414848*a^27+10140395897419/287422414848*a^25+11497774568405/23951867904*a^23\
+182536292326145/47903735808*a^21+435878351900119/23951867904*a^19+12690527031\
15137/23951867904*a^17+31290683416997/332664832*a^15+391730738093537/399197798\
4*a^13+102831548431165/1995988992*a^11+4563805780177/1995988992*a^9-1919353323\
659/166332416*a^7-1774692313829/332664832*a^5-142041834383/166332416*a^3-79045\
67461/166332416*a), 
  x_1+(1043517431/1149689659392*a^31+74714039867/574844829696*a^29+43020634568\
3/63871647744*a^27+49554089624131/287422414848*a^25+236438682180409/9580747161\
6*a^23+1012923427454521/47903735808*a^21+5416054381750501/47903735808*a^19+929\
1109071900473/23951867904*a^17+6956535335235565/7983955968*a^15+51573900683254\
57/3991977984*a^13+1669406523173923/1330659328*a^11+515188561816595/665329664*\
a^9+189478179665259/665329664*a^7+18185272393811/332664832*a^5+1320914859311/3\
32664832*a^3+4174999491/166332416*a), 
  x_1+(95357711/95807471616*a^31+20543292065/143711207424*a^29+2140273073569/2\
87422414848*a^27+13808606859559/71855603712*a^25+33352760105135/11975933952*a^\
23+24246999544157/997994496*a^21+3191274428266445/23951867904*a^19+14162082964\
25783/2993983488*a^17+738659504338743/665329664*a^15+578329556918107/332664832\
*a^13+3600060517219415/1995988992*a^11+600817089113611/498997248*a^9+201303934\
78933/41583104*a^7+4219074351067/41583104*a^5+1247460863147/166332416*a^3+4903\
1553/10395776*a), 
  x_1+(52845581/47903735808*a^31+30349276577/191614943232*a^29+2370092990123/2\
87422414848*a^27+20371368115427/95807471616*a^25+73720217065361/23951867904*a^\
23+1284352243605749/47903735808*a^21+3515944432549699/23951867904*a^19+1246477\
4961780559/23951867904*a^17+304582431030689/249498624*a^15+7638974691417553/39\
91977984*a^13+3976728128662661/1995988992*a^11+891742205717041/665329664*a^9+9\
1079389663493/166332416*a^7+39686017807615/332664832*a^5+1693131733677/1663324\
16*a^3+26987157165/166332416*a), 
  x_1+(1735709399/1149689659392*a^31+1291280693/5987966976*a^29+6396264585293/\
574844829696*a^27+2541087861115/8981950464*a^25+42685514533805/10645274624*a^2\
3+704635388807/20791552*a^21+8528391072853951/47903735808*a^19+596982601553885\
/997994496*a^17+10498421268613349/7983955968*a^15+119301033109277/62374656*a^1\
3+2438287006999709/1330659328*a^11+140483039438057/124749312*a^9+2779048824740\
87/665329664*a^7+852607404283/10395776*a^5+2022868142885/332664832*a^3+3054981\
75/20791552*a), 
  x_1+(487272313/287422414848*a^31+1289482523/5322637312*a^29+56183079677/4490\
975232*a^27+5085577912535/15967911936*a^25+36112639728673/7983955968*a^23+3189\
272954073/83166208*a^21+201995692295219/997994496*a^19+8201495758804571/119759\
33952*a^17+1011557716960833/665329664*a^15+2236739767280741/997994496*a^13+177\
408973720/81217*a^11+1367869689663401/997994496*a^9+86490266015385/166332416*a\
^7+4321493733575/41583104*a^5+158216669023/20791552*a^3+1969866461/83166208*a)
    , 
  x_1+(1176118997/383229886464*a^31+42103685309/95807471616*a^29+1454630130635\
/63871647744*a^27+5236653866203/8981950464*a^25+799848997639121/95807471616*a^\
23+1715063680384769/23951867904*a^21+18384601179268157/47903735808*a^19+396199\
6504288151/2993983488*a^17+23952780632541893/7983955968*a^15+3005369284948071/\
665329664*a^13+5973296703083771/1330659328*a^11+29747379769841/10395776*a^9+72\
9603726117555/665329664*a^7+36518045255243/166332416*a^5+5255833154455/3326648\
32*a^3+169535573/20791552*a), 
  x_1+(1493492281/383229886464*a^31+160514320315/287422414848*a^29+18508983330\
73/63871647744*a^27+106825758746347/143711207424*a^25+1022851334391265/9580747\
1616*a^23+2202616032440041/23951867904*a^21+2638673511500635/5322637312*a^19+2\
0623565958794069/11975933952*a^17+31445530093829441/7983955968*a^15+1195348652\
3818433/1995988992*a^13+24012406658831515/3991977984*a^11+3870740056784281/997\
994496*a^9+1001785753542603/665329664*a^7+51027717583475/166332416*a^5+7653967\
570241/332664832*a^3+8156784591/83166208*a), 
  x_1+(5547064829/1149689659392*a^31+198762412763/287422414848*a^29+6878052060\
577/191614943232*a^27+66195296164295/71855603712*a^25+422860607398109/31935823\
872*a^23+2734647045526303/23951867904*a^21+29525685083133233/47903735808*a^19+\
1070262029839043/498997248*a^17+39246102262072279/7983955968*a^15+149540293485\
55949/1995988992*a^13+30121333647352985/3991977984*a^11+811853901110489/166332\
416*a^9+1265993859283069/665329664*a^7+64933325713737/166332416*a^5+9947393326\
731/332664832*a^3+4354897295/20791552*a), 
  x_1+(2387137355/383229886464*a^31+21379846115/23951867904*a^29+2662520466019\
1/574844829696*a^27+18971202107023/15967911936*a^25+1634798202318467/958074716\
16*a^23+586712369596199/3991977984*a^21+37953053904796037/47903735808*a^19+329\
57719683582179/11975933952*a^17+50248197399127811/7983955968*a^15+238740128960\
0347/249498624*a^13+38361960915954509/3991977984*a^11+6182680666015153/9979944\
96*a^9+1599684611167905/665329664*a^7+40727317600665/83166208*a^5+122241832824\
07/332664832*a^3+14461675125/83166208*a), 
  x_1+(316262345/47903735808*a^31+544230109085/574844829696*a^29+294523748095/\
5987966976*a^27+13456452507369/10645274624*a^25+218036972525605/11975933952*a^\
23+7542152297609335/47903735808*a^21+851557088264065/997994496*a^19+7940814583\
462665/2661318656*a^17+6863185088448505/997994496*a^15+42093757889236855/39919\
77984*a^13+666391408259905/62374656*a^11+13870926281619145/1995988992*a^9+2263\
42997006495/83166208*a^7+186214113220445/332664832*a^5+887160368835/20791552*a\
^3+41420818635/166332416*a), 
  x_1+(7880365675/1149689659392*a^31+188274995653/191614943232*a^29+2932600451\
9411/574844829696*a^27+125492280368065/95807471616*a^25+1804896180880669/95807\
471616*a^23+7788995206315909/47903735808*a^21+4678435793811693/5322637312*a^19\
+73397761769467337/23951867904*a^17+18735311636618035/2661318656*a^15+42954988\
154550349/3991977984*a^13+43399863656624497/3991977984*a^11+4694298451896531/6\
65329664*a^9+1834984794705831/665329664*a^7+188249142918295/332664832*a^5+1422\
1659697487/332664832*a^3+33912557555/166332416*a), 
  x_1+(4042744285/574844829696*a^31+32187975751/31935823872*a^29+1879309603829\
/35927801856*a^27+6027429086209/4490975232*a^25+102640701975317/5322637312*a^2\
3+3980858518472945/23951867904*a^21+3579804831537031/3991977984*a^19+233443723\
4591057/748495872*a^17+9507239943635953/1330659328*a^15+7243398225169135/66532\
9664*a^13+1823743331458969/166332416*a^11+884899113733991/124749312*a^9+919781\
706076915/332664832*a^7+94151627687003/166332416*a^5+3557954556085/83166208*a^\
3+2410591001/10395776*a), 
  x_1+(2623944199/287422414848*a^31+752270973133/574844829696*a^29+10849175825\
23/15967911936*a^27+501373355503273/287422414848*a^25+600865108225135/23951867\
904*a^23+3456869752501177/15967911936*a^21+14012209706995975/11975933952*a^19+\
97667468483551439/23951867904*a^17+18687613575472417/1995988992*a^15+570832515\
30607471/3991977984*a^13+4801094662490959/332664832*a^11+6222754679697441/6653\
29664*a^9+606939117179801/166332416*a^7+248383159824721/332664832*a^5+46708072\
90457/83166208*a^3+45215963389/166332416*a), 
  x_1+(6288932627/383229886464*a^31+676177676227/287422414848*a^29+70221990704\
813/574844829696*a^27+8348368690499/2661318656*a^25+1441172196882701/319358238\
72*a^23+3110641133376895/7983955968*a^21+33644661220339553/15967911936*a^19+44\
007416662454225/5987966976*a^17+134869088235956483/7983955968*a^15+17187981627\
387251/665329664*a^13+104251404159613535/3991977984*a^11+8461693903983139/4989\
97248*a^9+4412765111459797/665329664*a^7+226547531784319/166332416*a^5+3433061\
5506473/332664832*a^3+22369886387/41583104*a) ]
gap> STOP_TEST( "polynome.tst", 10000000);   
