/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import java.awt.Color;
import java.util.Collection;
import org.freeplane.api.Dash;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.ConstantObject;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.core.util.RuleReference;
import org.freeplane.features.edge.AutomaticEdgeColor;
import org.freeplane.features.edge.EdgeBuilder;
import org.freeplane.features.edge.EdgeColorConfiguration;
import org.freeplane.features.edge.EdgeColorsConfigurationFactory;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class EdgeController
implements IExtension {
    public static final EdgeStyle STANDARD_EDGE_STYLE = EdgeStyle.EDGESTYLE_BEZIER;
    public static final Color STANDARD_EDGE_COLOR = new Color(Color.GRAY.getRGB());
    private final ExclusivePropertyChain<ObjectRule<Color, Rules>, NodeModel> colorHandlers;
    private final ExclusivePropertyChain<EdgeStyle, NodeModel> styleHandlers;
    private final ExclusivePropertyChain<Integer, NodeModel> widthHandlers;
    private final ExclusivePropertyChain<Dash, NodeModel> dashHandlers;
    private ModeController modeController;
    protected final EdgeColorsConfigurationFactory edgeColorsConfigurationFactory;

    public static EdgeController getController() {
        return EdgeController.getController(Controller.getCurrentModeController());
    }

    public static EdgeController getController(ModeController modeController) {
        return modeController.getExtension(EdgeController.class);
    }

    public static void install(EdgeController edgeController) {
        Controller.getCurrentModeController().addExtension(EdgeController.class, edgeController);
    }

    public EdgeController(final ModeController modeController) {
        this.modeController = modeController;
        this.edgeColorsConfigurationFactory = new EdgeColorsConfigurationFactory(modeController);
        this.colorHandlers = new ExclusivePropertyChain();
        this.styleHandlers = new ExclusivePropertyChain();
        this.widthHandlers = new ExclusivePropertyChain();
        this.dashHandlers = new ExclusivePropertyChain();
        this.addColorGetter(IPropertyHandler.NODE, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel node, LogicalStyleController.StyleOption option, ObjectRule<Color, Rules> currentValue) {
                return EdgeController.this.getStyleEdgeColorRule(node, option);
            }
        });
        this.addColorGetter(IPropertyHandler.AUTO, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel model, LogicalStyleController.StyleOption option, ObjectRule<Color, Rules> currentValue) {
                MapModel map = model.getMap();
                AutomaticEdgeColor layout = map.getRootNode().getExtension(AutomaticEdgeColor.class);
                if (layout != null) {
                    switch (layout.rule) {
                        case FOR_COLUMNS: {
                            return new RuleReference<Color, Rules>(Rules.BY_COLUMN);
                        }
                        case FOR_LEVELS: {
                            return new RuleReference<Color, Rules>(Rules.BY_LEVEL);
                        }
                        case FOR_BRANCHES: {
                            NodeModel parentNode = model.getParentNode();
                            if (parentNode == null || !parentNode.isRoot()) break;
                            return new RuleReference<Color, Rules>(Rules.BY_BRANCH);
                        }
                    }
                }
                return null;
            }
        });
        this.addColorGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel node, LogicalStyleController.StyleOption option, ObjectRule<Color, Rules> currentValue) {
                return new RuleReference<Color, Rules>(Rules.BY_PARENT);
            }
        });
        this.addStyleGetter(IPropertyHandler.STYLE, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, LogicalStyleController.StyleOption option, EdgeStyle currentValu) {
                return EdgeController.this.getStyleStyle(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.addStyleGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, LogicalStyleController.StyleOption option, EdgeStyle currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return STANDARD_EDGE_STYLE;
            }
        });
        this.addWidthGetter(IPropertyHandler.STYLE, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, LogicalStyleController.StyleOption option, Integer currentValue) {
                return EdgeController.this.getStyleWidth(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.addWidthGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, LogicalStyleController.StyleOption option, Integer currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return new Integer(1);
            }
        });
        this.addDashGetter(IPropertyHandler.STYLE, new IPropertyHandler<Dash, NodeModel>(){

            @Override
            public Dash getProperty(NodeModel node, LogicalStyleController.StyleOption option, Dash currentValue) {
                return EdgeController.this.getStyleDash(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.addDashGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Dash, NodeModel>(){

            @Override
            public Dash getProperty(NodeModel node, LogicalStyleController.StyleOption option, Dash currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return Dash.DEFAULT;
            }
        });
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        EdgeBuilder edgeBuilder = new EdgeBuilder(this);
        edgeBuilder.registerBy(readManager, writeManager);
    }

    public IPropertyHandler<ObjectRule<Color, Rules>, NodeModel> addColorGetter(Integer key, IPropertyHandler<ObjectRule<Color, Rules>, NodeModel> getter) {
        return this.colorHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<EdgeStyle, NodeModel> addStyleGetter(Integer key, IPropertyHandler<EdgeStyle, NodeModel> getter) {
        return this.styleHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Integer, NodeModel> addWidthGetter(Integer key, IPropertyHandler<Integer, NodeModel> getter) {
        return this.widthHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Dash, NodeModel> addDashGetter(Integer key, IPropertyHandler<Dash, NodeModel> getter) {
        return this.dashHandlers.addGetter(key, getter);
    }

    public Color getColor(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getColor(node, true, option);
    }

    public Color getColor(NodeModel node, boolean resolveColor, LogicalStyleController.StyleOption option) {
        NodeModel parentNode;
        ObjectRule<Color, Rules> colorRule = this.getColorRule(node, option);
        if (colorRule.hasValue()) {
            return colorRule.getValue();
        }
        if (Rules.BY_PARENT == colorRule.getRule() && (parentNode = node.getParentNode()) != null) {
            return this.getColor(parentNode, option);
        }
        return STANDARD_EDGE_COLOR;
    }

    public ObjectRule<Color, Rules> getColorRule(NodeModel node, LogicalStyleController.StyleOption option) {
        ObjectRule<Color, Rules> color = this.colorHandlers.getProperty(node, option);
        return color;
    }

    public EdgeStyle getStyle(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getStyle(node, option, true);
    }

    public EdgeStyle getStyle(NodeModel node, LogicalStyleController.StyleOption option, boolean resolveParent) {
        EdgeStyle style = this.styleHandlers.getProperty(node, option);
        if (style == null && resolveParent) {
            return this.getStyle(node.getParentNode(), option);
        }
        return style;
    }

    public int getWidth(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getWidth(node, option, true);
    }

    public Integer getWidth(NodeModel node, LogicalStyleController.StyleOption option, boolean resolveParent) {
        Integer width = this.widthHandlers.getProperty(node, option);
        if (width == null && resolveParent) {
            return this.getWidth(node.getParentNode(), option);
        }
        return width;
    }

    public Dash getDash(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getDash(node, option, true);
    }

    public Dash getDash(NodeModel node, LogicalStyleController.StyleOption option, boolean resolveParent) {
        Dash dash = this.dashHandlers.getProperty(node, option);
        if (dash == null && resolveParent) {
            return this.getDash(node.getParentNode(), option);
        }
        return dash;
    }

    private ObjectRule<Color, Rules> getStyleEdgeColorRule(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, option);
        MapStyleModel styles = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            ObjectRule<Color, Rules> nodeColor;
            AutomaticLayoutController automaticLayoutController;
            NodeModel styleNode = styles.getStyleNode(styleKey);
            if (styleNode == null || node != styleNode && map.getRootNode().containsExtension(AutomaticEdgeColor.class) && (automaticLayoutController = this.modeController.getExtension(AutomaticLayoutController.class)) != null && (MapStyleModel.DEFAULT_STYLE.equals(styleKey) || automaticLayoutController.isAutomaticLevelStyle(styleNode)) || (nodeColor = this.getNodeColorRule(styleNode)) == null) continue;
            return nodeColor;
        }
        return null;
    }

    private Integer getStyleWidth(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            int width;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (width = styleModel.getWidth()) == -1) continue;
            return width;
        }
        return null;
    }

    private Dash getStyleDash(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            Dash dash;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (dash = styleModel.getDash()) == null) continue;
            return dash;
        }
        return null;
    }

    private EdgeStyle getStyleStyle(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            EdgeStyle style;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (style = styleModel.getStyle()) == null) continue;
            return style;
        }
        return null;
    }

    private ObjectRule<Color, Rules> getNodeColorRule(NodeModel styleNode) {
        EdgeModel styleModel = EdgeModel.getModel(styleNode);
        if (styleModel == null) {
            return null;
        }
        Color styleColor = styleModel.getColor();
        if (styleColor == null) {
            return null;
        }
        return new ConstantObject<Color, Rules>(styleColor);
    }

    public boolean areEdgeColorsAvailable(MapModel map) {
        EdgeColorConfiguration configuration = this.edgeColorsConfigurationFactory.create(map);
        return configuration.areEdgeColorsAvailable();
    }

    public Color getEdgeColor(MapModel map, int colorCounter) {
        EdgeColorConfiguration configuration = this.edgeColorsConfigurationFactory.create(map);
        return configuration.getEdgeColor(colorCounter);
    }

    public static enum Rules {
        BY_PARENT,
        BY_COLUMN,
        BY_LEVEL,
        BY_BRANCH;

    }
}

