/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;

public class IndianNationType
extends NationType {
    public static final String TAG = "indian-nation-type";
    private List<RandomChoice<UnitType>> skills = null;
    private List<String> regions = null;
    private static final String PROBABILITY_TAG = "probability";
    private static final String SKILL_TAG = "skill";

    public IndianNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public boolean isEuropean() {
        return false;
    }

    @Override
    public boolean isIndian() {
        return true;
    }

    @Override
    public boolean isREF() {
        return false;
    }

    public final String getSettlementTypeKey(boolean plural) {
        return this.getSettlementType(false).getId() + (plural ? ".plural" : "");
    }

    public List<RandomChoice<UnitType>> getSkills() {
        return this.skills == null ? Collections.emptyList() : this.skills;
    }

    protected void setSkills(List<RandomChoice<UnitType>> skills) {
        this.skills.clear();
        this.skills.addAll(skills);
    }

    private void addSkill(UnitType unitType, int probability) {
        if (this.skills == null) {
            this.skills = new ArrayList<RandomChoice<UnitType>>();
        }
        this.skills.add(new RandomChoice<UnitType>(unitType, probability));
    }

    public List<RandomChoice<UnitType>> generateSkillsForTile(Tile tile) {
        List<RandomChoice<UnitType>> skills = this.getSkills();
        Map<GoodsType, Integer> scale = CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), Function.identity(), Collectors.toMap(rc -> ((UnitType)rc.getObject()).getExpertProduction(), rc -> 1));
        for (Tile t : tile.getSurroundingTiles(1)) {
            CollectionUtils.forEachMapEntry(scale, e -> {
                GoodsType goodsType = (GoodsType)e.getKey();
                scale.put(goodsType, (Integer)e.getValue() + t.getPotentialProduction(goodsType, null));
            });
        }
        Function<RandomChoice, RandomChoice> mapper = rc -> {
            UnitType ut = (UnitType)rc.getObject();
            int scaleValue = (Integer)scale.get(ut.getExpertProduction());
            return new RandomChoice<UnitType>(ut, rc.getProbability() * scaleValue);
        };
        return CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), mapper);
    }

    public List<String> getRegions() {
        return this.regions == null ? Collections.emptyList() : this.regions;
    }

    protected void setRegions(List<String> regions) {
        if (this.regions == null) {
            this.regions = new ArrayList<String>();
        } else {
            this.regions.clear();
        }
        this.regions.addAll(regions);
    }

    private void addRegion(String id) {
        if (this.regions == null) {
            this.regions = new ArrayList<String>();
        }
        this.regions.add(id);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        IndianNationType o = this.copyInCast(other, IndianNationType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setSkills(o.getSkills());
        this.setRegions(o.getRegions());
        return true;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (RandomChoice<UnitType> choice : this.getSkills()) {
            xw.writeStartElement(SKILL_TAG);
            xw.writeAttribute("id", choice.getObject());
            xw.writeAttribute(PROBABILITY_TAG, choice.getProbability());
            xw.writeEndElement();
        }
        for (String region : this.getRegions()) {
            xw.writeStartElement("region");
            xw.writeAttribute("id", region);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec;
        IndianNationType parent;
        if (xr.shouldClearContainers()) {
            this.skills = null;
            this.regions = null;
        }
        if ((parent = xr.getType(spec = this.getSpecification(), "extends", IndianNationType.class, this)) != this) {
            if (parent.skills != null && !parent.skills.isEmpty()) {
                if (this.skills == null) {
                    this.skills = new ArrayList<RandomChoice<UnitType>>();
                }
                this.skills.addAll(parent.skills);
            }
            if (parent.regions != null && !parent.regions.isEmpty()) {
                if (this.regions == null) {
                    this.regions = new ArrayList<String>();
                }
                this.regions.addAll(parent.regions);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (SKILL_TAG.equals(tag)) {
            this.addSkill(xr.getType(spec, "id", UnitType.class, null), xr.getAttribute(PROBABILITY_TAG, 0));
            xr.closeTag(SKILL_TAG);
        } else if ("region".equals(tag)) {
            this.addRegion(xr.readId());
            xr.closeTag("region");
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

