/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class RecordComponent
extends AbstractVariableDeclaration {
    public RecordComponentBinding binding;

    public RecordComponent(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.declarationEnd = n2;
    }

    public RecordComponent(char[] cArray, long l, TypeReference typeReference, int n) {
        this(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        if (typeReference != null) {
            this.bits |= typeReference.bits & 0x100000;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceStart);
    }

    @Override
    public int getKind() {
        return 7;
    }

    public void getAllAnnotationContexts(int n, List<AnnotationContext> list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this, n, list);
        this.traverse(annotationCollector, null);
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        RecordComponent.resolveAnnotations(blockScope, this.annotations, this.binding);
        if (this.annotations != null) {
            int n = this.annotations.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding = this.annotations[i].resolvedType;
                if (typeBinding == null || (typeBinding.getAnnotationTagBits() & 0x20000000000000L) == 0L) continue;
                this.bits |= 0x100000;
                break;
            }
        }
    }

    void validateNullAnnotations(BlockScope blockScope) {
        if (!blockScope.validateNullAnnotation(this.binding.tagBits, this.type, this.annotations)) {
            this.binding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
        }
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        RecordComponent.printIndent(n, stringBuffer);
        RecordComponent.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            RecordComponent.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        if (this.type == null) {
            stringBuffer.append("<no type> ");
        } else {
            this.type.print(0, stringBuffer).append(' ');
        }
        return stringBuffer.append(this.name);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, blockScope);
                }
            }
            this.type.traverse(aSTVisitor, blockScope);
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

