/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
/**
 * Returns the columns by pin.
 * @param {?} cols
 * @return {?}
 */
export function columnsByPin(cols) {
    var e_1, _a;
    /** @type {?} */
    var ret = {
        left: [],
        center: [],
        right: []
    };
    if (cols) {
        try {
            for (var cols_1 = tslib_1.__values(cols), cols_1_1 = cols_1.next(); !cols_1_1.done; cols_1_1 = cols_1.next()) {
                var col = cols_1_1.value;
                if (col.frozenLeft) {
                    ret.left.push(col);
                }
                else if (col.frozenRight) {
                    ret.right.push(col);
                }
                else {
                    ret.center.push(col);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (cols_1_1 && !cols_1_1.done && (_a = cols_1.return)) _a.call(cols_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return ret;
}
/**
 * Returns the widths of all group sets of a column
 * @param {?} groups
 * @param {?} all
 * @return {?}
 */
export function columnGroupWidths(groups, all) {
    return {
        left: columnTotalWidth(groups.left),
        center: columnTotalWidth(groups.center),
        right: columnTotalWidth(groups.right),
        total: Math.floor(columnTotalWidth(all))
    };
}
/**
 * Calculates the total width of all columns and their groups
 * @param {?} columns
 * @param {?=} prop
 * @return {?}
 */
export function columnTotalWidth(columns, prop) {
    var e_2, _a;
    /** @type {?} */
    var totalWidth = 0;
    if (columns) {
        try {
            for (var columns_1 = tslib_1.__values(columns), columns_1_1 = columns_1.next(); !columns_1_1.done; columns_1_1 = columns_1.next()) {
                var c = columns_1_1.value;
                /** @type {?} */
                var has = prop && c[prop];
                /** @type {?} */
                var width = has ? c[prop] : c.width;
                totalWidth = totalWidth + parseFloat(width);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (columns_1_1 && !columns_1_1.done && (_a = columns_1.return)) _a.call(columns_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return totalWidth;
}
/**
 * Calculates the total width of all columns and their groups
 * @param {?} columns
 * @param {?=} prop
 * @return {?}
 */
export function columnsTotalWidth(columns, prop) {
    var e_3, _a;
    /** @type {?} */
    var totalWidth = 0;
    try {
        for (var columns_2 = tslib_1.__values(columns), columns_2_1 = columns_2.next(); !columns_2_1.done; columns_2_1 = columns_2.next()) {
            var column = columns_2_1.value;
            /** @type {?} */
            var has = prop && column[prop];
            totalWidth = totalWidth + (has ? column[prop] : column.width);
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (columns_2_1 && !columns_2_1.done && (_a = columns_2.return)) _a.call(columns_2);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return totalWidth;
}
/**
 * @param {?} val
 * @return {?}
 */
export function columnsByPinArr(val) {
    /** @type {?} */
    var colsByPinArr = [];
    /** @type {?} */
    var colsByPin = columnsByPin(val);
    colsByPinArr.push({ type: 'left', columns: colsByPin['left'] });
    colsByPinArr.push({ type: 'center', columns: colsByPin['center'] });
    colsByPinArr.push({ type: 'right', columns: colsByPin['right'] });
    return colsByPinArr;
}
//# sourceMappingURL=data:application/json;base64,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