# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


from PyQt6 import QtGui


# Global definitions.
#
# Note: other modules should use 'import globdef as',
# and not 'from globdef import'. The latter will
# ignore changes made after import, e.g. by darkpal().
 

# Fonts.
#
VAL_FONT = QtGui.QFont ("helvetica", 8, QtGui.QFont.Weight.Normal)
BUT_FONT = QtGui.QFont ("helvetica", 9, QtGui.QFont.Weight.Bold)
LAB_FONT = QtGui.QFont ("sans", 8, QtGui.QFont.Weight.Bold)

# Colors.
#
COL0 = QtGui.QColor (0, 0, 0)
COL2 = QtGui.QColor (255, 0, 0)
COL3 = QtGui.QColor (255, 140, 0)
COL4 = QtGui.QColor (255, 235, 0)
COL5 = QtGui.QColor (0, 255, 0)
COL6 = QtGui.QColor (0, 0, 150)
COL9 = QtGui.QColor (255, 255, 255)
FG_N = QtGui.QColor (210, 210, 220)
MK_N = COL0

# Dark theme.
#
def darkpal (app):
    global FG_N, MK_N
    
    bgc = QtGui.QColor (70, 70, 70)
    fgc = QtGui.QColor (255, 255, 255)
    dark = QtGui.QColor (0, 0, 0)
    lite = QtGui.QColor (150, 150, 150)
    pal = app.palette()
    pal.setColor(pal.ColorRole.Window, bgc)
    pal.setColor(pal.ColorRole.Button, bgc)
    pal.setColor(pal.ColorRole.Base, bgc)
    pal.setColor(pal.ColorRole.WindowText, fgc)
    pal.setColor(pal.ColorRole.ButtonText, fgc)
    pal.setColor(pal.ColorRole.Text, fgc)
    pal.setColor(pal.ColorRole.Dark, dark)
    pal.setColor(pal.ColorRole.Light, lite)
    app.setPalette (pal)
    FG_N = QtGui.QColor (80, 80, 170)
    MK_N = COL9

