/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.ConsumerDelegate;
import org.apache.kafka.clients.consumer.internals.ConsumerDelegateCreator;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.KafkaConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;

public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final ConsumerDelegateCreator CREATOR = new ConsumerDelegateCreator();
    private final ConsumerDelegate<K, V> delegate;

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(Utils.propsToMap(properties), keyDeserializer, valueDeserializer);
    }

    public KafkaConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.appendDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    KafkaConsumer(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this.delegate = CREATOR.create(config, keyDeserializer, valueDeserializer);
    }

    KafkaConsumer(LogContext logContext, Time time, ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, KafkaClient client, SubscriptionState subscriptions, ConsumerMetadata metadata, List<ConsumerPartitionAssignor> assignors) {
        this.delegate = CREATOR.create(logContext, time, config, keyDeserializer, valueDeserializer, client, subscriptions, metadata, assignors);
    }

    @Override
    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    @Override
    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.delegate.subscribe(topics, listener);
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.delegate.subscribe(topics);
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.delegate.subscribe(pattern, listener);
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern);
    }

    @Override
    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    @Override
    public void assign(Collection<TopicPartition> partitions) {
        this.delegate.assign(partitions);
    }

    @Override
    @Deprecated
    public ConsumerRecords<K, V> poll(long timeoutMs) {
        return this.delegate.poll(timeoutMs);
    }

    @Override
    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.delegate.poll(timeout);
    }

    @Override
    public void commitSync() {
        this.delegate.commitSync();
    }

    @Override
    public void commitSync(Duration timeout) {
        this.delegate.commitSync(timeout);
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.delegate.commitSync(offsets, timeout);
    }

    @Override
    public void commitAsync() {
        this.delegate.commitAsync();
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.delegate.commitAsync(callback);
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.delegate.commitAsync(offsets, callback);
    }

    @Override
    public void seek(TopicPartition partition, long offset) {
        this.delegate.seek(partition, offset);
    }

    @Override
    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.delegate.seek(partition, offsetAndMetadata);
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.delegate.seekToBeginning(partitions);
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.delegate.seekToEnd(partitions);
    }

    @Override
    public long position(TopicPartition partition) {
        return this.delegate.position(partition);
    }

    @Override
    public long position(TopicPartition partition, Duration timeout) {
        return this.delegate.position(partition, timeout);
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.delegate.committed(partition);
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.delegate.committed(partition, timeout);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.delegate.committed(partitions);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.delegate.committed(partitions, timeout);
    }

    @Override
    public Uuid clientInstanceId(Duration timeout) {
        return this.delegate.clientInstanceId(timeout);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.delegate.partitionsFor(topic, timeout);
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.delegate.listTopics(timeout);
    }

    @Override
    public void pause(Collection<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    @Override
    public void resume(Collection<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    @Override
    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.delegate.offsetsForTimes(timestampsToSearch);
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.delegate.offsetsForTimes(timestampsToSearch, timeout);
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.beginningOffsets(partitions);
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.beginningOffsets(partitions, timeout);
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.endOffsets(partitions);
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.endOffsets(partitions, timeout);
    }

    @Override
    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.delegate.currentLag(topicPartition);
    }

    @Override
    public ConsumerGroupMetadata groupMetadata() {
        return this.delegate.groupMetadata();
    }

    @Override
    public void enforceRebalance(String reason) {
        this.delegate.enforceRebalance(reason);
    }

    @Override
    public void enforceRebalance() {
        this.delegate.enforceRebalance();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }

    @Override
    public void wakeup() {
        this.delegate.wakeup();
    }

    String clientId() {
        return this.delegate.clientId();
    }

    Metrics metricsRegistry() {
        return this.delegate.metricsRegistry();
    }

    KafkaConsumerMetrics kafkaConsumerMetrics() {
        return this.delegate.kafkaConsumerMetrics();
    }

    boolean updateAssignmentMetadataIfNeeded(Timer timer) {
        return this.delegate.updateAssignmentMetadataIfNeeded(timer);
    }
}

