/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.service;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.active.AsynchronousSearchActiveContext;
import org.opensearch.search.asynchronous.context.active.AsynchronousSearchActiveStore;
import org.opensearch.search.asynchronous.context.persistence.AsynchronousSearchPersistenceContext;
import org.opensearch.search.asynchronous.context.persistence.AsynchronousSearchPersistenceModel;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchState;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchStateMachine;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchStateMachineClosedException;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchTransition;
import org.opensearch.search.asynchronous.context.state.event.BeginPersistEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchDeletedEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchFailureEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchResponsePersistFailedEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchResponsePersistedEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchStartedEvent;
import org.opensearch.search.asynchronous.context.state.event.SearchSuccessfulEvent;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchContextEventListener;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchProgressListener;
import org.opensearch.search.asynchronous.processor.AsynchronousSearchPostProcessor;
import org.opensearch.search.asynchronous.request.SubmitAsynchronousSearchRequest;
import org.opensearch.search.asynchronous.service.AsynchronousSearchPersistenceService;
import org.opensearch.search.asynchronous.settings.LegacyOpendistroAsynchronousSearchSettings;
import org.opensearch.search.asynchronous.stats.AsynchronousSearchStats;
import org.opensearch.search.asynchronous.stats.InternalAsynchronousSearchStats;
import org.opensearch.search.asynchronous.utils.AsynchronousSearchExceptionUtils;
import org.opensearch.search.asynchronous.utils.UserAuthUtils;
import org.opensearch.threadpool.ThreadPool;

public class AsynchronousSearchService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchService.class);
    public static final Setting<TimeValue> MAX_KEEP_ALIVE_SETTING = Setting.positiveTimeSetting((String)"plugins.asynchronous_search.max_keep_alive", LegacyOpendistroAsynchronousSearchSettings.MAX_KEEP_ALIVE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> MAX_SEARCH_RUNNING_TIME_SETTING = Setting.positiveTimeSetting((String)"plugins.asynchronous_search.max_search_running_time", LegacyOpendistroAsynchronousSearchSettings.MAX_SEARCH_RUNNING_TIME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> MAX_WAIT_FOR_COMPLETION_TIMEOUT_SETTING = Setting.positiveTimeSetting((String)"plugins.asynchronous_search.max_wait_for_completion_timeout", LegacyOpendistroAsynchronousSearchSettings.MAX_WAIT_FOR_COMPLETION_TIMEOUT_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> PERSIST_SEARCH_FAILURES_SETTING = Setting.boolSetting((String)"plugins.asynchronous_search.persist_search_failures", LegacyOpendistroAsynchronousSearchSettings.PERSIST_SEARCH_FAILURES_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile long maxKeepAlive;
    private volatile long maxWaitForCompletionTimeout;
    private volatile long maxSearchRunningTime;
    private final AtomicLong idGenerator = new AtomicLong();
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AsynchronousSearchPersistenceService persistenceService;
    private final AsynchronousSearchActiveStore asynchronousSearchActiveStore;
    private final AsynchronousSearchPostProcessor asynchronousSearchPostProcessor;
    private final LongSupplier currentTimeSupplier;
    private final AsynchronousSearchStateMachine asynchronousSearchStateMachine;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final AsynchronousSearchContextEventListener contextEventListener;
    private volatile boolean persistSearchFailure;

    public AsynchronousSearchService(AsynchronousSearchPersistenceService asynchronousSearchPersistenceService, AsynchronousSearchActiveStore asynchronousSearchActiveStore, Client client, ClusterService clusterService, ThreadPool threadPool, AsynchronousSearchContextEventListener contextEventListener, NamedWriteableRegistry namedWriteableRegistry) {
        this.contextEventListener = contextEventListener;
        this.client = client;
        Settings settings = clusterService.getSettings();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_KEEP_ALIVE_SETTING, this::setKeepAlive);
        this.setKeepAlive((TimeValue)MAX_KEEP_ALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_WAIT_FOR_COMPLETION_TIMEOUT_SETTING, this::setMaxWaitForCompletionTimeout);
        this.setMaxWaitForCompletionTimeout((TimeValue)MAX_WAIT_FOR_COMPLETION_TIMEOUT_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_SEARCH_RUNNING_TIME_SETTING, this::setMaxSearchRunningTime);
        this.setMaxSearchRunningTime((TimeValue)MAX_SEARCH_RUNNING_TIME_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(PERSIST_SEARCH_FAILURES_SETTING, this::setPersistSearchFailure);
        this.setPersistSearchFailure((Boolean)PERSIST_SEARCH_FAILURES_SETTING.get(clusterService.getSettings()));
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.persistenceService = asynchronousSearchPersistenceService;
        this.currentTimeSupplier = System::currentTimeMillis;
        this.asynchronousSearchActiveStore = asynchronousSearchActiveStore;
        this.asynchronousSearchStateMachine = this.initStateMachine();
        this.asynchronousSearchPostProcessor = new AsynchronousSearchPostProcessor(this.persistenceService, asynchronousSearchActiveStore, this.asynchronousSearchStateMachine, this::freeActiveContext, threadPool, clusterService);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    private void setMaxSearchRunningTime(TimeValue maxSearchRunningTime) {
        this.maxSearchRunningTime = maxSearchRunningTime.millis();
    }

    private void setMaxWaitForCompletionTimeout(TimeValue maxWaitForCompletionTimeout) {
        this.maxWaitForCompletionTimeout = maxWaitForCompletionTimeout.millis();
    }

    private void setKeepAlive(TimeValue maxKeepAlive) {
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    public AsynchronousSearchContext createAndStoreContext(SubmitAsynchronousSearchRequest request, long relativeStartTimeMillis, Supplier<InternalAggregation.ReduceContextBuilder> reduceContextBuilder, User user) {
        this.validateRequest(request);
        AsynchronousSearchContextId asynchronousSearchContextId = new AsynchronousSearchContextId(UUIDs.base64UUID(), this.idGenerator.incrementAndGet());
        this.contextEventListener.onNewContext(asynchronousSearchContextId);
        AsynchronousSearchProgressListener progressActionListener = new AsynchronousSearchProgressListener(relativeStartTimeMillis, response -> this.asynchronousSearchPostProcessor.processSearchResponse((SearchResponse)response, asynchronousSearchContextId), e -> this.asynchronousSearchPostProcessor.processSearchFailure((Exception)e, asynchronousSearchContextId), this.threadPool.executor("opensearch_asynchronous_search_generic"), () -> ((ThreadPool)this.threadPool).relativeTimeInMillis(), reduceContextBuilder);
        AsynchronousSearchActiveContext asynchronousSearchContext = new AsynchronousSearchActiveContext(asynchronousSearchContextId, this.clusterService.localNode().getId(), request.getKeepAlive(), request.getKeepOnCompletion(), this.threadPool, this.currentTimeSupplier, progressActionListener, user, () -> this.persistSearchFailure);
        this.asynchronousSearchActiveStore.putContext(asynchronousSearchContextId, asynchronousSearchContext, this.contextEventListener::onContextRejected);
        this.contextEventListener.onContextInitialized(asynchronousSearchContextId);
        return asynchronousSearchContext;
    }

    public void bootstrapSearch(SearchTask searchTask, AsynchronousSearchContextId asynchronousSearchContextId) {
        Optional<AsynchronousSearchActiveContext> asynchronousSearchContextOptional = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        if (asynchronousSearchContextOptional.isPresent()) {
            AsynchronousSearchActiveContext context = asynchronousSearchContextOptional.get();
            try {
                this.asynchronousSearchStateMachine.trigger(new SearchStartedEvent(context, searchTask));
            }
            catch (AsynchronousSearchStateMachineClosedException e) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Unexpected! State machine already closed for context [%s] while triggering event [%s]", context.getAsynchronousSearchId(), SearchStartedEvent.class.getName()));
            }
        }
    }

    public void findContext(String id, AsynchronousSearchContextId asynchronousSearchContextId, User user, ActionListener<AsynchronousSearchContext> listener) {
        ActionListener<AsynchronousSearchContext> exceptionTranslationListener = this.getExceptionTranslationWrapper(id, listener);
        Optional<AsynchronousSearchActiveContext> optionalAsynchronousSearchActiveContext = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        if (optionalAsynchronousSearchActiveContext.isPresent() && optionalAsynchronousSearchActiveContext.get().isAlive()) {
            logger.debug("Active context is present for asynchronous search ID [{}]", (Object)id);
            AsynchronousSearchActiveContext asynchronousSearchActiveContext = optionalAsynchronousSearchActiveContext.get();
            if (!UserAuthUtils.isUserValid(user, asynchronousSearchActiveContext.getUser())) {
                logger.debug("Invalid user requesting GET active context for asynchronous search id {}", (Object)id);
                exceptionTranslationListener.onFailure((Exception)new OpenSearchSecurityException("User doesn't have necessary roles to access the asynchronous search with id " + id, RestStatus.FORBIDDEN, new Object[0]));
            } else {
                exceptionTranslationListener.onResponse((Object)asynchronousSearchActiveContext);
            }
        } else {
            logger.debug("Active context is not present for asynchronous search ID [{}]", (Object)id);
            this.persistenceService.getResponse(id, user, (ActionListener<AsynchronousSearchPersistenceModel>)ActionListener.wrap(persistenceModel -> exceptionTranslationListener.onResponse((Object)new AsynchronousSearchPersistenceContext(id, asynchronousSearchContextId, (AsynchronousSearchPersistenceModel)persistenceModel, this.currentTimeSupplier, this.namedWriteableRegistry)), ex -> {
                logger.debug(() -> new ParameterizedMessage("Context not found for ID  in the system index {}", (Object)id), (Throwable)ex);
                exceptionTranslationListener.onFailure(ex);
            }));
        }
    }

    public Map<Long, AsynchronousSearchActiveContext> getAllActiveContexts() {
        return this.asynchronousSearchActiveStore.getAllContexts();
    }

    public Set<AsynchronousSearchContext> getContextsToReap() {
        Map<Long, AsynchronousSearchActiveContext> allContexts = this.asynchronousSearchActiveStore.getAllContexts();
        return Collections.unmodifiableSet(allContexts.values().stream().filter(Objects::nonNull).filter(c -> EnumSet.of(AsynchronousSearchState.CLOSED, AsynchronousSearchState.PERSIST_FAILED).contains((Object)c.getAsynchronousSearchState()) || this.isOverRunning((AsynchronousSearchActiveContext)c) || c.isExpired()).collect(Collectors.toSet()));
    }

    public void freeContext(String id, AsynchronousSearchContextId asynchronousSearchContextId, User user, ActionListener<Boolean> listener) {
        ActionListener<Boolean> exceptionTranslationWrapper = this.getExceptionTranslationWrapper(id, listener);
        Optional<AsynchronousSearchActiveContext> asynchronousSearchContextOptional = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        if (asynchronousSearchContextOptional.isPresent()) {
            logger.debug("Active context present for asynchronous search id [{}]", (Object)id);
            AsynchronousSearchActiveContext asynchronousSearchContext = asynchronousSearchContextOptional.get();
            if (UserAuthUtils.isUserValid(user, asynchronousSearchContext.getUser())) {
                this.cancelAndFreeActiveAndPersistedContext(asynchronousSearchContext, exceptionTranslationWrapper, user);
            } else {
                exceptionTranslationWrapper.onFailure((Exception)new OpenSearchSecurityException("User doesn't have necessary roles to access the asynchronous search with id " + id, RestStatus.FORBIDDEN, new Object[0]));
            }
        } else {
            logger.debug("Active context NOT present for asynchronous search [{}]", (Object)id);
            logger.debug("Deleting asynchronous search [{}] from system index ", (Object)id);
            this.persistenceService.deleteResponse(id, user, exceptionTranslationWrapper);
        }
    }

    private void cancelTask(AsynchronousSearchActiveContext asynchronousSearchContext, String reason, ActionListener<CancelTasksResponse> listener) {
        CancelTasksRequest cancelTasksRequest = ((CancelTasksRequest)new CancelTasksRequest().setTaskId(new TaskId(this.clusterService.localNode().getId(), asynchronousSearchContext.getTask().getId()))).setReason(reason);
        this.client.admin().cluster().cancelTasks(cancelTasksRequest, listener);
    }

    private boolean shouldCancel(AsynchronousSearchActiveContext asynchronousSearchContext) {
        return asynchronousSearchContext.getTask() != null && !asynchronousSearchContext.getTask().isCancelled() && !asynchronousSearchContext.isCompleted();
    }

    private void cancelAndFreeActiveAndPersistedContext(AsynchronousSearchActiveContext asynchronousSearchContext, ActionListener<Boolean> listener, User user) {
        AtomicReference<Releasable> releasableReference = new AtomicReference<Releasable>(() -> {});
        ActionListener releasableListener = ActionListener.runAfter(listener, () -> ((Releasable)releasableReference.get()).close());
        GroupedActionListener groupedDeletionListener = new GroupedActionListener(ActionListener.wrap(responses -> {
            if (responses.stream().anyMatch(r -> r)) {
                logger.debug("Free context for asynchronous search [{}] successful ", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                releasableListener.onResponse((Object)true);
            } else {
                logger.debug("Freeing context, asynchronous search [{}] not found ", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                releasableListener.onFailure((Exception)new ResourceNotFoundException(asynchronousSearchContext.getAsynchronousSearchId(), new Object[0]));
            }
        }, arg_0 -> ((ActionListener)releasableListener).onFailure(arg_0)), 2);
        ActionListener translatedListener = ActionListener.wrap(arg_0 -> ((GroupedActionListener)groupedDeletionListener).onResponse(arg_0), ex -> {
            if (ex instanceof ResourceNotFoundException) {
                groupedDeletionListener.onResponse((Object)false);
            } else {
                logger.debug(() -> new ParameterizedMessage("Translating exception, received for asynchronous search [{}]", (Object)asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)ex);
                groupedDeletionListener.onFailure(ex);
            }
        });
        String triggeredBy = user != null ? " by user [" + String.valueOf(user) + "]" : "";
        String cancelTaskReason = "Delete asynchronous search [" + asynchronousSearchContext.getAsynchronousSearchId() + "] has been triggered" + triggeredBy + ". Attempting to cancel in-progress search task";
        asynchronousSearchContext.acquireContextPermitIfRequired((ActionListener<Releasable>)ActionListener.wrap(releasable -> {
            releasableReference.set((Releasable)releasable);
            if (asynchronousSearchContext.keepOnCompletion()) {
                this.handleCancelTaskPermitAcquired(asynchronousSearchContext, (ActionListener<Boolean>)groupedDeletionListener, cancelTaskReason);
                logger.debug("Deleting asynchronous search id [{}] from system index ", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                this.persistenceService.deleteResponse(asynchronousSearchContext.getAsynchronousSearchId(), user, (ActionListener<Boolean>)translatedListener);
            } else {
                this.handleCancelTaskPermitAcquired(asynchronousSearchContext, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                    if (r.booleanValue()) {
                        releasableListener.onResponse((Object)true);
                    } else {
                        releasableListener.onFailure((Exception)new ResourceNotFoundException(asynchronousSearchContext.getAsynchronousSearchId(), new Object[0]));
                    }
                }, arg_0 -> ((ActionListener)releasableListener).onFailure(arg_0)), cancelTaskReason);
            }
        }, exception -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exception);
            if (cause instanceof TimeoutException) {
                logger.debug(() -> new ParameterizedMessage("Failed to acquire permits for asynchronous search id [{}] for updating context within timeout 5s", (Object)asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)exception);
                listener.onFailure((Exception)new OpenSearchTimeoutException(asynchronousSearchContext.getAsynchronousSearchId(), new Object[0]));
            } else if (asynchronousSearchContext.keepOnCompletion()) {
                this.handleCancelTaskPermitAcquisitionFailed(asynchronousSearchContext, (ActionListener<Boolean>)groupedDeletionListener, cancelTaskReason, (Exception)exception);
                logger.debug("Deleting asynchronous search id [{}] from system index ", (Object)asynchronousSearchContext.getAsynchronousSearchId());
                this.persistenceService.deleteResponse(asynchronousSearchContext.getAsynchronousSearchId(), user, (ActionListener<Boolean>)translatedListener);
            } else {
                this.handleCancelTaskPermitAcquisitionFailed(asynchronousSearchContext, (ActionListener<Boolean>)releasableListener, cancelTaskReason, (Exception)exception);
            }
        }), TimeValue.timeValueSeconds((long)5L), "free context");
    }

    private void handleCancelTaskPermitAcquisitionFailed(AsynchronousSearchActiveContext asynchronousSearchContext, ActionListener<Boolean> listener, String cancelTaskReason, Exception e) {
        logger.debug(() -> new ParameterizedMessage("Failed to acquire permits for asynchronous search id [{}] for freeing context", (Object)asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)e);
        if (this.shouldCancel(asynchronousSearchContext)) {
            this.cancelTask(asynchronousSearchContext, cancelTaskReason, (ActionListener<CancelTasksResponse>)ActionListener.wrap(() -> listener.onResponse((Object)false)));
        } else {
            listener.onResponse((Object)false);
        }
    }

    private void handleCancelTaskPermitAcquired(AsynchronousSearchActiveContext asynchronousSearchContext, ActionListener<Boolean> listener, String cancelTaskReason) {
        if (this.shouldCancel(asynchronousSearchContext)) {
            this.cancelTask(asynchronousSearchContext, cancelTaskReason, (ActionListener<CancelTasksResponse>)ActionListener.wrap(cancelTasksResponse -> {
                logger.debug("Successfully cancelled tasks [{}] with asynchronous search [{}] with response [{}]", (Object)asynchronousSearchContext.getTask(), (Object)asynchronousSearchContext.getAsynchronousSearchId(), cancelTasksResponse);
                listener.onResponse((Object)true);
            }, e -> {
                logger.error(() -> new ParameterizedMessage("Failed to cancel task [{}] with asynchronous search [{}] with exception", (Object)asynchronousSearchContext.getTask(), (Object)asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)e);
                listener.onResponse((Object)this.freeActiveContext(asynchronousSearchContext));
            }));
        } else {
            listener.onResponse((Object)this.freeActiveContext(asynchronousSearchContext));
        }
    }

    boolean freeActiveContext(AsynchronousSearchActiveContext asynchronousSearchContext) {
        try {
            assert (asynchronousSearchContext.getTask() == null || asynchronousSearchContext.getTask().isCancelled() || asynchronousSearchContext.isCompleted()) : "Either the asynchronous search task should have been cancelled or completed ";
            this.asynchronousSearchStateMachine.trigger(new SearchDeletedEvent(asynchronousSearchContext));
            return true;
        }
        catch (AsynchronousSearchStateMachineClosedException ex) {
            logger.debug(() -> new ParameterizedMessage("Exception while freeing up active context", new Object[0]), (Throwable)ex);
            return false;
        }
    }

    public boolean onCancelledFreeActiveContext(AsynchronousSearchActiveContext asynchronousSearchContext) {
        this.contextEventListener.onContextCancelled(asynchronousSearchContext.getContextId());
        return this.freeActiveContext(asynchronousSearchContext);
    }

    public void updateKeepAliveAndGetContext(String id, TimeValue keepAlive, AsynchronousSearchContextId asynchronousSearchContextId, User user, ActionListener<AsynchronousSearchContext> listener) {
        ActionListener<AsynchronousSearchContext> exceptionTranslationWrapper = this.getExceptionTranslationWrapper(id, listener);
        this.validateKeepAlive(keepAlive);
        long requestedExpirationTime = this.currentTimeSupplier.getAsLong() + keepAlive.getMillis();
        Optional<AsynchronousSearchActiveContext> asynchronousSearchContextOptional = this.asynchronousSearchActiveStore.getContext(asynchronousSearchContextId);
        if (asynchronousSearchContextOptional.isPresent()) {
            AsynchronousSearchActiveContext asynchronousSearchActiveContext = asynchronousSearchContextOptional.get();
            asynchronousSearchActiveContext.acquireContextPermitIfRequired((ActionListener<Releasable>)ActionListener.wrap(releasable -> {
                ActionListener releasableActionListener = ActionListener.runAfter((ActionListener)exceptionTranslationWrapper, () -> ((Releasable)releasable).close());
                if (!asynchronousSearchActiveContext.isAlive() && asynchronousSearchActiveContext.keepOnCompletion()) {
                    logger.debug("Updating persistence store after state is PERSISTED asynchronous search id [{}] for updating context", (Object)asynchronousSearchActiveContext.getAsynchronousSearchId());
                    this.persistenceService.updateExpirationTime(id, requestedExpirationTime, user, (ActionListener<AsynchronousSearchPersistenceModel>)ActionListener.wrap(actionResponse -> releasableActionListener.onResponse((Object)new AsynchronousSearchPersistenceContext(id, asynchronousSearchContextId, (AsynchronousSearchPersistenceModel)actionResponse, this.currentTimeSupplier, this.namedWriteableRegistry)), arg_0 -> ((ActionListener)releasableActionListener).onFailure(arg_0)));
                } else if (UserAuthUtils.isUserValid(user, asynchronousSearchActiveContext.getUser())) {
                    logger.debug("Updating persistence store: NO as state is NOT PERSISTED yet asynchronous search id [{}] for updating context", (Object)asynchronousSearchActiveContext.getAsynchronousSearchId());
                    asynchronousSearchActiveContext.setExpirationTimeMillis(requestedExpirationTime);
                    releasableActionListener.onResponse((Object)asynchronousSearchActiveContext);
                } else {
                    releasableActionListener.onFailure((Exception)new OpenSearchSecurityException("User doesn't have necessary roles to access the asynchronous search with id " + id, RestStatus.FORBIDDEN, new Object[0]));
                }
            }, exception -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exception);
                if (cause instanceof TimeoutException) {
                    logger.debug(() -> new ParameterizedMessage("Failed to acquire permits for asynchronous search id [{}] for updating context within timeout 5s", (Object)asynchronousSearchActiveContext.getAsynchronousSearchId()), (Throwable)exception);
                    listener.onFailure((Exception)new OpenSearchTimeoutException(id, new Object[0]));
                } else if (asynchronousSearchActiveContext.keepOnCompletion()) {
                    logger.debug("Updating persistence store after failing to acquire permits for asynchronous search id [{}] for updating context with expiration time [{}]", (Object)asynchronousSearchActiveContext.getAsynchronousSearchId(), (Object)requestedExpirationTime);
                    this.persistenceService.updateExpirationTime(id, requestedExpirationTime, user, (ActionListener<AsynchronousSearchPersistenceModel>)ActionListener.wrap(actionResponse -> exceptionTranslationWrapper.onResponse((Object)new AsynchronousSearchPersistenceContext(id, asynchronousSearchContextId, (AsynchronousSearchPersistenceModel)actionResponse, this.currentTimeSupplier, this.namedWriteableRegistry)), arg_0 -> ((ActionListener)exceptionTranslationWrapper).onFailure(arg_0)));
                } else {
                    exceptionTranslationWrapper.onFailure((Exception)new ResourceNotFoundException(asynchronousSearchActiveContext.getAsynchronousSearchId(), new Object[0]));
                }
            }), TimeValue.timeValueSeconds((long)5L), "update keep alive");
        } else {
            logger.debug("Updating persistence store after active context evicted for asynchronous search id [{}] for updating context", (Object)id);
            this.persistenceService.updateExpirationTime(id, requestedExpirationTime, user, (ActionListener<AsynchronousSearchPersistenceModel>)ActionListener.wrap(actionResponse -> exceptionTranslationWrapper.onResponse((Object)new AsynchronousSearchPersistenceContext(id, asynchronousSearchContextId, (AsynchronousSearchPersistenceModel)actionResponse, this.currentTimeSupplier, this.namedWriteableRegistry)), arg_0 -> exceptionTranslationWrapper.onFailure(arg_0)));
        }
    }

    AsynchronousSearchStateMachine getStateMachine() {
        return this.asynchronousSearchStateMachine;
    }

    private AsynchronousSearchStateMachine initStateMachine() {
        AsynchronousSearchStateMachine stateMachine = new AsynchronousSearchStateMachine(EnumSet.allOf(AsynchronousSearchState.class), AsynchronousSearchState.INIT, this.contextEventListener);
        stateMachine.markTerminalStates(EnumSet.of(AsynchronousSearchState.CLOSED));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchStartedEvent>(AsynchronousSearchState.INIT, AsynchronousSearchState.RUNNING, (s, e) -> ((AsynchronousSearchActiveContext)e.asynchronousSearchContext()).setTask(e.getSearchTask()), (contextId, listener) -> listener.onContextRunning((AsynchronousSearchContextId)contextId), SearchStartedEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchSuccessfulEvent>(AsynchronousSearchState.RUNNING, AsynchronousSearchState.SUCCEEDED, (s, e) -> ((AsynchronousSearchActiveContext)e.asynchronousSearchContext()).processSearchResponse(e.getSearchResponse()), (contextId, listener) -> listener.onContextCompleted((AsynchronousSearchContextId)contextId), SearchSuccessfulEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchFailureEvent>(AsynchronousSearchState.RUNNING, AsynchronousSearchState.FAILED, (s, e) -> ((AsynchronousSearchActiveContext)e.asynchronousSearchContext()).processSearchFailure(e.getException()), (contextId, listener) -> listener.onContextFailed((AsynchronousSearchContextId)contextId), SearchFailureEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<BeginPersistEvent>(AsynchronousSearchState.SUCCEEDED, AsynchronousSearchState.PERSISTING, (s, e) -> this.asynchronousSearchPostProcessor.persistResponse((AsynchronousSearchActiveContext)e.asynchronousSearchContext(), e.getAsynchronousSearchPersistenceModel()), (contextId, listener) -> {}, BeginPersistEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<BeginPersistEvent>(AsynchronousSearchState.FAILED, AsynchronousSearchState.PERSISTING, (s, e) -> this.asynchronousSearchPostProcessor.persistResponse((AsynchronousSearchActiveContext)e.asynchronousSearchContext(), e.getAsynchronousSearchPersistenceModel()), (contextId, listener) -> {}, BeginPersistEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchResponsePersistedEvent>(AsynchronousSearchState.PERSISTING, AsynchronousSearchState.PERSIST_SUCCEEDED, (s, e) -> {}, (contextId, listener) -> listener.onContextPersisted((AsynchronousSearchContextId)contextId), SearchResponsePersistedEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchResponsePersistFailedEvent>(AsynchronousSearchState.PERSISTING, AsynchronousSearchState.PERSIST_FAILED, (s, e) -> {}, (contextId, listener) -> listener.onContextPersistFailed((AsynchronousSearchContextId)contextId), SearchResponsePersistFailedEvent.class));
        stateMachine.registerTransition(new AsynchronousSearchTransition<SearchDeletedEvent>(AsynchronousSearchState.RUNNING, AsynchronousSearchState.CLOSED, (s, e) -> this.asynchronousSearchActiveStore.freeContext(e.asynchronousSearchContext().getContextId()), (contextId, listener) -> listener.onRunningContextDeleted((AsynchronousSearchContextId)contextId), SearchDeletedEvent.class));
        for (AsynchronousSearchState asynchronousSearchState : EnumSet.of(AsynchronousSearchState.PERSISTING, new AsynchronousSearchState[]{AsynchronousSearchState.PERSIST_SUCCEEDED, AsynchronousSearchState.PERSIST_FAILED, AsynchronousSearchState.SUCCEEDED, AsynchronousSearchState.FAILED, AsynchronousSearchState.INIT})) {
            stateMachine.registerTransition(new AsynchronousSearchTransition<SearchDeletedEvent>(asynchronousSearchState, AsynchronousSearchState.CLOSED, (s, e) -> this.asynchronousSearchActiveStore.freeContext(e.asynchronousSearchContext().getContextId()), (contextId, listener) -> listener.onContextDeleted((AsynchronousSearchContextId)contextId), SearchDeletedEvent.class));
        }
        return stateMachine;
    }

    public void clusterChanged(ClusterChangedEvent event) {
    }

    protected void doStart() {
    }

    protected void doStop() {
        for (AsynchronousSearchContext asynchronousSearchContext : this.asynchronousSearchActiveStore.getAllContexts().values()) {
            this.freeActiveContext((AsynchronousSearchActiveContext)asynchronousSearchContext);
        }
    }

    protected void doClose() {
        this.doStop();
    }

    public AsynchronousSearchStats stats() {
        return ((InternalAsynchronousSearchStats)this.contextEventListener).stats(this.clusterService.localNode());
    }

    public long getMaxWaitForCompletionTimeout() {
        return this.maxWaitForCompletionTimeout;
    }

    private void validateRequest(SubmitAsynchronousSearchRequest request) {
        TimeValue keepAlive = request.getKeepAlive();
        this.validateKeepAlive(keepAlive);
        TimeValue waitForCompletionTimeout = request.getWaitForCompletionTimeout();
        this.validateWaitForCompletionTimeout(waitForCompletionTimeout);
    }

    private void validateWaitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        if (waitForCompletionTimeout.getMillis() > this.maxWaitForCompletionTimeout) {
            throw new IllegalArgumentException("Wait for completion timeout for asynchronous search (" + waitForCompletionTimeout.getMillis() + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis((long)this.maxWaitForCompletionTimeout)) + ").This limit can be set by changing the [" + MAX_WAIT_FOR_COMPLETION_TIMEOUT_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private void validateKeepAlive(TimeValue keepAlive) {
        if (keepAlive.getMillis() > this.maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for asynchronous search (" + keepAlive.getMillis() + ") is too large. It must be less than (" + String.valueOf(TimeValue.timeValueMillis((long)this.maxKeepAlive)) + ").This limit can be set by changing the [" + MAX_KEEP_ALIVE_SETTING.getKey() + "] cluster level setting.");
        }
    }

    private boolean isOverRunning(AsynchronousSearchActiveContext asynchronousSearchActiveContext) {
        return EnumSet.of(AsynchronousSearchState.RUNNING, AsynchronousSearchState.INIT).contains((Object)asynchronousSearchActiveContext.getAsynchronousSearchState()) && asynchronousSearchActiveContext.getStartTimeMillis() + this.maxSearchRunningTime < this.threadPool.absoluteTimeInMillis();
    }

    private <T> ActionListener<T> getExceptionTranslationWrapper(String id, ActionListener<T> listener) {
        return ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> listener.onFailure(this.translateException(id, (Exception)e)));
    }

    private Exception translateException(String id, Exception e) {
        if (e instanceof ResourceNotFoundException || e instanceof OpenSearchSecurityException) {
            logger.debug(() -> new ParameterizedMessage("Translating exception received from operation on {}", (Object)id), (Throwable)e);
            return AsynchronousSearchExceptionUtils.buildResourceNotFoundException(id);
        }
        return e;
    }

    private void setPersistSearchFailure(boolean persistSearchFailure) {
        this.persistSearchFailure = persistSearchFailure;
    }
}

