/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class PartialFileInputStream
extends InputStream {
    private CountingInputStream in;
    private long size;

    protected PartialFileInputStream(File file, long position, long size) throws IOException {
        this.size = size;
        this.in = new CountingInputStream(new FileInputStream(file));
        this.fullySkip(position);
        this.in.resetCount();
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.in.read();
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        long readLength = this.getReadLength(len);
        if (readLength == 0L && len > 0) {
            return -1;
        }
        return this.in.read(b, off, (int)readLength);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(this.getReadLength(n));
    }

    @Override
    public int available() throws IOException {
        return (int)this.getReadLength(this.in.available());
    }

    private long getReadLength(long desiredLength) {
        return Math.min(this.getRestLength(), desiredLength);
    }

    private boolean isEOF() {
        return this.getRestLength() <= 0L;
    }

    private long getRestLength() {
        return this.size - this.in.getCount();
    }

    private void fullySkip(long position) throws IOException {
        long total;
        long cur;
        for (total = 0L; total < position && (cur = this.in.skip(position - total)) > 0L; total += cur) {
        }
        if (total < position) {
            throw new IOException("could not seek pos " + position);
        }
    }
}

