/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsStreamSigner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaTlsStreamSigner
implements TlsStreamSigner {
    private final Signature signer;
    private final OutputStream output;

    JcaTlsStreamSigner(Signature signature) {
        this.signer = signature;
        this.output = OutputStreamFactory.createStream((Signature)signature);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public byte[] getSignature() throws IOException {
        try {
            return this.signer.sign();
        }
        catch (SignatureException signatureException) {
            throw new TlsFatalAlert(80, (Throwable)signatureException);
        }
    }
}

