/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.data.TrackExtents;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapTileManager;
import tim.prune.gui.map.TileConsumer;
import tim.prune.save.GroutedImage;

public class MapGrouter
implements TileConsumer {
    private GroutedImage _lastGroutedImage = null;

    public void clearMapImage() {
        this._lastGroutedImage = null;
    }

    public GroutedImage createMapImage(Track track, MapSource mapSource, int n) {
        return this.createMapImage(track, mapSource, n, false);
    }

    public GroutedImage createMapImage(Track track, MapSource mapSource, int n, boolean bl) {
        TrackExtents trackExtents = new TrackExtents(track);
        trackExtents.applySquareBorder();
        DoubleRange doubleRange = trackExtents.getXRange();
        DoubleRange doubleRange2 = trackExtents.getYRange();
        int n2 = 1 << n;
        int n3 = (int)(doubleRange.getMinimum() * (double)n2);
        int n4 = (int)(doubleRange.getMaximum() * (double)n2);
        int n5 = (int)(doubleRange2.getMinimum() * (double)n2);
        int n6 = (int)(doubleRange2.getMaximum() * (double)n2);
        int n7 = (int)(trackExtents.getXRange().getRange() * (double)n2 * 256.0);
        if (n7 < 2 || n == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n7, n7, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n7, n7);
        int n8 = (int)(((double)n3 - doubleRange.getMinimum() * (double)n2) * 256.0);
        MapTileManager mapTileManager = new MapTileManager(this);
        mapTileManager.setMapSource(mapSource);
        mapTileManager.enableTileDownloading(bl);
        mapTileManager.setZoom(n);
        int n9 = 0;
        int n10 = 0;
        int n11 = n3;
        while (n11 <= n4) {
            int n12 = (int)(((double)n5 - doubleRange2.getMinimum() * (double)n2) * 256.0);
            int n13 = n5;
            while (n13 <= n6) {
                int n14 = 0;
                while (n14 < mapSource.getNumLayers()) {
                    Image image = mapTileManager.getTile(n14, n11, n13, true);
                    int n15 = 0;
                    while (image == null && bl && n15 < 3) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                        image = mapTileManager.getTile(n14, n11, n13, false);
                        ++n15;
                    }
                    if (image != null) {
                        while (image.getWidth(null) < 0 && !bl) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ++n9;
                        graphics.drawImage(image, n8, n12, null);
                    } else {
                        ++n10;
                    }
                    ++n14;
                }
                n12 += 256;
                ++n13;
            }
            n8 += 256;
            ++n11;
        }
        if (n9 == 0) {
            bufferedImage = null;
        }
        GroutedImage groutedImage = new GroutedImage(bufferedImage, n9, n10);
        groutedImage.setXRange(doubleRange);
        groutedImage.setYRange(doubleRange2);
        return groutedImage;
    }

    public synchronized GroutedImage getMapImage(Track track, MapSource mapSource, int n) {
        if (this._lastGroutedImage == null) {
            this._lastGroutedImage = this.createMapImage(track, mapSource, n);
        }
        return this._lastGroutedImage;
    }

    public static boolean isZoomLevelOk(Track track, int n) {
        TrackExtents trackExtents = new TrackExtents(track);
        trackExtents.applySquareBorder();
        int n2 = 1 << n;
        int n3 = (int)(trackExtents.getXRange().getRange() * (double)n2 * 256.0);
        return n3 > 2 && n3 < 4000;
    }

    @Override
    public void tilesUpdated(boolean bl) {
    }

    @Override
    public void reportCacheFailure() {
    }
}

