/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tim.prune.I18nManager;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.profile.AltitudeData;
import tim.prune.gui.profile.ArbitraryData;
import tim.prune.gui.profile.ChartScale;
import tim.prune.gui.profile.ProfileData;
import tim.prune.gui.profile.SpeedData;
import tim.prune.gui.profile.VerticalSpeedData;

public class ProfileChart
extends GenericDisplay {
    private double _xScaleFactor = 0.0;
    private ProfileData _data = null;
    private final JLabel _label;
    private JPopupMenu _popup = null;
    private ChartParameters _previousParameters = new ChartParameters();
    private final ChartScale _chartScale = new ChartScale();
    private static final int BORDER_WIDTH = 6;
    private static final Dimension MINIMUM_SIZE = new Dimension(200, 110);

    public ProfileChart(TrackInfo trackInfo) {
        super(trackInfo);
        this._data = new AltitudeData(trackInfo.getTrack());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProfileChart.this.processMouseClick(mouseEvent);
            }
        });
        this.setLayout(new FlowLayout(0));
        this._label = new JLabel("Altitude");
        this.add(this._label);
        this.makePopup();
    }

    @Override
    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        double d;
        super.paint(graphics);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Config.getConfigBoolean("prune.antialias") ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        ColourScheme colourScheme = Config.getColourScheme();
        this.paintBackground(graphics, colourScheme);
        if (this._track == null || this._track.getNumPoints() <= 0) {
            return;
        }
        this._label.setText(this._data.getLabel());
        this._label.setForeground(colourScheme.getColour(3));
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Color color = colourScheme.getColour(1);
        Color color2 = colourScheme.getColour(2);
        Color color3 = colourScheme.getColour(4);
        Color color4 = colourScheme.getColour(5);
        Color color5 = colourScheme.getColour(7);
        if (!this._data.hasData()) {
            graphics.setColor(color5);
            graphics.drawString(I18nManager.getText(this._data.getNoDataKey()), 50, (n3 + this._label.getHeight()) / 2);
            this.paintChildren(graphics);
            return;
        }
        double d2 = this._data.getMinValue();
        double d3 = this._data.getMaxValue();
        if (d3 - d2 < 2.0) {
            double d4 = (d2 + d3) / 2.0;
            d = Math.max(d3 - d2, 2.0);
            d2 = d4 - d / 2.0;
            d3 = d4 + d / 2.0;
        }
        int n4 = this._track.getNumPoints();
        this._xScaleFactor = 1.0 * (double)(n2 - 12 - 1) / (double)n4;
        int n5 = n3 - 12 - this._label.getHeight();
        d = 1.0 * (double)n5 / (d3 - d2);
        int n6 = (int)(this._xScaleFactor + 1.0);
        int n7 = this._trackInfo.getSelection().getCurrentPointIndex();
        int n8 = -1;
        int n9 = -1;
        if (this._trackInfo.getSelection().hasRangeSelected()) {
            n8 = this._trackInfo.getSelection().getStart();
            n9 = this._trackInfo.getSelection().getEnd();
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n10 = fontMetrics.getHeight();
        int n11 = Math.max(2, this.getHeight() / n10 / 4);
        int n12 = 0;
        int n13 = this._chartScale.getLineScale(d2, d3, n11);
        double d5 = Math.ceil(d2 / (double)n13) * (double)n13;
        int n14 = n3 - 6 - (int)(d * (0.0 - d2));
        graphics.setColor(color5);
        if (n13 >= 1) {
            while (d5 < d3) {
                n12 = n3 - 6 - (int)(d * (d5 - d2));
                graphics.drawLine(7, n12, n2 - 6 - 1, n12);
                d5 += (double)n13;
            }
        } else if (d2 < 0.0) {
            n12 = n14;
            graphics.drawLine(7, n12, n2 - 6 - 1, n12);
        }
        try {
            graphics.setColor(color);
            n = -1;
            int n15 = 0;
            while (n15 < n4) {
                if (n15 == n8) {
                    graphics.setColor(color2);
                } else if (n15 == n9 + 1) {
                    graphics.setColor(color);
                }
                int n16 = (int)(this._xScaleFactor * (double)n15) + 1;
                if (this._data.hasData(n15) && n16 != n) {
                    double d6 = this._data.getData(n15);
                    if (d2 >= 0.0) {
                        n12 = (int)(d * (d6 - d2));
                        graphics.fillRect(6 + n16, n3 - 6 - n12, n6, n12);
                    } else if (d6 >= 0.0) {
                        n12 = n3 - 6 - (int)(d * (d6 - d2));
                        graphics.fillRect(6 + n16, n12, n6, n14 - n12);
                    } else {
                        int n17 = (int)(d * d6);
                        graphics.fillRect(6 + n16, n14, n6, -n17);
                    }
                    n = n16;
                }
                ++n15;
            }
            if (n7 >= 0) {
                n15 = (int)(this._xScaleFactor * (double)n7) + 1;
                graphics.setColor(color4);
                graphics.fillRect(6 + n15, n3 - n5 - 6 + 1, n6, n5 - 2);
                if (this._data.hasData(n7)) {
                    graphics.setColor(color3);
                    double d7 = this._data.getData(n7);
                    n12 = (int)(d * (d7 - d2));
                    graphics.fillRect(6 + n15, n3 - 6 - n12, n6, n12);
                }
            }
        }
        catch (NullPointerException nullPointerException) {}
        if (n13 >= 1) {
            n = graphics.getFontMetrics().getHeight();
            d5 = (int)(d2 / (double)n13 + 1.0) * n13;
            if (d2 < 0.0) {
                d5 -= (double)n13;
            }
            graphics.setColor(color3);
            while (d5 < d3) {
                n12 = n3 - 6 - (int)(d * (d5 - d2));
                if (n12 < 6 + n) {
                    n12 = 6 + n;
                }
                graphics.drawString("" + (int)d5, 11, n12);
                d5 += (double)n13;
            }
        }
        this.paintChildren(graphics);
    }

    private void paintBackground(Graphics graphics, ColourScheme colourScheme) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = colourScheme.getColour(6);
        Color color2 = colourScheme.getColour(0);
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n, n2);
        if (n < 12 || n2 < 12) {
            return;
        }
        if (this._track == null || this._track.getNumPoints() <= 0) {
            graphics.setColor(colourScheme.getColour(3));
            graphics.drawString(I18nManager.getText("display.nodata"), 50, n2 / 2);
        } else {
            graphics.setColor(color);
            graphics.drawRect(6, 6 + this._label.getHeight(), n - 12, n2 - 12 - this._label.getHeight());
        }
    }

    private synchronized void makePopup() {
        if (this._track.getNumPoints() < 1) {
            this._popup = null;
            return;
        }
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("fieldname.altitude"));
        jMenuItem.addActionListener(actionEvent -> this.changeView(Field.ALTITUDE));
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("fieldname.speed"));
        jMenuItem2.addActionListener(actionEvent -> this.changeView(Field.SPEED));
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("fieldname.verticalspeed"));
        jMenuItem3.addActionListener(actionEvent -> this.changeView(Field.VERTICAL_SPEED));
        this._popup.add(jMenuItem3);
        boolean bl = true;
        FieldList fieldList = this._track.getFieldList();
        int n = 0;
        while (n < fieldList.getNumFields()) {
            Field field = fieldList.getField(n);
            if (!field.isBuiltIn()) {
                if (bl) {
                    this._popup.addSeparator();
                }
                bl = false;
                JMenuItem jMenuItem4 = new JMenuItem(field.getName());
                jMenuItem4.addActionListener(new MenuClicker(field));
                this._popup.add(jMenuItem4);
            }
            ++n;
        }
    }

    @Override
    public void dataUpdated(int n) {
        if (n == 4 && !this._data._hasData) {
            return;
        }
        if (n != 4) {
            this._data.init(Config.getUnitSet());
            this._previousParameters.clear();
        }
        if ((n & 1) > 0) {
            this.makePopup();
        }
        ChartParameters chartParameters = new ChartParameters();
        chartParameters.selectedPoint.set(this._trackInfo.getSelection().getCurrentPointIndex());
        if (this._trackInfo.getSelection().hasRangeSelected()) {
            chartParameters.rangeStart.set(this._trackInfo.getSelection().getStart());
            chartParameters.rangeEnd.set(this._trackInfo.getSelection().getEnd());
        }
        if (n == 4 && this._trackInfo.getTrack().getNumPoints() > 20) {
            this.triggerPartialRepaint(chartParameters);
        } else {
            this.repaint();
        }
        this._previousParameters = chartParameters;
    }

    private void triggerPartialRepaint(ChartParameters chartParameters) {
        int n = chartParameters.getMinChangedIndex(this._previousParameters);
        n = Math.max(n, 0);
        int n2 = chartParameters.getMaxChangedIndex(this._previousParameters);
        if (n2 < n) {
            n2 = this._trackInfo.getTrack().getNumPoints() - 1;
        }
        int n3 = (int)(this._xScaleFactor * (double)n) + 6 - 2;
        int n4 = (int)(this._xScaleFactor * (double)(n2 - n + 2)) + 6;
        this.repaint(n3, 0, n4, this.getHeight());
    }

    private void processMouseClick(MouseEvent mouseEvent) {
        if (this._track == null || this._track.getNumPoints() < 1) {
            return;
        }
        if (!mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 6 && n2 > 6 && n < this.getWidth() - 6 && n2 < this.getHeight() - 6) {
                int n3 = (int)((double)(mouseEvent.getX() - 6) / this._xScaleFactor);
                if (mouseEvent.isShiftDown()) {
                    this._trackInfo.extendSelection(n3);
                } else {
                    this._trackInfo.selectPoint(n3);
                }
            }
        } else if (this._popup != null) {
            this._popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void changeView(Field field) {
        if (field == Field.ALTITUDE) {
            if (!(this._data instanceof AltitudeData)) {
                this._data = new AltitudeData(this._track);
            }
        } else if (field == Field.SPEED) {
            if (!(this._data instanceof SpeedData)) {
                this._data = new SpeedData(this._track);
            }
        } else if (field == Field.VERTICAL_SPEED) {
            if (!(this._data instanceof VerticalSpeedData)) {
                this._data = new VerticalSpeedData(this._track);
            }
        } else if (!(this._data instanceof ArbitraryData) || ((ArbitraryData)this._data).getField() != field) {
            this._data = new ArbitraryData(this._track, field);
        }
        this._data.init(Config.getUnitSet());
        this.repaint();
    }

    private static class ChartParameters {
        public PointIndex selectedPoint = new PointIndex();
        public PointIndex rangeStart = new PointIndex();
        public PointIndex rangeEnd = new PointIndex();

        private ChartParameters() {
        }

        public void clear() {
            this.selectedPoint.hasValue = false;
            this.rangeStart.hasValue = false;
            this.rangeEnd.hasValue = false;
        }

        public int getMinChangedIndex(ChartParameters chartParameters) {
            PointIndex pointIndex = new PointIndex();
            if (!this.selectedPoint.equals(chartParameters.selectedPoint)) {
                pointIndex.setMin(this.selectedPoint);
                pointIndex.setMin(chartParameters.selectedPoint);
            }
            if (!this.rangeStart.equals(chartParameters.rangeStart)) {
                pointIndex.setMin(this.rangeStart);
                pointIndex.setMin(chartParameters.rangeStart);
            }
            if (!this.rangeEnd.equals(chartParameters.rangeEnd)) {
                pointIndex.setMin(this.rangeEnd);
                pointIndex.setMin(chartParameters.rangeEnd);
            }
            return pointIndex.index;
        }

        public int getMaxChangedIndex(ChartParameters chartParameters) {
            PointIndex pointIndex = new PointIndex();
            if (!this.selectedPoint.equals(chartParameters.selectedPoint)) {
                pointIndex.setMax(this.selectedPoint);
                pointIndex.setMax(chartParameters.selectedPoint);
            }
            if (!this.rangeStart.equals(chartParameters.rangeStart)) {
                pointIndex.setMax(this.rangeStart);
                pointIndex.setMax(chartParameters.rangeStart);
            }
            if (!this.rangeEnd.equals(chartParameters.rangeEnd)) {
                pointIndex.setMax(this.rangeEnd);
                pointIndex.setMax(chartParameters.rangeEnd);
            }
            return pointIndex.index;
        }
    }

    class MenuClicker
    implements ActionListener {
        private final Field _field;

        MenuClicker(Field field) {
            this._field = field;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProfileChart.this.changeView(this._field);
        }
    }

    static class PointIndex {
        public int index = -1;
        public boolean hasValue = false;

        PointIndex() {
        }

        public void set(int n) {
            this.index = n;
            this.hasValue = n != -1;
        }

        public void setMin(PointIndex pointIndex) {
            if (!pointIndex.hasValue) {
                return;
            }
            if (!this.hasValue) {
                this.index = pointIndex.index;
                this.hasValue = true;
            } else {
                this.index = Math.min(this.index, pointIndex.index);
            }
        }

        public void setMax(PointIndex pointIndex) {
            if (!pointIndex.hasValue) {
                return;
            }
            if (!this.hasValue) {
                this.index = pointIndex.index;
                this.hasValue = true;
            } else {
                this.index = Math.max(this.index, pointIndex.index);
            }
        }

        public boolean equals(PointIndex pointIndex) {
            if (!this.hasValue || !pointIndex.hasValue) {
                return this.hasValue == pointIndex.hasValue;
            }
            return this.index == pointIndex.index;
        }
    }
}

