/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.weather;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.function.weather.SingleForecast;

public class OWMForecastHandler
extends DefaultHandler {
    private String _value = null;
    private String _locName = null;
    private String _updateTime = null;
    private SingleForecast _forecast = null;
    private ArrayList<SingleForecast> _forecastList = new ArrayList();

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("time")) {
            this._forecast = new SingleForecast();
            this._forecast.setTime(attributes.getValue("day"), attributes.getValue("from"), attributes.getValue("to"));
        } else if (string3.equals("symbol")) {
            this._forecast.setSymbol(attributes.getValue("number"), attributes.getValue("var"), attributes.getValue("name"));
        } else if (string3.equals("windSpeed")) {
            this._forecast.setWindDesc(attributes.getValue("name"));
        } else if (string3.equals("temperature")) {
            this._forecast.setTemps(attributes.getValue("min"), attributes.getValue("max"));
        } else if (string3.equals("humidity")) {
            this._forecast.setHumidity(String.valueOf(attributes.getValue("value")) + attributes.getValue("unit"));
        }
        this._value = null;
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("name")) {
            this._locName = this._value;
        } else if (string3.equals("lastupdate")) {
            this._updateTime = this._value;
        } else if (string3.equals("time")) {
            this._forecastList.add(this._forecast);
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this._value = this._value == null ? string : String.valueOf(this._value) + string;
        super.characters(cArray, n, n2);
    }

    public String getLocationName() {
        return this._locName;
    }

    public String getUpdateTime() {
        return this._updateTime;
    }

    public ArrayList<SingleForecast> getForecasts() {
        return this._forecastList;
    }
}

