/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.cmd.RemovePhotoCmd;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class InsertPhotoCmd
extends Command {
    private final Photo _photo;
    private final int _photoIndex;

    public InsertPhotoCmd(Photo photo) {
        this(null, photo, -1);
    }

    InsertPhotoCmd(Command command, Photo photo, int n) {
        super(command);
        this._photo = photo;
        this._photoIndex = n;
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._photo == null) {
            return false;
        }
        if (this._photoIndex < 0) {
            trackInfo.getPhotoList().add(this._photo);
        } else {
            trackInfo.getPhotoList().add(this._photo, this._photoIndex);
        }
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        int n = this._photoIndex < 0 ? trackInfo.getPhotoList().getCount() : this._photoIndex;
        return new RemovePhotoCmd(this, n);
    }
}

