/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.event;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.model.EventSeverity;
import org.apache.fop.fo.FOValidationEventProducer;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;

public class FOPEventListenerProxy
implements EventListener {
    private static final String FOVALIDATION_EVENT_ID_PREFIX = FOValidationEventProducer.class.getName();
    private static final String BLOCK_LEVEL_EVENT_ID_PREFIX = BlockLevelEventProducer.class.getName();
    private EventListener delegate;
    private FOUserAgent userAgent;

    public FOPEventListenerProxy(EventListener delegate, FOUserAgent userAgent) {
        this.delegate = delegate;
        this.userAgent = userAgent;
    }

    @Override
    public synchronized void processEvent(Event event) {
        Boolean canRecover;
        if (event.getEventID().startsWith(FOVALIDATION_EVENT_ID_PREFIX)) {
            Boolean canRecover2 = (Boolean)event.getParam("canRecover");
            if (Boolean.TRUE.equals(canRecover2) && !this.userAgent.validateStrictly()) {
                event.setSeverity(EventSeverity.WARN);
            }
        } else if (event.getEventID().startsWith(BLOCK_LEVEL_EVENT_ID_PREFIX) && Boolean.TRUE.equals(canRecover = (Boolean)event.getParam("canRecover"))) {
            event.setSeverity(EventSeverity.WARN);
        }
        this.delegate.processEvent(event);
    }
}

