// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief Cross-sections for light hadrons at 3.773, 3.650 GeV
  class BESII_2007_I750713 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESII_2007_I750713);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      declare(UnstableParticles(), "UFS");

      // Book histograms
      for (unsigned int ix=1;ix<19;++ix) {
        stringstream ss;
        ss << "TMP/n" << ix;
        book(_nMeson[ix], ss.str());
      }

    }


    void findChildren(const Particle & p,map<long,int> & nRes, int &ncount) {
      for (const Particle &child : p.children()) {
        if(child.children().empty()) {
          nRes[child.pid()]-=1;
          --ncount;
        }
        else
          findChildren(child,nRes,ncount);
      }
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      const FinalState& ufs = apply<FinalState>(event, "UFS");

      for (const Particle& p : ufs.particles()) {
        if(p.children().empty()) continue;
        if(p.pid()!=221 && p.pid()!=333) continue;
        map<long,int> nRes = nCount;
        int ncount = ntotal;
        findChildren(p,nRes,ncount);
        // eta
        if(p.pid()==221) {
          if(ncount==4) {
            bool matched = true;
            for(auto const & val : nRes) {
              if(abs(val.first)==211) {
                if(val.second!=2) {
                  matched = false;
                  break;
                }
              }
              else if(val.second!=0) {
                matched = false;
                break;
              }
            }
            if(matched) _nMeson[12]->fill();
          }
        }
        else if(p.pid()==333) {
          if(ncount!=1) continue;
          bool matched = true;
          for(auto const & val : nRes) {
            if(abs(val.first)==321) {
              if(val.second!=1) {
                matched = false;
                break;
              }
            }
            else if(val.second!=0) {
              matched = false;
              break;
            }
          }
          if(matched)
            _nMeson[7]->fill();
        }
      }
      if(ntotal==3 &&  nCount[111]==1 &&
         nCount[-2212] == 1 && nCount[ 2212]==1)
        _nMeson[16]->fill();
      else if(ntotal==4) {
        if(nCount[-211] == 2 && nCount[ 211]==2)
          _nMeson[3]->fill();
        else if(nCount[-211] == 1 && nCount[ 211]==1 &&
                nCount[-321] == 1 && nCount[ 321]==1)
          _nMeson[4]->fill();
        else if(nCount[-321] == 2 && nCount[ 321]==2)
          _nMeson[6]->fill();
        else if(nCount[-211 ] == 1 && nCount[ 211 ]==1 &&
                nCount[-2212] == 1 && nCount[ 2212]==1)
          _nMeson[8]->fill();
        else if(nCount[-321 ] == 1 && nCount[ 321 ]==1 &&
                nCount[-2212] == 1 && nCount[ 2212]==1)
          _nMeson[9]->fill();
      }
      else if(ntotal==5 && nCount[111]==1) {
        if(nCount[-211] == 2 && nCount[ 211]==2)
          _nMeson[13]->fill();
        else if(nCount[-211] == 1 && nCount[ 211]==1 &&
                nCount[-321] == 1 && nCount[ 321]==1)
          _nMeson[14]->fill();
        else if(nCount[-321] == 2 && nCount[ 321]==2)
          _nMeson[15]->fill();
        else if(nCount[-211 ] == 1 && nCount[ 211 ]==1 &&
                nCount[-2212] == 1 && nCount[ 2212]==1)
          _nMeson[17]->fill();
      }
      else if(ntotal==6 && nCount[211]==3 && nCount[-211]==3)
        _nMeson[11]->fill();
      else if(ntotal==7 && nCount[111]==1 &&
              nCount[211]==3 && nCount[-211]==3)
        _nMeson[18]->fill();
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nMeson, crossSection()/ sumOfWeights() /picobarn);
      for (unsigned int ix=3; ix<19; ++ix) {
        if (ix==5 || ix==10) continue;
        BinnedEstimatePtr<string>  mult;
        book(mult, 1, 1, ix);
        for (auto& b : mult->bins()) {
          if (isCompatibleWithSqrtS(std::stod(b.xEdge()))) {
            b.set(_nMeson[ix]->val(), _nMeson[ix]->err());
          }
        }
      }
    }
    /// @}


    /// @name Histograms
    /// @{
    CounterPtr _nMeson[19];
    /// @}

  };


  RIVET_DECLARE_PLUGIN(BESII_2007_I750713);

}
