'use strict';

const node_worker_threads = require('node:worker_threads');
const debugWrap = require('debug');
const utils = require('./shared/vite-plugin-eslint2.Bjwy7Cmq.cjs');
require('@rollup/pluginutils');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e.default : e; }

const debugWrap__default = /*#__PURE__*/_interopDefaultCompat(debugWrap);

const debug = debugWrap__default(`${utils.PLUGIN_NAME}:worker`);
const options = node_worker_threads.workerData.options;
const filter = utils.getFilter(options);
let eslintInstance;
let formatter;
let outputFixes;
const initPromise = utils.initializeESLint(options).then((result) => {
  eslintInstance = result.eslintInstance;
  formatter = result.formatter;
  outputFixes = result.outputFixes;
  return result;
});
(async () => {
  debug("==== worker start ====");
  debug("Initialize ESLint");
  const { eslintInstance: eslintInstance2, formatter: formatter2, outputFixes: outputFixes2 } = await initPromise;
  if (options.lintOnStart) {
    debug("Lint on start");
    utils.lintFiles({
      files: options.include,
      eslintInstance: eslintInstance2,
      formatter: formatter2,
      outputFixes: outputFixes2,
      options
    });
  }
})();
node_worker_threads.parentPort?.on("message", async (id) => {
  if (!eslintInstance) await initPromise;
  debug("==== worker message event ====");
  debug(`id: ${id}`);
  const shouldIgnore = await utils.shouldIgnoreModule(id, filter, eslintInstance);
  debug(`should ignore: ${shouldIgnore}`);
  if (shouldIgnore) return;
  const filePath = utils.getFilePath(id);
  debug(`filePath: ${filePath}`);
  utils.lintFiles({
    files: options.lintDirtyOnly ? filePath : options.include,
    eslintInstance,
    formatter,
    outputFixes,
    options
  });
});
