import React, { type ReactNode } from 'react';
import type { DroppableRegistry } from './droppable-registry';
import type { DragState, StartKeyboardDrag } from './types';
type DragDropContextValue = {
    /**
     * A stringified number used to uniquely identify each context instance.
     * This allows each <DragDropContext /> to be isolated from each other.
     *
     * This is the approach originally used by `react-beautiful-dnd`.
     */
    contextId: string;
    /**
     * Lazily returns the current drag state.
     */
    getDragState(): DragState;
    startKeyboardDrag: StartKeyboardDrag;
    droppableRegistry: DroppableRegistry;
};
export declare function useDragDropContext(): DragDropContextValue;
export declare function DragDropContextProvider({ children, contextId, getDragState, startKeyboardDrag, droppableRegistry, }: {
    children: ReactNode;
    contextId: string;
    getDragState(): DragState;
    startKeyboardDrag: StartKeyboardDrag;
    droppableRegistry: DroppableRegistry;
}): React.JSX.Element;
export {};
