#![deny(missing_docs)]
//! `rattler-conda-types` contains data models for types commonly found within
//! the Conda ecosystem. The library itself doesnt provide any functionality
//! besides parsing the data types.

pub mod backup;
mod build_spec;
mod channel;
mod channel_data;
mod explicit_environment_spec;
pub mod match_spec;
pub mod menuinst;
mod no_arch_type;
mod parse_mode;
pub mod platform;
mod repo_data;
mod repo_data_record;
mod run_export;
pub mod utils;
mod version;
pub mod version_spec;

pub mod compression_level;
mod environment_yaml;
mod generic_virtual_package;
pub mod minimal_prefix_record;
pub mod package;
mod package_name;
pub mod prefix;
pub mod prefix_record;
mod record_traits;

#[cfg(test)]
use std::path::{Path, PathBuf};

pub use build_spec::{BuildNumber, BuildNumberSpec, OrdOperator, ParseBuildNumberSpecError};
pub use channel::{Channel, ChannelConfig, ChannelUrl, NamedChannelOrUrl, ParseChannelError};
pub use channel_data::{ChannelData, ChannelDataPackage};
pub use environment_yaml::{EnvironmentYaml, MatchSpecOrSubSection};
pub use explicit_environment_spec::{
    ExplicitEnvironmentEntry, ExplicitEnvironmentSpec, PackageArchiveHash,
    ParseExplicitEnvironmentSpecError, ParsePackageArchiveHashError,
};
pub use generic_virtual_package::GenericVirtualPackage;
pub use match_spec::condition::MatchSpecCondition;
pub use match_spec::package_name_matcher::{PackageNameMatcher, PackageNameMatcherParseError};
pub use match_spec::{
    matcher::{StringMatcher, StringMatcherParseError},
    parse::ParseMatchSpecError,
    MatchSpec, MatchSpecUrlError, Matches, NamelessMatchSpec,
};
pub use minimal_prefix_record::{
    collect_minimal_prefix_records, MinimalPrefixCollection, MinimalPrefixRecord,
};
pub use no_arch_type::{NoArchKind, NoArchType, RawNoArchType};
pub use package_name::{InvalidPackageNameError, PackageName};
pub use parse_mode::{ParseMatchSpecOptions, ParseStrictness, ParseStrictnessWithNameMatcher};
pub use platform::{Arch, ParseArchError, ParsePlatformError, Platform};
pub use prefix_record::PrefixRecord;
pub use record_traits::HasArtifactIdentificationRefs;
pub use repo_data::{
    compute_package_url,
    patches::{PackageRecordPatch, PatchInstructions, RepoDataPatch},
    sharded::{Shard, ShardedRepodata, ShardedSubdirInfo},
    ChannelInfo, ConvertSubdirError, PackageRecord, RecordFromPath, RepoData, SubdirRunExportsJson,
    UrlOrPath, ValidatePackageRecordsError, WhlPackageRecord,
};
pub use repo_data_record::{RepoDataRecord, SolverResult};
pub use run_export::RunExportKind;
pub use version::{
    Component, ParseVersionError, ParseVersionErrorKind, StrictVersion, Version, VersionBumpError,
    VersionBumpType, VersionExtendError, VersionWithSource,
};
pub use version_spec::VersionSpec;

/// An package identifier that can be used to identify packages across package
/// ecosystems.
pub type PackageUrl = purl::GenericPurl<String>;

#[cfg(test)]
pub(crate) fn get_test_data_dir() -> PathBuf {
    Path::new(env!("CARGO_MANIFEST_DIR")).join("../../test-data")
}
