/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/kubernetes-csi/external-snapshotter/client/v4/apis/volumesnapshot/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/externalsnapshotter/scheme"
)

// VolumeSnapshotClassesGetter has a method to return a VolumeSnapshotClassInterface.
// A group's client should implement this interface.
type VolumeSnapshotClassesGetter interface {
	VolumeSnapshotClasses() VolumeSnapshotClassInterface
}

// VolumeSnapshotClassInterface has methods to work with VolumeSnapshotClass resources.
type VolumeSnapshotClassInterface interface {
	Create(ctx context.Context, volumeSnapshotClass *v1.VolumeSnapshotClass, opts metav1.CreateOptions) (*v1.VolumeSnapshotClass, error)
	Update(ctx context.Context, volumeSnapshotClass *v1.VolumeSnapshotClass, opts metav1.UpdateOptions) (*v1.VolumeSnapshotClass, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.VolumeSnapshotClass, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.VolumeSnapshotClassList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VolumeSnapshotClass, err error)
	VolumeSnapshotClassExpansion
}

// volumeSnapshotClasses implements VolumeSnapshotClassInterface
type volumeSnapshotClasses struct {
	*gentype.ClientWithList[*v1.VolumeSnapshotClass, *v1.VolumeSnapshotClassList]
}

// newVolumeSnapshotClasses returns a VolumeSnapshotClasses
func newVolumeSnapshotClasses(c *SnapshotV1Client) *volumeSnapshotClasses {
	return &volumeSnapshotClasses{
		gentype.NewClientWithList[*v1.VolumeSnapshotClass, *v1.VolumeSnapshotClassList](
			"volumesnapshotclasses",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1.VolumeSnapshotClass { return &v1.VolumeSnapshotClass{} },
			func() *v1.VolumeSnapshotClassList { return &v1.VolumeSnapshotClassList{} }),
	}
}
