/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ml extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "നൗറു";
        final String metaValue_TV = "ടുവാലു";
        final String metaValue_ar = "അറബിക്";
        final String metaValue_hy = "അർമേനിയൻ";
        final String metaValue_ban = "ബാലിനീസ്";
        final String metaValue_bug = "ബുഗിനീസ്";
        final String metaValue_cop = "കോപ്റ്റിക്";
        final String metaValue_el = "ഗ്രീക്ക്";
        final String metaValue_gu = "ഗുജറാത്തി";
        final String metaValue_he = "ഹീബ്രു";
        final String metaValue_jv = "ജാവനീസ്";
        final String metaValue_ja = "ജാപ്പനീസ്";
        final String metaValue_km = "ഖമെർ";
        final String metaValue_kn = "കന്നഡ";
        final String metaValue_ko = "കൊറിയൻ";
        final String metaValue_lo = "ലാവോ";
        final String metaValue_la = "ലാറ്റിൻ";
        final String metaValue_ml = "മലയാളം";
        final String metaValue_mn = "മംഗോളിയൻ";
        final String metaValue_or = "ഒഡിയ";
        final String metaValue_si = "സിംഹള";
        final String metaValue_ta = "തമിഴ്";
        final String metaValue_te = "തെലുങ്ക്";
        final String metaValue_th = "തായ്";
        final String metaValue_bo = "ടിബറ്റൻ";
        final String metaValue_vai = "വൈ";
        final String metaValue_peo = "പഴയ പേർഷ്യൻ";
        final String metaValue_type_nu_mathdbl = "ഗണിത ഏകസ്‌പെയ്‌സ് അക്കങ്ങൾ";
        final Object[][] data = new Object[][] {
            { "001", "ലോകം" },
            { "002", "ആഫ്രിക്ക" },
            { "003", "വടക്കേ അമേരിക്ക" },
            { "005", "തെക്കേ അമേരിക്ക" },
            { "009", "ഓഷ്യാനിയ" },
            { "011", "പശ്ചിമ ആഫ്രിക്ക" },
            { "013", "മദ്ധ്യ അമേരിക്ക" },
            { "014", "കിഴക്കൻ ആഫ്രിക്ക" },
            { "015", "ഉത്തരാഫ്രിക്ക" },
            { "017", "മദ്ധ്യ ആഫ്രിക്ക" },
            { "018", "തെക്കേ ആഫ്രിക്ക" },
            { "019", "അമേരിക്കകൾ" },
            { "021", "വടക്കൻ അമേരിക്ക" },
            { "029", "കരീബിയൻ" },
            { "030", "കിഴക്കൻ ഏഷ്യ" },
            { "034", "തെക്കേ ഏഷ്യ" },
            { "035", "തെക്ക്-കിഴക്കൻ ഏഷ്യ" },
            { "039", "തെക്കേ യൂറോപ്പ്" },
            { "053", "ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും" },
            { "054", "മെലനേഷ്യ" },
            { "057", "മൈക്രോനേഷ്യൻ പ്രദേശം" },
            { "061", "പോളിനേഷ്യ" },
            { "142", "ഏഷ്യ" },
            { "143", "മദ്ധ്യേഷ്യ" },
            { "145", "പശ്ചിമേഷ്യ" },
            { "150", "യൂറോപ്പ്" },
            { "151", "കിഴക്കൻ യൂറോപ്പ്" },
            { "154", "വടക്കേ യൂറോപ്പ്" },
            { "155", "പശ്ചിമ യൂറോപ്പ്" },
            { "202", "സബ്-സഹാറൻ ആഫ്രിക്ക" },
            { "419", "ലാറ്റിനമേരിക്ക" },
            { "AC", "അസൻഷൻ ദ്വീപ്" },
            { "AD", "അൻഡോറ" },
            { "AE", "യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്" },
            { "AF", "അഫ്‌ഗാനിസ്ഥാൻ" },
            { "AG", "ആൻറിഗ്വയും ബർബുഡയും" },
            { "AI", "ആൻഗ്വില്ല" },
            { "AL", "അൽബേനിയ" },
            { "AM", "അർമേനിയ" },
            { "AO", "അംഗോള" },
            { "AQ", "അന്റാർട്ടിക്ക" },
            { "AR", "അർജന്റീന" },
            { "AS", "അമേരിക്കൻ സമോവ" },
            { "AT", "ഓസ്ട്രിയ" },
            { "AU", "ഓസ്‌ട്രേലിയ" },
            { "AW", "അറൂബ" },
            { "AX", "അലൻഡ് ദ്വീപുകൾ" },
            { "AZ", "അസർബൈജാൻ" },
            { "BA", "ബോസ്നിയയും ഹെർസഗോവിനയും" },
            { "BB", "ബാർബഡോസ്" },
            { "BD", "ബംഗ്ലാദേശ്" },
            { "BE", "ബെൽജിയം" },
            { "BF", "ബർക്കിന ഫാസോ" },
            { "BG", "ബൾഗേറിയ" },
            { "BH", "ബഹ്റിൻ" },
            { "BI", "ബറുണ്ടി" },
            { "BJ", "ബെനിൻ" },
            { "BL", "സെന്റ് ബാർത്തലമി" },
            { "BM", "ബർമുഡ" },
            { "BN", "ബ്രൂണൈ" },
            { "BO", "ബൊളീവിയ" },
            { "BQ", "കരീബിയൻ നെതർലാൻഡ്സ്" },
            { "BR", "ബ്രസീൽ" },
            { "BS", "ബഹാമാസ്" },
            { "BT", "ഭൂട്ടാൻ" },
            { "BV", "ബൗവെട്ട് ദ്വീപ്" },
            { "BW", "ബോട്സ്വാന" },
            { "BY", "ബെലറൂസ്" },
            { "BZ", "ബെലീസ്" },
            { "CA", "കാനഡ" },
            { "CC", "കോക്കസ് (കീലിംഗ്) ദ്വീപുകൾ" },
            { "CD", "കോംഗോ - കിൻഷാസ" },
            { "CF", "സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്ക്" },
            { "CG", "കോംഗോ - ബ്രാസവില്ലി" },
            { "CH", "സ്വിറ്റ്സർലാൻഡ്" },
            { "CI", "കോട്ട് ഡി വാർ" },
            { "CK", "കുക്ക് ദ്വീപുകൾ" },
            { "CL", "ചിലി" },
            { "CM", "കാമറൂൺ" },
            { "CN", "ചൈന" },
            { "CO", "കൊളംബിയ" },
            { "CP", "ക്ലിപ്പെർട്ടൻ ദ്വീപ്" },
            { "CR", "കോസ്റ്ററിക്ക" },
            { "CU", "ക്യൂബ" },
            { "CV", "കേപ്പ് വേർഡ്" },
            { "CW", "കുറാകാവോ" },
            { "CX", "ക്രിസ്മസ് ദ്വീപ്" },
            { "CY", "സൈപ്രസ്" },
            { "CZ", "ചെക്കിയ" },
            { "DE", "ജർമ്മനി" },
            { "DG", "ഡീഗോ ഗ്രാഷ്യ" },
            { "DJ", "ജിബൂത്തി" },
            { "DK", "ഡെൻമാർക്ക്" },
            { "DM", "ഡൊമിനിക്ക" },
            { "DO", "ഡൊമിനിക്കൻ റിപ്പബ്ലിക്ക്" },
            { "DZ", "അൾജീരിയ" },
            { "EA", "സെയൂത്ത ആൻഡ് മെലിയ" },
            { "EC", "ഇക്വഡോർ" },
            { "EE", "എസ്റ്റോണിയ‍" },
            { "EG", "ഈജിപ്ത്" },
            { "EH", "പശ്ചിമ സഹാറ" },
            { "ER", "എറിത്രിയ" },
            { "ES", "സ്‌പെയിൻ" },
            { "ET", "എത്യോപ്യ" },
            { "EU", "യൂറോപ്യൻ യൂണിയൻ" },
            { "EZ", "യൂറോസോൺ" },
            { "FI", "ഫിൻലാൻഡ്" },
            { "FJ", "ഫിജി" },
            { "FK", "ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ" },
            { "FM", "മൈക്രോനേഷ്യ" },
            { "FO", "ഫറോ ദ്വീപുകൾ" },
            { "FR", "ഫ്രാൻസ്" },
            { "GA", "ഗാബൺ" },
            { "GB", "യുണൈറ്റഡ് കിംഗ്ഡം" },
            { "GD", "ഗ്രനേഡ" },
            { "GE", "ജോർജ്ജിയ" },
            { "GF", "ഫ്രഞ്ച് ഗയാന" },
            { "GG", "ഗേൺസി" },
            { "GH", "ഘാന" },
            { "GI", "ജിബ്രാൾട്ടർ" },
            { "GL", "ഗ്രീൻലൻഡ്" },
            { "GM", "ഗാംബിയ" },
            { "GN", "ഗിനിയ" },
            { "GP", "ഗ്വാഡലൂപ്പ്" },
            { "GQ", "ഇക്വറ്റോറിയൽ ഗിനിയ" },
            { "GR", "ഗ്രീസ്" },
            { "GS", "ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും" },
            { "GT", "ഗ്വാട്ടിമാല" },
            { "GU", "ഗ്വാം" },
            { "GW", "ഗിനിയ-ബിസൗ" },
            { "GY", "ഗയാന" },
            { "HK", "ഹോങ്കോങ് (SAR) ചൈന" },
            { "HM", "ഹേർഡ്, മക്ഡോണൾഡ് ദ്വീപുകൾ" },
            { "HN", "ഹോണ്ടുറാസ്" },
            { "HR", "ക്രൊയേഷ്യ" },
            { "HT", "ഹെയ്തി" },
            { "HU", "ഹംഗറി" },
            { "IC", "കാനറി ദ്വീപുകൾ" },
            { "ID", "ഇന്തോനേഷ്യ" },
            { "IE", "അയർലൻഡ്" },
            { "IL", "ഇസ്രായേൽ" },
            { "IM", "ഐൽ ഓഫ് മാൻ" },
            { "IN", "ഇന്ത്യ" },
            { "IO", "ബ്രിട്ടീഷ് ഇന്ത്യൻ ഓഷ്യൻ ടെറിട്ടറി" },
            { "IQ", "ഇറാഖ്" },
            { "IR", "ഇറാൻ" },
            { "IS", "ഐസ്‌ലാന്റ്" },
            { "IT", "ഇറ്റലി" },
            { "JE", "ജേഴ്സി" },
            { "JM", "ജമൈക്ക" },
            { "JO", "ജോർദ്ദാൻ" },
            { "JP", "ജപ്പാൻ" },
            { "KE", "കെനിയ" },
            { "KG", "കിർഗിസ്ഥാൻ" },
            { "KH", "കംബോഡിയ" },
            { "KI", "കിരിബാട്ടി" },
            { "KM", "കോമൊറോസ്" },
            { "KN", "സെന്റ് കിറ്റ്‌സും നെവിസും" },
            { "KP", "ഉത്തരകൊറിയ" },
            { "KR", "ദക്ഷിണകൊറിയ" },
            { "KW", "കുവൈറ്റ്" },
            { "KY", "കേയ്മാൻ ദ്വീപുകൾ" },
            { "KZ", "കസാഖിസ്ഥാൻ" },
            { "LA", "ലാവോസ്" },
            { "LB", "ലെബനൻ" },
            { "LC", "സെന്റ് ലൂസിയ" },
            { "LI", "ലിച്ചൺസ്റ്റൈൻ" },
            { "LK", "ശ്രീലങ്ക" },
            { "LR", "ലൈബീരിയ" },
            { "LS", "ലെസോതോ" },
            { "LT", "ലിത്വാനിയ" },
            { "LU", "ലക്സംബർഗ്" },
            { "LV", "ലാറ്റ്വിയ" },
            { "LY", "ലിബിയ" },
            { "MA", "മൊറോക്കൊ" },
            { "MC", "മൊണാക്കോ" },
            { "MD", "മൾഡോവ" },
            { "ME", "മോണ്ടെനെഗ്രോ" },
            { "MF", "സെന്റ് മാർട്ടിൻ" },
            { "MG", "മഡഗാസ്കർ" },
            { "MH", "മാർഷൽ ദ്വീപുകൾ" },
            { "MK", "നോർത്ത് മാസിഡോണിയ" },
            { "ML", "മാലി" },
            { "MM", "മ്യാൻമാർ (ബർമ്മ)" },
            { "MN", "മംഗോളിയ" },
            { "MO", "മക്കാവു എസ്.എ.ആർ. ചൈന" },
            { "MP", "ഉത്തര മറിയാനാ ദ്വീപുകൾ" },
            { "MQ", "മാർട്ടിനിക്ക്" },
            { "MR", "മൗറിറ്റാനിയ" },
            { "MS", "മൊണ്ടെസരത്ത്" },
            { "MT", "മാൾട്ട" },
            { "MU", "മൗറീഷ്യസ്" },
            { "MV", "മാലിദ്വീപ്" },
            { "MW", "മലാവി" },
            { "MX", "മെക്സിക്കോ" },
            { "MY", "മലേഷ്യ" },
            { "MZ", "മൊസാംബിക്ക്" },
            { "NA", "നമീബിയ" },
            { "NC", "ന്യൂ കാലിഡോണിയ" },
            { "NE", "നൈജർ" },
            { "NF", "നോർഫോക് ദ്വീപ്" },
            { "NG", "നൈജീരിയ" },
            { "NI", "നിക്കരാഗ്വ" },
            { "NL", "നെതർലാൻഡ്‌സ്" },
            { "NO", "നോർവെ" },
            { "NP", "നേപ്പാൾ" },
            { "NR", metaValue_NR },
            { "NU", "ന്യൂയി" },
            { "NZ", "ന്യൂസിലൻഡ്" },
            { "OM", "ഒമാൻ" },
            { "PA", "പനാമ" },
            { "PE", "പെറു" },
            { "PF", "ഫ്രഞ്ച് പോളിനേഷ്യ" },
            { "PG", "പാപ്പുവ ന്യൂ ഗിനിയ" },
            { "PH", "ഫിലിപ്പീൻസ്" },
            { "PK", "പാക്കിസ്ഥാൻ" },
            { "PL", "പോളണ്ട്" },
            { "PM", "സെന്റ് പിയറി ആൻഡ് മിക്വലൻ" },
            { "PN", "പിറ്റ്‌കെയ്‌ൻ ദ്വീപുകൾ" },
            { "PR", "പോർട്ടോ റിക്കോ" },
            { "PS", "പാലസ്‌തീൻ പ്രദേശങ്ങൾ" },
            { "PT", "പോർച്ചുഗൽ" },
            { "PW", "പലാവു" },
            { "PY", "പരാഗ്വേ" },
            { "QA", "ഖത്തർ" },
            { "QO", "ദ്വീപസമൂഹം" },
            { "RE", "റീയൂണിയൻ" },
            { "RO", "റൊമാനിയ" },
            { "RS", "സെർബിയ" },
            { "RU", "റഷ്യ" },
            { "RW", "റുവാണ്ട" },
            { "SA", "സൗദി അറേബ്യ" },
            { "SB", "സോളമൻ ദ്വീപുകൾ" },
            { "SC", "സീഷെൽസ്" },
            { "SD", "സുഡാൻ" },
            { "SE", "സ്വീഡൻ" },
            { "SG", "സിംഗപ്പൂർ" },
            { "SH", "സെന്റ് ഹെലീന" },
            { "SI", "സ്ലോവേനിയ" },
            { "SJ", "സ്വാൽബാഡും ജാൻ മായേനും" },
            { "SK", "സ്ലോവാക്യ" },
            { "SL", "സിയെറ ലിയോൺ" },
            { "SM", "സാൻ മറിനോ" },
            { "SN", "സെനഗൽ" },
            { "SO", "സോമാലിയ" },
            { "SR", "സുരിനാം" },
            { "SS", "ദക്ഷിണ സുഡാൻ" },
            { "ST", "സാവോ ടോമും പ്രിൻസിപെയും" },
            { "SV", "എൽ സാൽവദോർ" },
            { "SX", "സിന്റ് മാർട്ടെൻ" },
            { "SY", "സിറിയ" },
            { "SZ", "സ്വാസിലൻഡ്" },
            { "TA", "ട്രിസ്റ്റൻ ഡ കൂന" },
            { "TC", "ടർക്ക്‌സും കെയ്‌ക്കോ ദ്വീപുകളും" },
            { "TD", "ഛാഡ്" },
            { "TF", "ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം" },
            { "TG", "ടോഗോ" },
            { "TH", "തായ്‌ലാൻഡ്" },
            { "TJ", "താജിക്കിസ്ഥാൻ" },
            { "TK", "ടോക്കെലൂ" },
            { "TL", "തിമോർ-ലെസ്റ്റെ" },
            { "TM", "തുർക്ക്മെനിസ്ഥാൻ" },
            { "TN", "ടുണീഷ്യ" },
            { "TO", "ടോംഗ" },
            { "TR", "തുർക്കിയെ" },
            { "TT", "ട്രിനിഡാഡും ടുബാഗോയും" },
            { "TV", metaValue_TV },
            { "TW", "തായ്‌വാൻ" },
            { "TZ", "ടാൻസാനിയ" },
            { "UA", "ഉക്രെയ്‌ൻ" },
            { "UG", "ഉഗാണ്ട" },
            { "UM", "യു.എസ്. ദ്വീപസമൂഹങ്ങൾ" },
            { "UN", "ഐക്യരാഷ്ട്രസഭ" },
            { "US", "അമേരിക്കൻ ഐക്യനാടുകൾ" },
            { "UY", "ഉറുഗ്വേ" },
            { "UZ", "ഉസ്‌ബെക്കിസ്ഥാൻ" },
            { "VA", "വത്തിക്കാൻ" },
            { "VC", "സെന്റ് വിൻസെന്റും ഗ്രനെഡൈൻസും" },
            { "VE", "വെനിസ്വേല" },
            { "VG", "ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ" },
            { "VI", "യു.എസ്. വെർജിൻ ദ്വീപുകൾ" },
            { "VN", "വിയറ്റ്നാം" },
            { "VU", "വന്വാതു" },
            { "WF", "വാലിസ് ആന്റ് ഫ്യൂച്യുന" },
            { "WS", "സമോവ" },
            { "XA", "കൃത്രിമ ഉച്ചാരണം" },
            { "XB", "സ്യൂഡോ-ബൈഡി" },
            { "XK", "കൊസോവൊ" },
            { "YE", "യെമൻ" },
            { "YT", "മയോട്ടി" },
            { "ZA", "ദക്ഷിണാഫ്രിക്ക" },
            { "ZM", "സാംബിയ" },
            { "ZW", "സിംബാബ്‌വേ" },
            { "ZZ", "അജ്ഞാത പ്രദേശം" },
            { "aa", "അഫാർ" },
            { "ab", "അബ്‌ഖാസിയൻ" },
            { "ae", "അവസ്റ്റാൻ" },
            { "af", "ആഫ്രിക്കാൻസ്" },
            { "ak", "അകാൻ‌" },
            { "am", "അംഹാരിക്" },
            { "an", "അരഗോണീസ്" },
            { "ar", metaValue_ar },
            { "as", "ആസ്സാമീസ്" },
            { "av", "അവാരിക്" },
            { "ay", "അയ്മാറ" },
            { "az", "അസർബൈജാനി" },
            { "ba", "ബഷ്ഖിർ" },
            { "be", "ബെലാറുഷ്യൻ" },
            { "bg", "ബൾഗേറിയൻ" },
            { "bi", "ബിസ്‌ലാമ" },
            { "bm", "ബംബാറ" },
            { "bn", "ബംഗ്ലാ" },
            { "bo", metaValue_bo },
            { "br", "ബ്രെട്ടൺ" },
            { "bs", "ബോസ്നിയൻ" },
            { "ca", "കറ്റാലാൻ" },
            { "ce", "ചെചൻ" },
            { "ch", "ചമോറോ" },
            { "co", "കോർസിക്കൻ" },
            { "cr", "ക്രീ" },
            { "cs", "ചെക്ക്" },
            { "cu", "ചർച്ച് സ്ലാവിക്" },
            { "cv", "ചുവാഷ്" },
            { "cy", "വെൽഷ്" },
            { "da", "ഡാനിഷ്" },
            { "de", "ജർമ്മൻ" },
            { "dv", "ദിവെഹി" },
            { "dz", "ദ്‌സോങ്ക" },
            { "ee", "യൂ" },
            { "el", metaValue_el },
            { "en", "ഇംഗ്ലീഷ്" },
            { "eo", "എസ്‌പരാന്റോ" },
            { "es", "സ്‌പാനിഷ്" },
            { "et", "എസ്റ്റോണിയൻ" },
            { "eu", "ബാസ്‌ക്" },
            { "fa", "പേർഷ്യൻ" },
            { "ff", "ഫുല" },
            { "fi", "ഫിന്നിഷ്" },
            { "fj", "ഫിജിയൻ" },
            { "fo", "ഫാറോസ്" },
            { "fr", "ഫ്രഞ്ച്" },
            { "fy", "പശ്ചിമ ഫ്രിഷിയൻ" },
            { "ga", "ഐറിഷ്" },
            { "gd", "സ്കോട്ടിഷ് ഗൈലിക്" },
            { "gl", "ഗലീഷ്യൻ" },
            { "gn", "ഗ്വരനി" },
            { "gu", metaValue_gu },
            { "gv", "മാൻസ്" },
            { "ha", "ഹൗസ" },
            { "he", metaValue_he },
            { "hi", "ഹിന്ദി" },
            { "ho", "ഹിരി മോതു" },
            { "hr", "ക്രൊയേഷ്യൻ" },
            { "ht", "ഹെയ്‌തിയൻ ക്രിയോൾ" },
            { "hu", "ഹംഗേറിയൻ" },
            { "hy", metaValue_hy },
            { "hz", "ഹെരേരൊ" },
            { "ia", "ഇന്റർലിംഗ്വ" },
            { "id", "ഇന്തോനേഷ്യൻ" },
            { "ie", "ഇന്റർലിംഗ്വേ" },
            { "ig", "ഇഗ്ബോ" },
            { "ii", "ഷുവാൻയി" },
            { "ik", "ഇനുപിയാക്" },
            { "io", "ഇഡോ" },
            { "is", "ഐസ്‌ലാൻഡിക്" },
            { "it", "ഇറ്റാലിയൻ" },
            { "iu", "ഇനുക്റ്റിറ്റുട്ട്" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", "ജോർജിയൻ" },
            { "kg", "കോംഗോ" },
            { "ki", "കികൂയു" },
            { "kj", "ക്വാന്യമ" },
            { "kk", "കസാഖ്" },
            { "kl", "കലാല്ലിസുട്ട്" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "കനൂറി" },
            { "ks", "കശ്‌മീരി" },
            { "ku", "കുർദ്ദിഷ്" },
            { "kv", "കോമി" },
            { "kw", "കോർണിഷ്" },
            { "ky", "കിർഗിസ്" },
            { "la", metaValue_la },
            { "lb", "ലക്‌സംബർഗിഷ്" },
            { "lg", "ഗാണ്ട" },
            { "li", "ലിംബർഗിഷ്" },
            { "ln", "ലിംഗാല" },
            { "lo", metaValue_lo },
            { "lt", "ലിത്വാനിയൻ" },
            { "lu", "ലുബ-കറ്റംഗ" },
            { "lv", "ലാറ്റ്വിയൻ" },
            { "mg", "മലഗാസി" },
            { "mh", "മാർഷല്ലീസ്" },
            { "mi", "മവോറി" },
            { "mk", "മാസിഡോണിയൻ" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "മറാത്തി" },
            { "ms", "മലെയ്" },
            { "mt", "മാൾട്ടീസ്" },
            { "my", "ബർമീസ്" },
            { "na", metaValue_NR },
            { "nb", "നോർവീജിയൻ ബുക്‌മൽ" },
            { "nd", "നോർത്ത് ഡെബിൾ" },
            { "ne", "നേപ്പാളി" },
            { "ng", "ഡോങ്ക" },
            { "nl", "ഡച്ച്" },
            { "nn", "നോർവീജിയൻ നൈനോർക്‌സ്" },
            { "no", "നോർവീജിയൻ" },
            { "nr", "ദക്ഷിണ നെഡിബിൾ" },
            { "nv", "നവാജോ" },
            { "ny", "ന്യൻജ" },
            { "oc", "ഓക്‌സിറ്റൻ" },
            { "oj", "ഓജിബ്വാ" },
            { "om", "ഒറോമോ" },
            { "or", metaValue_or },
            { "os", "ഒസ്സെറ്റിക്" },
            { "pa", "പഞ്ചാബി" },
            { "pi", "പാലി" },
            { "pl", "പോളിഷ്" },
            { "ps", "പഷ്‌തോ" },
            { "pt", "പോർച്ചുഗീസ്" },
            { "qu", "ക്വെച്ചുവ" },
            { "rm", "റൊമാഞ്ച്" },
            { "rn", "റുണ്ടി" },
            { "ro", "റൊമാനിയൻ" },
            { "ru", "റഷ്യൻ" },
            { "rw", "കിന്യാർവാണ്ട" },
            { "sa", "സംസ്‌കൃതം" },
            { "sc", "സർഡിനിയാൻ" },
            { "sd", "സിന്ധി" },
            { "se", "വടക്കൻ സമി" },
            { "sg", "സാംഗോ" },
            { "sh", "സെർബോ-ക്രൊയേഷ്യൻ" },
            { "si", metaValue_si },
            { "sk", "സ്ലോവാക്" },
            { "sl", "സ്ലോവേനിയൻ" },
            { "sm", "സമോവൻ" },
            { "sn", "ഷോണ" },
            { "so", "സോമാലി" },
            { "sq", "അൽബേനിയൻ" },
            { "sr", "സെർബിയൻ" },
            { "ss", "സ്വാറ്റി" },
            { "st", "തെക്കൻ സോതോ" },
            { "su", "സുണ്ടാനീസ്" },
            { "sv", "സ്വീഡിഷ്" },
            { "sw", "സ്വാഹിലി" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "താജിക്" },
            { "th", metaValue_th },
            { "ti", "ടൈഗ്രിന്യ" },
            { "tk", "തുർക്‌മെൻ" },
            { "tl", "തഗാലോഗ്" },
            { "tn", "സ്വാന" },
            { "to", "ടോംഗൻ" },
            { "tr", "ടർക്കിഷ്" },
            { "ts", "സോംഗ" },
            { "tt", "ടാട്ടർ" },
            { "tw", "ട്വി" },
            { "ty", "താഹിതിയൻ" },
            { "ug", "ഉയ്ഘുർ" },
            { "uk", "ഉക്രേനിയൻ" },
            { "ur", "ഉറുദു" },
            { "uz", "ഉസ്‌ബെക്ക്" },
            { "ve", "വെന്ദ" },
            { "vi", "വിയറ്റ്നാമീസ്" },
            { "vo", "വോളാപുക്" },
            { "wa", "വല്ലൂൺ" },
            { "wo", "വൊളോഫ്" },
            { "xh", "ഖോസ" },
            { "yi", "യിദ്ദിഷ്" },
            { "yo", "യൊറൂബാ" },
            { "za", "സ്വാംഗ്" },
            { "zh", "ചൈനീസ്" },
            { "zu", "സുലു" },
            { "ace", "അചിനീസ്" },
            { "ach", "അകോലി" },
            { "ada", "അഡാങ്‌മി" },
            { "ady", "അഡൈഗേ" },
            { "afh", "ആഫ്രിഹിലി" },
            { "agq", "ആഘേം" },
            { "ain", "ഐനു" },
            { "akk", "അക്കാഡിയൻ" },
            { "ale", "അലൂട്ട്" },
            { "alt", "തെക്കൻ അൾത്തായി" },
            { "ang", "പഴയ ഇംഗ്ലീഷ്" },
            { "ann", "ഒബോളോ" },
            { "anp", "ആൻഗിക" },
            { "arc", "അരമായ" },
            { "arn", "മാപുചി" },
            { "arp", "അറാപഹോ" },
            { "ars", "നജ്‌ദി അറബിക്" },
            { "arw", "അറാവക്" },
            { "asa", "ആസു" },
            { "ast", "അസ്ട്ടൂരിയൻ" },
            { "atj", "അറ്റികമെക്‌വ്" },
            { "awa", "അവാധി" },
            { "bal", "ബലൂചി" },
            { "ban", metaValue_ban },
            { "bas", "ബാസ" },
            { "bax", "ബാമുൻ" },
            { "bbj", "ഘോമാല" },
            { "bej", "ബേജ" },
            { "bem", "ബേംബ" },
            { "bez", "ബെനാ" },
            { "bfd", "ബാഫട്ട്" },
            { "bgc", "ഹർയാൻവി" },
            { "bgn", "പശ്ചിമ ബലൂചി" },
            { "bho", "ഭോജ്‌പുരി" },
            { "bik", "ബികോൽ" },
            { "bin", "ബിനി" },
            { "bkm", "കോം" },
            { "bla", "സിക്സിക" },
            { "blo", "അനി" },
            { "bra", "ബ്രജ്" },
            { "brx", "ബോഡോ" },
            { "bss", "അക്കൂസ്" },
            { "bua", "ബുറിയത്ത്" },
            { "bug", metaValue_bug },
            { "bum", "ബുളു" },
            { "byn", "ബ്ലിൻ" },
            { "byv", "മെഡുംബ" },
            { "cad", "കാഡോ" },
            { "car", "കാരിബ്" },
            { "cay", "കയൂഗ" },
            { "cch", "അറ്റ്സാം" },
            { "ccp", "ചക്‌മ" },
            { "ceb", "സെബുവാനോ" },
            { "cgg", "ചിഗ" },
            { "chb", "ചിബ്ച" },
            { "chg", "ഷാഗതായ്" },
            { "chk", "ചൂകീസ്" },
            { "chm", "മാരി" },
            { "chn", "ചിനൂഗ് ജാർഗൺ" },
            { "cho", "ചോക്റ്റാവ്" },
            { "chp", "ചിപേവ്യൻ" },
            { "chr", "ഷെരോക്കി" },
            { "chy", "ഷായാൻ" },
            { "ckb", "സെൻട്രൽ കുർദിഷ്" },
            { "clc", "ചിൽകോട്ടിൻ" },
            { "cop", metaValue_cop },
            { "crg", "മിചിഫ്" },
            { "crh", "ക്രിമിയൻ ടർക്കിഷ്" },
            { "crj", "സതേൺ ഈസ്റ്റ് ക്രീ" },
            { "crk", "പ്ലെയ്‌ൻസ് ക്രീ" },
            { "crl", "നോർത്തേൺ ഈസ്റ്റ് ക്രീ" },
            { "crm", "മൂസ് ക്രീ" },
            { "crr", "കരോലീന അൽഗോൻക്വിയാൻ" },
            { "crs", "സെഷൽവ ക്രിയോൾ ഫ്രഞ്ച്" },
            { "csb", "കാഷുബിയാൻ" },
            { "csw", "സ്വാംപി ക്രീ" },
            { "dak", "ഡകോട്ട" },
            { "dar", "ഡർഗ്വാ" },
            { "dav", "തൈത" },
            { "del", "ദെലവേർ" },
            { "den", "സ്ലേവ്" },
            { "dgr", "ഡോഗ്രിബ്" },
            { "din", "ദിൻക" },
            { "dje", "സാർമ്മ" },
            { "doi", "ഡോഗ്രി" },
            { "dsb", "ലോവർ സോർബിയൻ" },
            { "dua", "ദ്വാല" },
            { "dum", "മദ്ധ്യ ഡച്ച്" },
            { "dyo", "ജോല-ഫോൻയി" },
            { "dyu", "ദ്വൈല" },
            { "dzg", "ഡാസാഗ" },
            { "ebu", "എംബു" },
            { "efi", "എഫിക്" },
            { "egy", "പ്രാചീന ഈജിപ്ഷ്യൻ" },
            { "eka", "എകാജുക്" },
            { "elx", "എലാമൈറ്റ്" },
            { "enm", "മദ്ധ്യ ഇംഗ്ലീഷ്" },
            { "ewo", "എവോൻഡോ" },
            { "fan", "ഫങ്" },
            { "fat", "ഫാന്റി" },
            { "fil", "ഫിലിപ്പിനോ" },
            { "fon", "ഫോൻ" },
            { "frc", "കേജൺ ഫ്രഞ്ച്" },
            { "frm", "മദ്ധ്യ ഫ്രഞ്ച്" },
            { "fro", "പഴയ ഫ്രഞ്ച്" },
            { "frr", "നോർത്തേൻ ഫ്രിഷ്യൻ" },
            { "frs", "ഈസ്റ്റേൺ ഫ്രിഷ്യൻ" },
            { "fur", "ഫ്രിയുലിയാൻ" },
            { "gaa", "ഗാ" },
            { "gag", "ഗാഗൂസ്" },
            { "gan", "ഗാൻ ചൈനീസ്" },
            { "gay", "ഗയൊ" },
            { "gba", "ഗബ്യ" },
            { "gez", "ഗീസ്" },
            { "gil", "ഗിൽബർട്ടീസ്" },
            { "gmh", "മദ്ധ്യ ഉച്ച ജർമൻ" },
            { "goh", "ഓൾഡ് ഹൈ ജർമൻ" },
            { "gon", "ഗോണ്ഡി" },
            { "gor", "ഗൊറോന്റാലോ" },
            { "got", "ഗോഥിക്ക്" },
            { "grb", "ഗ്രബൊ" },
            { "grc", "പുരാതന ഗ്രീക്ക്" },
            { "gsw", "സ്വിസ് ജർമ്മൻ" },
            { "guz", "ഗുസീ" },
            { "gwi", "ഗ്വിച്ചിൻ" },
            { "hai", "ഹൈഡ" },
            { "hak", "ഹാക്ക ചൈനീസ്" },
            { "haw", "ഹവായിയൻ" },
            { "hax", "സതേൺ ഹൈഡ" },
            { "hil", "ഹിലിഗയ്നോൺ" },
            { "hit", "ഹിറ്റൈറ്റ്" },
            { "hmn", "മോങ്" },
            { "hsb", "അപ്പർ സോർബിയൻ" },
            { "hsn", "ഷ്യാങ് ചൈനീസ്" },
            { "hup", "ഹൂപ" },
            { "hur", "ഹോക്കൊമെലം" },
            { "iba", "ഇബാൻ" },
            { "ibb", "ഇബീബിയോ" },
            { "ikt", "വെസ്റ്റേൺ കനേഡിയൻ ഇനുക്ടിറ്റൂറ്റ്" },
            { "ilo", "ഇലോകോ" },
            { "inh", "ഇങ്കുഷ്" },
            { "jbo", "ലോജ്ബാൻ" },
            { "jgo", "ഗോമ്പ" },
            { "jmc", "മചേം" },
            { "jpr", "ജൂഡിയോ-പേർഷ്യൻ" },
            { "jrb", "ജൂഡിയോ-അറബിക്" },
            { "kaa", "കര-കാൽപ്പക്" },
            { "kab", "കബൈൽ" },
            { "kac", "കാചിൻ" },
            { "kaj", "ജ്യൂ" },
            { "kam", "കംബ" },
            { "kaw", "കാവി" },
            { "kbd", "കബർഡിയാൻ" },
            { "kbl", "കനെംബു" },
            { "kcg", "ട്യാപ്" },
            { "kde", "മക്കോണ്ടെ" },
            { "kea", "കബുവെർദിയാനു" },
            { "kfo", "കോറോ" },
            { "kgp", "കെയിൻഗാംഗ്" },
            { "kha", "ഖാസി" },
            { "kho", "ഘോറ്റാനേസേ" },
            { "khq", "കൊയ്റ ചീനി" },
            { "kkj", "കാകോ" },
            { "kln", "കലെഞ്ചിൻ" },
            { "kmb", "കിംബുണ്ടു" },
            { "koi", "കോമി-പെർമ്യാക്ക്" },
            { "kok", "കൊങ്കണി" },
            { "kos", "കൊസറേയൻ" },
            { "kpe", "പെൽ" },
            { "krc", "കരാചൈ-ബാൽകാർ" },
            { "krl", "കരീലിയൻ" },
            { "kru", "കുരുഖ്" },
            { "ksb", "ഷംഭാള" },
            { "ksf", "ബാഫിയ" },
            { "ksh", "കൊളോണിയൻ" },
            { "kum", "കൂമിക്ക്" },
            { "kut", "കുതേനൈ" },
            { "kwk", "ക്വാക്വല" },
            { "kxv", "കുവി" },
            { "lad", "ലഡീനോ" },
            { "lag", "ലാംഗി" },
            { "lah", "ലഹ്‌ൻഡ" },
            { "lam", "ലംബ" },
            { "lez", "ലസ്ഗിയൻ" },
            { "lij", "ലിഗൂറിയൻ" },
            { "lil", "ലില്ലുവെറ്റ്" },
            { "lkt", "ലകൗട്ട" },
            { "lmo", "ലൊംബാർഡ്" },
            { "lol", "മോങ്കോ" },
            { "lou", "ലൂസിയാന ക്രിയോൾ" },
            { "loz", "ലൊസി" },
            { "lrc", "വടക്കൻ ലൂറി" },
            { "lsm", "സാമിയ" },
            { "lua", "ലൂബ-ലുലുവ" },
            { "lui", "ലൂയിസെനോ" },
            { "lun", "ലുൻഡ" },
            { "luo", "ലുവോ" },
            { "lus", "മിസോ" },
            { "luy", "ലുയിയ" },
            { "mad", "മദുരേസേ" },
            { "maf", "മാഫ" },
            { "mag", "മഗാഹി" },
            { "mai", "മൈഥിലി" },
            { "mak", "മകാസർ" },
            { "man", "മണ്ഡിൻഗോ" },
            { "mas", "മസായ്" },
            { "mde", "മാബ" },
            { "mdf", "മോക്ഷ" },
            { "mdr", "മണ്ഡാർ" },
            { "men", "മെൻഡെ" },
            { "mer", "മേരു" },
            { "mfe", "മൊറിസിൻ" },
            { "mga", "മദ്ധ്യ ഐറിഷ്" },
            { "mgh", "മാഖുവാ-മീത്തോ" },
            { "mgo", "മേത്താ" },
            { "mic", "മിക്മാക്" },
            { "min", "മിനാങ്കബൗ" },
            { "mnc", "മാൻ‌ചു" },
            { "mni", "മണിപ്പൂരി" },
            { "moe", "ഇന്നു-ഐമൂൻ" },
            { "moh", "മോഹാക്" },
            { "mos", "മൊസ്സി" },
            { "mua", "മുന്ദാംഗ്" },
            { "mul", "പലഭാഷകൾ" },
            { "mus", "ക്രീക്ക്" },
            { "mwl", "മിരാൻറസേ" },
            { "mwr", "മർവാരി" },
            { "mye", "മയീൻ" },
            { "myv", "ഏഴ്സ്യ" },
            { "mzn", "മസന്ററാനി" },
            { "nan", "മിൻ നാൻ ചൈനീസ്" },
            { "nap", "നെപ്പോളിറ്റാൻ" },
            { "naq", "നാമ" },
            { "nds", "ലോ ജർമൻ" },
            { "new", "നേവാരി" },
            { "nia", "നിയാസ്" },
            { "niu", "ന്യുവാൻ" },
            { "nmg", "ക്വേസിയോ" },
            { "nnh", "ഗീംബൂൺ" },
            { "nog", "നോഗൈ" },
            { "non", "പഴയ നോഴ്‌സ്" },
            { "nqo", "ഇൻകോ" },
            { "nso", "നോർത്തേൻ സോതോ" },
            { "nus", "നുവേർ" },
            { "nwc", "ക്ലാസിക്കൽ നേവാരി" },
            { "nym", "ന്യാംവേസി" },
            { "nyn", "ന്യാൻകോൾ" },
            { "nyo", "ന്യോറോ" },
            { "nzi", "സിമ" },
            { "ojb", "നോർത്ത്‌വെസ്റ്റേൺ ഒജീബ്‌വെ" },
            { "ojc", "സെൻട്രൽ ഒജീബ്‌വെ" },
            { "ojs", "ഒജി-ക്രീ" },
            { "ojw", "വെസ്റ്റേൺ ഒജീബ്‌വെ" },
            { "oka", "ഒകാനഗൻ" },
            { "osa", "ഒസേജ്" },
            { "ota", "ഓട്ടോമൻ തുർക്കിഷ്" },
            { "pag", "പങ്കാസിനൻ" },
            { "pal", "പാഹ്ലവി" },
            { "pam", "പാംപൻഗ" },
            { "pap", "പാപിയാമെന്റൊ" },
            { "pau", "പലാവുൻ" },
            { "pcm", "നൈജീരിയൻ പിഡ്‌ഗിൻ" },
            { "peo", metaValue_peo },
            { "phn", "ഫീനിഷ്യൻ" },
            { "pis", "പിജിൻ" },
            { "pon", "പൊൻപിയൻ" },
            { "pqm", "മലിസീറ്റ്-പസാമക്വുഡി" },
            { "prg", "പ്രഷ്യൻ" },
            { "pro", "പഴയ പ്രൊവൻഷ്ൽ" },
            { "quc", "ക്വിച്ചെ" },
            { "raj", "രാജസ്ഥാനി" },
            { "rap", "രാപനൂയി" },
            { "rar", "രാരോടോങ്കൻ" },
            { "rhg", "റോഹിംഗാ" },
            { "rof", "റോംബോ" },
            { "rom", "റൊമാനി" },
            { "rup", "ആരോമാനിയൻ" },
            { "rwk", "റുവാ" },
            { "sad", "സാൻഡവേ" },
            { "sah", "സാഖ" },
            { "sam", "സമരിയാക്കാരുടെ അരമായ" },
            { "saq", "സംബുരു" },
            { "sas", "സസാക്" },
            { "sat", "സന്താലി" },
            { "sba", "ഗംബായ്" },
            { "sbp", "സംഗു" },
            { "scn", "സിസിലിയൻ" },
            { "sco", "സ്കോട്സ്" },
            { "sdh", "തെക്കൻ കുർദ്ദിഷ്" },
            { "see", "സെനേക" },
            { "seh", "സേന" },
            { "sel", "സെൽകപ്" },
            { "ses", "കൊയ്റാബൊറോ സെന്നി" },
            { "sga", "പഴയ ഐറിഷ്" },
            { "shi", "താച്ചലിറ്റ്" },
            { "shn", "ഷാൻ" },
            { "shu", "ചാഡിയൻ അറബി" },
            { "sid", "സിഡാമോ" },
            { "slh", "സതേൺ ലുഷൂറ്റ്‌സീഡ്" },
            { "sma", "തെക്കൻ സമി" },
            { "smj", "ലൂലീ സമി" },
            { "smn", "ഇനാരി സമി" },
            { "sms", "സ്കോൾട്ട് സമി" },
            { "snk", "സോണിൻകെ" },
            { "sog", "സോജിഡിയൻ" },
            { "srn", "ശ്രാനൻ ഡോങ്കോ" },
            { "srr", "സെറർ" },
            { "ssy", "സാഹോ" },
            { "str", "സ്ട്രെയ്റ്റ്സ് സെയ്‌ലിഷ്" },
            { "suk", "സുകുമ" },
            { "sus", "സുസു" },
            { "sux", "സുമേരിയൻ" },
            { "swb", "കൊമോറിയൻ" },
            { "syc", "പുരാതന സുറിയാനിഭാഷ" },
            { "syr", "സുറിയാനി" },
            { "szl", "സൈലേഷ്യൻ" },
            { "tce", "സതേൺ ടറ്റ്ഷോൺ" },
            { "tem", "ടിംനേ" },
            { "teo", "ടെസോ" },
            { "ter", "ടെറേനോ" },
            { "tet", "ടെറ്റും" },
            { "tgx", "ടാഗിഷ്" },
            { "tht", "ടാഹ്‌ൽടൻ" },
            { "tig", "ടൈഗ്രി" },
            { "tiv", "ടിവ്" },
            { "tkl", "ടൊക്കേലൗ" },
            { "tlh", "ക്ലിംഗോൺ" },
            { "tli", "ലിംഗ്വിറ്റ്" },
            { "tmh", "ടമഷേക്" },
            { "tog", "ന്യാസാ ഡോങ്ക" },
            { "tok", "ടോകി പോന" },
            { "tpi", "ടോക് പിസിൻ" },
            { "trv", "തരോക്കോ" },
            { "tsi", "സിംഷ്യൻ" },
            { "ttm", "നോർത്തേൺ ടറ്റ്ഷോൺ" },
            { "tum", "ടുംബുക" },
            { "tvl", metaValue_TV },
            { "twq", "ടസവാക്ക്" },
            { "tyv", "തുവിനിയൻ" },
            { "tzm", "മധ്യ അറ്റ്‌ലസ് ടമാസൈറ്റ്" },
            { "udm", "ഉഡ്മുർട്ട്" },
            { "uga", "ഉഗറിട്ടിക്" },
            { "umb", "ഉംബുന്ദു" },
            { "und", "അജ്ഞാത ഭാഷ" },
            { "vai", metaValue_vai },
            { "vec", "വെനീഷ്യൻ" },
            { "vmw", "മഖുവ" },
            { "vot", "വോട്ടിക്" },
            { "vun", "വുൻജോ" },
            { "wae", "വാൾസർ" },
            { "wal", "വൊലൈറ്റ" },
            { "war", "വാരേയ്" },
            { "was", "വാഷൊ" },
            { "wbp", "വൂൾപിരി" },
            { "wuu", "വു ചൈനീസ്" },
            { "xal", "കാൽമിക്" },
            { "xnr", "കാങ്ടി" },
            { "xog", "സോഗോ" },
            { "yao", "യാവോ" },
            { "yap", "യെപ്പീസ്" },
            { "yav", "യാംഗ്ബെൻ" },
            { "ybb", "യംബ" },
            { "yrl", "നീൻഗാറ്റു" },
            { "yue", "കാന്റണീസ്" },
            { "zap", "സാപ്പോടെക്" },
            { "zbl", "ബ്ലിസ്സിംബൽസ്" },
            { "zen", "സെനഗ" },
            { "zgh", "സ്റ്റാൻഡേർഡ് മൊറോക്കൻ റ്റാമസിയറ്റ്" },
            { "zun", "സുനി" },
            { "zxx", "ഭാഷാപരമായ ഉള്ളടക്കമൊന്നുമില്ല" },
            { "zza", "സാസാ" },
            { "Adlm", "അദ്‌ലാം" },
            { "Arab", metaValue_ar },
            { "Aran", "നസ്‌റ്റാലിക്" },
            { "Armi", "അർമി" },
            { "Armn", metaValue_hy },
            { "Avst", "അവെസ്ഥൻ" },
            { "Bali", metaValue_ban },
            { "Batk", "ബട്ടക്" },
            { "Beng", "ബംഗാളി" },
            { "Blis", "ബ്ലിസ് ചിത്ര ലിപി" },
            { "Bopo", "ബോപ്പോമോഫോ" },
            { "Brah", "ബ്രാഹ്മി" },
            { "Brai", "ബ്രെയ്‌ലി" },
            { "Bugi", metaValue_bug },
            { "Buhd", "ബുഹിഡ്" },
            { "Cakm", "ചക്മ" },
            { "Cans", "ഏകീകൃത കനേഡിയൻ ഗോത്രലിപി" },
            { "Cari", "ചരിയൻ" },
            { "Cham", "ഛം" },
            { "Cher", "ചെറോക്കി" },
            { "Cirt", "ചിർത്ത്" },
            { "Copt", metaValue_cop },
            { "Cprt", "സൈപ്രിയോട്ട്" },
            { "Cyrl", "സിറിലിക്" },
            { "Cyrs", "പുരാതന ചർച്ച് സ്ലവോണിക് സിറിലിക്" },
            { "Deva", "ദേവനാഗരി" },
            { "Dsrt", "ഡെസെർട്ട്" },
            { "Egyd", "ഈജിപ്ഷ്യൻ ഡിമോട്ടിക്" },
            { "Egyh", "ഈജിപ്ഷ്യൻ ഹിരാറ്റിക്" },
            { "Egyp", "ഈജിപ്ഷ്യൻ ചിത്രലിപി" },
            { "Ethi", "എത്യോപിക്" },
            { "Geok", "ജോർജ്ജിയൻ ഖുട്സുരി" },
            { "Geor", "ജോർജ്ജിയൻ" },
            { "Glag", "ഗ്ലഗോലിറ്റിക്" },
            { "Goth", "ഗോഥിക്" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ഗുരുമുഖി" },
            { "Hanb", "ഹൻബ്" },
            { "Hang", "ഹാംഗുൽ" },
            { "Hani", "ഹാൻ" },
            { "Hano", "ഹനുനൂ" },
            { "Hans", "ലളിതവൽക്കരിച്ചത്" },
            { "Hant", "പരമ്പരാഗതം" },
            { "Hebr", metaValue_he },
            { "Hira", "ഹിരഗാന" },
            { "Hmng", "പഹ്വാ ഹമോംഗ്" },
            { "Hrkt", "ജാപ്പനീസ് സില്ലബറീസ്" },
            { "Hung", "പുരാതന ഹംഗേറിയൻ" },
            { "Inds", "സിന്ധു" },
            { "Ital", "പഴയ ഇറ്റാലിയൻ" },
            { "Jamo", "ജാമോ" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "കയാ ലി" },
            { "Kana", "കറ്റക്കാന" },
            { "Khar", "ഖരോഷ്ടി" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "ക്തി" },
            { "Lana", "ലന്ന" },
            { "Laoo", metaValue_lo },
            { "Latf", "ഫ്രാക്ടുർ ലാറ്റിൻ" },
            { "Latg", "ഗെയ്‌ലിക് ലാറ്റിൻ" },
            { "Latn", metaValue_la },
            { "Lepc", "ലെപ്ച" },
            { "Limb", "ലിംബു" },
            { "Lina", "സമരേഖയിലുള്ള എ" },
            { "Linb", "ലീനിയർ ബി" },
            { "Lyci", "ലൈസിൻ" },
            { "Lydi", "ലൈഡിയൻ" },
            { "Mand", "മൻഡേയൻ" },
            { "Mani", "മണിചേയൻ" },
            { "Maya", "മായൻ ചിത്രലിപി" },
            { "Mero", "മെറോയിറ്റിക്" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "മൂൺ" },
            { "Mtei", "മേറ്റി മായക്" },
            { "Mymr", "മ്യാൻമാർ" },
            { "Nkoo", "എൻകോ" },
            { "Ogam", "ഒഖാം" },
            { "Olck", "ഒൽ ചിക്കി" },
            { "Orkh", "ഒർഖോൺ" },
            { "Orya", metaValue_or },
            { "Osma", "ഒസ്‌മാനിയ" },
            { "Perm", "പുരാതന പെർമിക്" },
            { "Phag", "ഫഗസ് പ" },
            { "Phli", "എഴുത്തു പഹൽവി" },
            { "Phlp", "സാൾട്ടർ പഹൽവി" },
            { "Phlv", "പഹൽവി ലിപി" },
            { "Phnx", "ഫിനീഷ്യൻ" },
            { "Plrd", "പൊള്ളാർഡ് ശബ്ദലിപി" },
            { "Prti", "പൃതി" },
            { "Rjng", "റെജാംഗ്" },
            { "Rohg", "ഹനിഫി" },
            { "Roro", "റൊംഗോറൊംഗോ" },
            { "Runr", "റുണിക്" },
            { "Samr", "സമരിയ" },
            { "Sara", "സരതി" },
            { "Saur", "സൗരാഷ്ട്ര" },
            { "Sgnw", "ചിഹ്നലിപി" },
            { "Shaw", "ഷാവിയൻ" },
            { "Sinh", metaValue_si },
            { "Sund", "സന്താനീസ്" },
            { "Sylo", "സൈലോതി നാഗരി" },
            { "Syrc", "സിറിയക്ക്" },
            { "Syre", "എസ്റ്റ്രാംഗ്ലോ സിറിയക്" },
            { "Syrj", "പശ്ചിമസുറിയാനി" },
            { "Syrn", "കിഴക്കൻ സിറിയക്" },
            { "Tagb", "തഗ്ബൻവാ" },
            { "Tale", "തായ് ലേ" },
            { "Talu", "പുതിയ തായ് ല്യൂ" },
            { "Taml", metaValue_ta },
            { "Tavt", "ത്വട്" },
            { "Telu", metaValue_te },
            { "Teng", "തെംഗ്വർ" },
            { "Tfng", "തിഫിനാഗ്" },
            { "Tglg", "തഗലോഗ്" },
            { "Thaa", "ഥാന" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "ഉഗ്രൈറ്റിക്" },
            { "Vaii", metaValue_vai },
            { "Visp", "ദൃശ്യഭാഷ" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "സുമേറോ അക്കാഡിയൻ ക്യുണിഫോം" },
            { "Yiii", "യി" },
            { "Zinh", "പാരമ്പര്യമായ" },
            { "Zmth", "ഗണിത രൂപം" },
            { "Zsye", "ഇമോജി" },
            { "Zsym", "ചിഹ്നങ്ങൾ" },
            { "Zxxx", "എഴുതപ്പെടാത്തത്" },
            { "Zyyy", "സാധാരണ" },
            { "Zzzz", "അജ്ഞാത ലിപി" },
            { "de_AT", "ഓസ്‌ട്രിയൻ ജർമ്മൻ" },
            { "de_CH", "സ്വിസ് ഹൈ ജർമ്മൻ" },
            { "en_AU", "ഓസ്‌ട്രേലിയൻ ഇംഗ്ലീഷ്" },
            { "en_CA", "കനേഡിയൻ ഇംഗ്ലീഷ്" },
            { "en_GB", "ബ്രിട്ടീഷ് ഇംഗ്ലീഷ്" },
            { "en_US", "അമേരിക്കൻ ഇംഗ്ലീഷ്" },
            { "es_ES", "യൂറോപ്യൻ സ്‌പാനിഷ്" },
            { "es_MX", "മെക്സിക്കൻ സ്പാനിഷ്" },
            { "fa_AF", "ഡാരി" },
            { "fr_CA", "കനേഡിയൻ ഫ്രഞ്ച്" },
            { "fr_CH", "സ്വിസ് ഫ്രഞ്ച്" },
            { "nl_BE", "ഫ്ലമിഷ്" },
            { "pt_BR", "ബ്രസീലിയൻ പോർച്ചുഗീസ്" },
            { "pt_PT", "യൂറോപ്യൻ പോർച്ചുഗീസ്" },
            { "ro_MD", "മോൾഡാവിയൻ" },
            { "sw_CD", "കോംഗോ സ്വാഹിലി" },
            { "%%1996", "1996-ലെ ജർമൻ ലിപി" },
            { "ar_001", "ആധുനിക സ്റ്റാൻഡേർഡ് അറബിക്" },
            { "es_419", "ലാറ്റിൻ അമേരിക്കൻ സ്‌പാനിഷ്" },
            { "key.ca", "കലണ്ടർ" },
            { "key.cf", "കറൻസി ഫോർമാറ്റ്" },
            { "key.co", "അടുക്കൽ ക്രമം" },
            { "key.cu", "നാണയം" },
            { "key.hc", "സമയ ഘടന (12 / 24)" },
            { "key.lb", "രേഖ വിഭാജി ശൈലി" },
            { "key.ms", "അളക്കൽ സംവിധാനം" },
            { "key.nu", "അക്കങ്ങൾ‌" },
            { "key.tz", "സമയ മേഖല" },
            { "key.va", "ഭാഷാ ഭേദം" },
            { "nds_NL", "ലോ സാക്സൺ" },
            { "%%BOONT", "ബൂണ്ട്‌ലിങ്ങ്" },
            { "%%NEDIS", "നേറ്റിസോൺ പ്രാദേശികരൂപം" },
            { "%%NJIVA", "ഗ്നിവ/നിജിവ പ്രാദേശികരൂപം" },
            { "%%POSIX", "കമ്പ്യൂട്ടർ" },
            { "zh_Hans", "ലളിതമാക്കിയ ചൈനീസ്" },
            { "zh_Hant", "പരമ്പരാഗത ചൈനീസ്" },
            { "%%FONIPA", "ഐപി‌എ സ്വനവ്യവസ്ഥ" },
            { "%%AREVELA", "കിഴക്കൻ അർമീനിയൻ" },
            { "%%MONOTON", "മോണോറ്റോണിക്" },
            { "%%REVISED", "പരിഷ്ക്കരിച്ച ലിപി" },
            { "%%1606NICT", "1606 വരെയുള്ള ആധുനികമദ്ധ്യകാല ഫ്രഞ്ച്" },
            { "type.ca.roc", "മിംഗ്വോ കലണ്ടർ" },
            { "type.co.eor", "യൂറോപ്യൻ അടുക്കൽ നിയമങ്ങൾ" },
            { "type.hc.h11", "12 മണിക്കൂർ സംവിധാനം (0–11)" },
            { "type.hc.h12", "12 മണിക്കൂർ സംവിധാനം (1–12)" },
            { "type.hc.h23", "24 മണിക്കൂർ സംവിധാനം (0–23)" },
            { "type.hc.h24", "24 മണിക്കൂർ സംവിധാനം (1–24)" },
            { "type.m0.bgn", "യു.എസ്. ബി.ജി.എൻ. ലിപ്യന്തരണം" },
            { "type.nu.ahom", "അഹോം അക്കങ്ങൾ" },
            { "type.nu.arab", "അറബിക്-ഇന്ത്യ അക്കങ്ങൾ" },
            { "type.nu.armn", "അർമേനിയൻ സംഖ്യകൾ" },
            { "type.nu.bali", "ബെലിനീസ് അക്കങ്ങൾ" },
            { "type.nu.beng", "ബംഗ്ലാ അക്കങ്ങൾ" },
            { "type.nu.brah", "ബ്രാഹ്‌മി അക്കങ്ങൾ" },
            { "type.nu.cakm", "ചക്മ അക്കങ്ങൾ" },
            { "type.nu.cham", "ചാം അക്കങ്ങൾ" },
            { "type.nu.cyrl", "സിറിലിക് അക്കങ്ങൾ" },
            { "type.nu.deva", "ദേവനാഗരി അക്കങ്ങൾ" },
            { "type.nu.ethi", "എത്യോപിക് സംഖ്യകൾ" },
            { "type.nu.geor", "ജോർജിയൻ സംഖ്യകൾ" },
            { "type.nu.gonm", "മസാറം ഗോണ്ടി അക്കങ്ങൾ" },
            { "type.nu.grek", "ഗ്രീക്ക് സംഖ്യകൾ" },
            { "type.nu.gujr", "ഗുജറാത്തി അക്കങ്ങൾ" },
            { "type.nu.guru", "ഗുരുമുഖി അക്കങ്ങൾ" },
            { "type.nu.hans", "ലളിതവൽക്കരിച്ച ചൈനീസ് സംഖ്യകൾ" },
            { "type.nu.hant", "പരമ്പരാഗത ചൈനീസ് സംഖ്യകൾ" },
            { "type.nu.hebr", "ഹീബ്രു സംഖ്യകൾ" },
            { "type.nu.hmng", "പഹാവ് മോംഗ് അക്കങ്ങൾ" },
            { "type.nu.java", "ജാവനീസ് അക്കങ്ങൾ" },
            { "type.nu.jpan", "ജാപ്പനീസ് സംഖ്യകൾ" },
            { "type.nu.kali", "കയാഹ് ലി അക്കങ്ങൾ" },
            { "type.nu.khmr", "ഖമേർ അക്കങ്ങൾ" },
            { "type.nu.knda", "കന്നഡ സംഖ്യകൾ" },
            { "type.nu.lana", "തായ് താം ഹോറ അക്കങ്ങൾ" },
            { "type.nu.laoo", "ലാവോ അക്കങ്ങൾ" },
            { "type.nu.latn", "പടിഞ്ഞാറൻ അക്കങ്ങൾ" },
            { "type.nu.lepc", "ലെപ്‌ച അക്കങ്ങൾ" },
            { "type.nu.limb", "ലിംബു അക്കങ്ങൾ" },
            { "type.nu.mlym", "മലയാളം അക്കങ്ങൾ" },
            { "type.nu.modi", "മോഡി അക്കങ്ങൾ" },
            { "type.nu.mong", "മംഗോളിയൻ സംഖ്യകൾ" },
            { "type.nu.mroo", "മ്രോ അക്കങ്ങൾ" },
            { "type.nu.mtei", "മീറ്റെയ് മായെക് അക്കങ്ങൾ" },
            { "type.nu.mymr", "മ്യാൻമാർ അക്കങ്ങൾ" },
            { "type.nu.nkoo", "എൻകോ അക്കങ്ങൾ" },
            { "type.nu.olck", "ഓൾ ചികി അക്കങ്ങൾ" },
            { "type.nu.orya", "ഒഡിയ അക്കങ്ങൾ" },
            { "type.nu.osma", "ഒസ്‌മാന്യ അക്കങ്ങൾ" },
            { "type.nu.saur", "സൗരാഷ്‌ട്ര അക്കങ്ങൾ" },
            { "type.nu.shrd", "ശാരദ അക്കങ്ങൾ" },
            { "type.nu.sind", "ഖുഡവാഡി അക്കങ്ങൾ" },
            { "type.nu.sinh", "സിംഹള ലിത് അക്കങ്ങൾ" },
            { "type.nu.sora", "സോറ സോംപെങ് അക്കങ്ങൾ" },
            { "type.nu.sund", "സുഡാനീസ് അക്കങ്ങൾ" },
            { "type.nu.takr", "ടാക്രി അക്കങ്ങൾ" },
            { "type.nu.talu", "പുതിയ തായ് ലൂ അക്കങ്ങൾ" },
            { "type.nu.taml", "പരമ്പരാഗത തമിഴ് സംഖ്യകൾ" },
            { "type.nu.telu", "തെലുങ്ക് സംഖ്യകൾ" },
            { "type.nu.thai", "തായി അക്കങ്ങൾ" },
            { "type.nu.tibt", "ടിബറ്റൻ അക്കങ്ങൾ" },
            { "type.nu.tirh", "തിർഹുത്ത അക്കങ്ങൾ" },
            { "type.nu.vaii", "വായ് സംഖ്യകൾ" },
            { "type.nu.wara", "വറാങ് സിറ്റി അക്കങ്ങൾ" },
            { "type.ca.dangi", "ഡാംഗി കലണ്ടർ" },
            { "type.co.ducet", "സ്ഥിര യൂണികോഡ് അടുക്കൽ ക്രമം" },
            { "type.co.emoji", "ഇമോജി അടുക്കൽ ക്രമം" },
            { "type.lb.loose", "അനിയന്ത്രിത രേഖാ വിഭാജി ശൈലി" },
            { "type.nu.roman", "റോമൻ സംഖ്യകൾ" },
            { "type.ca.coptic", "കോപ്റ്റിക് കലണ്ടർ" },
            { "type.ca.hebrew", "ഹീബ്രൂ കലണ്ടർ" },
            { "type.ca.indian", "ശകവർഷ കലണ്ടർ" },
            { "type.co.compat", "അനുയോജ്യതയ്‌ക്കായുള്ള മുൻ അടുക്കൽ ക്രമം" },
            { "type.co.pinyin", "പിൻ‌യിൻ ക്രമീകരണം" },
            { "type.co.search", "പൊതുവായ ആവശ്യത്തിനുള്ള തിരയൽ" },
            { "type.co.stroke", "സ്റ്റ്രോക്ക് ക്രമീകരണം" },
            { "type.co.unihan", "റാഡിക്കൽ-സ്ട്രോക്ക് അടുക്കൽ ക്രമം" },
            { "type.co.zhuyin", "ജുയൻ അടുക്കൽ ക്രമം" },
            { "type.d0.fwidth", "ഫുൾവിഡ്‌ത്തിലേക്ക്" },
            { "type.d0.hwidth", "ഹാഫ്‌വിഡ്‌ത്തിലേക്ക്" },
            { "type.lb.normal", "സാധാരണ രേഖ വിഭാജി ശൈലി" },
            { "type.lb.strict", "നിയന്ത്രിത രേഖ വിഭാജി ശൈലി" },
            { "type.m0.ungegn", "യു.എൻ. ജി.ഇ.ജി.എൻ. ലിപ്യന്തരണം" },
            { "type.ms.metric", "മെട്രിക്ക് സംവിധാനം" },
            { "type.nu.native", "തദ്ദേശീയ അക്കങ്ങൾ" },
            { "type.ca.chinese", "ചൈനീസ് കലണ്ടർ" },
            { "type.ca.islamic", "ഇസ്‌ലാമിക് കലണ്ടർ" },
            { "type.ca.iso8601", "ഐഎസ്ഓ 8601 കലണ്ടർ" },
            { "type.ca.persian", "പേർഷ്യൻ കലണ്ടർ" },
            { "type.cf.account", "അക്കൗണ്ടിംഗ് കറൻസി ഫോർമാറ്റ്" },
            { "type.co.big5han", "പരമ്പരാഗത ചൈനീസ് ക്രമീകരണം - ബിഗ്5" },
            { "type.d0.npinyin", "സംഖ്യാപരമായ" },
            { "type.nu.arabext", "വിപുലീകൃത അറബിക്-ഇന്ത്യ അക്കങ്ങൾ" },
            { "type.nu.armnlow", "അർമേനിയൻ ചെറിയ സംഖ്യകൾ" },
            { "type.nu.finance", "സാമ്പത്തിക സംഖ്യകൾ" },
            { "type.nu.greklow", "ഗ്രീക്ക് ചെറിയക്ഷര സംഖ്യകൾ" },
            { "type.nu.hanidec", "ചൈനീസ് ദശാംശ സംഖ്യകൾ" },
            { "type.nu.hansfin", "ലളിതവൽക്കരിച്ച ചൈനീസ് ധനകാര്യ സംഖ്യകൾ" },
            { "type.nu.hantfin", "പരമ്പരാഗത ചൈനീസ് ധനകാര്യ സംഖ്യകൾ" },
            { "type.nu.jpanfin", "ജാപ്പനീസ് ധനകാര്യ സംഖ്യകൾ" },
            { "type.nu.mathdbl", metaValue_type_nu_mathdbl },
            { "type.nu.tamldec", "തമിഴ് അക്കങ്ങൾ" },
            { "type.ca.buddhist", "ബുദ്ധമതകലണ്ടർ" },
            { "type.ca.ethiopic", "എത്യോപിക് കലണ്ടർ" },
            { "type.ca.japanese", "ജാപ്പനീസ് കലണ്ടർ" },
            { "type.cf.standard", "സാധാരണ കറൻസി ഫോർമാറ്റ്" },
            { "type.co.phonetic", "സ്വരസൂചക അടുക്കൽ ക്രമം" },
            { "type.co.reformed", "നവീകരിച്ച അടുക്കൽ ക്രമം" },
            { "type.co.searchjl", "ഹാംഗൽ പ്രാരംഭ വ്യഞ്ജനാക്ഷരം പ്രകാരം തിരയുക" },
            { "type.co.standard", "സാധാരണ അടുക്കൽ ക്രമം" },
            { "type.ms.uksystem", "ബ്രിട്ടീഷ് അളക്കൽ സംവിധാനം" },
            { "type.ms.ussystem", "യുഎസ് അളക്കൽ സംവിധാനം" },
            { "type.nu.fullwide", "പൂർണ വലുപ്പമുള്ള സംഖ്യകൾ" },
            { "type.nu.lanatham", "തായ് താം താം അക്കങ്ങൾ" },
            { "type.nu.mathbold", "ഗണിത ബോൾഡ് അക്കങ്ങൾ" },
            { "type.nu.mathmono", metaValue_type_nu_mathdbl },
            { "type.nu.mathsanb", "ഗണിത സാൻസ്‌-സെരീഫ് ബോൾഡ് അക്കങ്ങൾ" },
            { "type.nu.mathsans", "ഗണിത സാൻസ്-സെരീഫ് അക്കങ്ങൾ" },
            { "type.nu.mymrshan", "മ്യാൻമാർ ഷാൻ അക്കങ്ങൾ" },
            { "type.nu.mymrtlng", "മ്യാൻമാർ തായ് ലെയിംഗ് അക്കങ്ങൾ" },
            { "type.nu.romanlow", "റോമൻ ചെറിയ സംഖ്യകൾ" },
            { "type.ca.gregorian", "ഇംഗ്ലീഷ് കലണ്ടർ" },
            { "type.co.gb2312han", "ലളിതമായ ചൈനീസ് ക്രമീകരണം - ജീബി2312" },
            { "type.co.phonebook", "ഫോൺബുക്കിലെ ക്രമീകരണം" },
            { "type.co.dictionary", "നിഘണ്ടു അടുക്കൽ ക്രമം" },
            { "type.co.traditional", "പരമ്പരാഗത ക്രമീകരണം" },
            { "type.nu.traditional", "സാധാരണയായി ഉപയോഗിച്ചുവരുന്ന സംഖ്യകൾ" },
            { "type.ca.islamic-rgsa", "ഇസ്ലാം-അറബിക് കലണ്ടർ" },
            { "type.ca.islamic-tbla", "ഇസ്ലാം-ജ്യോതിഷ കലണ്ടർ" },
            { "type.ca.islamic-civil", "ഇസ്ലാമിക് കലണ്ടർ" },
            { "type.ca.islamic-umalqura", "ഇസ്‌ലാമിക് കലണ്ടർ (ഉം അൽ ഖുറ)" },
            { "type.ca.ethiopic-amete-alem", "എത്യോപിക് അമെതെ അലെം കലണ്ടർ" },
        };
        return data;
    }
}
