/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Formatter;
import java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private final boolean autoFlush;
    private boolean trouble = false;
    private Formatter formatter;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing = false;

    private static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        PrintStream.requireNonNull(string, "charsetName");
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    private PrintStream(boolean bl, OutputStream outputStream) {
        super(outputStream);
        this.autoFlush = bl;
        this.charOut = new OutputStreamWriter(this);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, OutputStream outputStream, Charset charset) {
        super(outputStream);
        this.autoFlush = bl;
        this.charOut = new OutputStreamWriter((OutputStream)this, charset);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, Charset charset, OutputStream outputStream) throws UnsupportedEncodingException {
        this(bl, outputStream, charset);
    }

    public PrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        this(bl, PrintStream.requireNonNull(outputStream, "Null output stream"));
    }

    public PrintStream(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        this(bl, PrintStream.requireNonNull(outputStream, "Null output stream"), PrintStream.toCharset(string));
    }

    public PrintStream(String string) throws FileNotFoundException {
        this(false, new FileOutputStream(string));
    }

    public PrintStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(string2), new FileOutputStream(string));
    }

    public PrintStream(File file) throws FileNotFoundException {
        this(false, new FileOutputStream(file));
    }

    public PrintStream(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(false, PrintStream.toCharset(string), new FileOutputStream(file));
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException iOException) {
                this.trouble = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.textOut.close();
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintStream) {
            PrintStream printStream = (PrintStream)this.out;
            return printStream.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(n);
                if (n == 10 && this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.out.write(byArray, n, n2);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] cArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(cArray);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] != '\n') continue;
                        this.out.flush();
                    }
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.write(string);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush && string.indexOf(10) >= 0) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.textOut.newLine();
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(bl);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(n);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(cArray);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        String string = String.valueOf(object);
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.newLine();
        }
    }

    public PrintStream printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    public PrintStream printf(Locale locale, String string, Object ... objectArray) {
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(String string, Object ... objectArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                    this.formatter = new Formatter((Appendable)this);
                }
                this.formatter.format(Locale.getDefault(), string, objectArray);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(Locale locale, String string, Object ... objectArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != locale) {
                    this.formatter = new Formatter(this, locale);
                }
                this.formatter.format(locale, string, objectArray);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        if (charSequence == null) {
            this.print("null");
        } else {
            this.print(charSequence.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence == null ? "null" : charSequence;
        this.write(charSequence2.subSequence(n, n2).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }
}

