/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLServerSocketImpl;

public final class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;
    private final SSLContextImpl context;

    public SSLServerSocketFactoryImpl() throws Exception {
        this.context = SSLContextImpl.DefaultSSLContext.getDefaultImpl();
    }

    SSLServerSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.context = sSLContextImpl;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return new SSLServerSocketImpl(this.context);
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return new SSLServerSocketImpl(this.context, n, 50);
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return new SSLServerSocketImpl(this.context, n, n2);
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new SSLServerSocketImpl(this.context, n, n2, inetAddress);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return CipherSuite.namesOf(this.context.getDefaultCipherSuites(true));
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.context.getSupportedCipherSuites());
    }
}

