#!/usr/bin/env gpgscm

;; Copyright (C) 2025 Daniel Kahn Gillmor <dkg@fifthhorseman.net>
;;
;; This file is part of GnuPG.
;;
;; GnuPG is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3 of the License, or
;; (at your option) any later version.
;;
;; GnuPG is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, see <https://www.gnu.org/licenses/>.

(load (in-srcdir "tests" "openpgp" "defs.scm"))
(setup-legacy-environment)

(define keyfile (in-srcdir "tests" "openpgp" "issue7539-signer.asc"))
(define msg (in-srcdir "tests" "openpgp" "issue7539-message.asc"))

(info "Checking text Signature over binary Literal Data Packet")

(call-check `(,@gpg --import ,keyfile))
(call-check `(,@gpg --verify ,msg))
