<!-- Generated by cargo-onedoc v0.3.2. DO NOT EDIT. -->

# emojis

[![Crates.io Version](https://badgers.space/crates/version/emojis)](https://crates.io/crates/emojis)
[![Docs.rs Latest](https://badgers.space/badge/docs.rs/latest/blue)](https://docs.rs/emojis)
[![Build Status](https://badgers.space/github/checks/rossmacarthur/emojis?label=build)](https://github.com/rossmacarthur/emojis/actions/workflows/build.yaml)

✨ Lookup emoji in *O(1)* time, access metadata and GitHub shortcodes,
iterate over all emoji.

## Features

- Lookup up emoji by Unicode value
- Lookup up emoji by GitHub shortcode ([gemoji] v4.1.0)
- Access emoji metadata: name, unicode version, group, skin tone, [gemoji] shortcodes
- Iterate over emojis in Unicode CLDR order
- Iterate over emojis in an emoji group, e.g. “Smileys & Emotion” or “Flags”
- Iterate over the skin tones for an emoji
- Select a specific skin tone for an emoji
- Uses [Unicode v16.0](https://unicode.org/emoji/charts-16.0/emoji-released.html) emoji specification

## Getting started

First, add the `emojis` crate to your Cargo manifest.

```sh
cargo add emojis
```

Simply use the [`get()`][get] function to lookup emojis by Unicode value.

```rust
let rocket = emojis::get("🚀").unwrap();
```

Or the [`get_by_shortcode()`][get_by_shortcode] function to lookup emojis by
[gemoji] shortcode.

```rust
let rocket = emojis::get_by_shortcode("rocket").unwrap();
```

These operations take *Ο(1)* time.

## MSRV

Currently the minimum supported Rust version is 1.61 due to the dependency
on `phf`. The policy of this crate is to only increase the MSRV in a
breaking release.

## Breaking changes

When [gemoji] or the Unicode version is upgraded this is not considered a
breaking change, instead you should make sure to use
[`unicode_version()`][unicode_version] to filter out newer versions.

## Examples

See [examples/replace.rs] for an example that replaces `:gemoji:` names with
real emojis in text.

```sh
$ echo "launch :rocket:" | cargo run --example replace
launch 🚀
```

[`get()`][get] and [`get_by_shortcode()`][get_by_shortcode] return an
[`Emoji`][Emoji] struct which contains various metadata regarding the emoji.

```rust
let hand = emojis::get("🤌").unwrap();
assert_eq!(hand.as_str(), "\u{1f90c}");
assert_eq!(hand.as_bytes(), &[0xf0, 0x9f, 0xa4, 0x8c]);
assert_eq!(hand.name(), "pinched fingers");
assert_eq!(hand.unicode_version(), emojis::UnicodeVersion::new(13, 0));
assert_eq!(hand.group(), emojis::Group::PeopleAndBody);
assert_eq!(hand.skin_tone(), Some(emojis::SkinTone::Default));
assert_eq!(hand.shortcode(), Some("pinched_fingers"));
```

Use [`skin_tones()`][skin_tones] to iterate over the skin tones of an
emoji.

```rust
let raised_hands = emojis::get("🙌🏼").unwrap();
let skin_tones: Vec<_> = raised_hands.skin_tones().unwrap().map(|e| e.as_str()).collect();
assert_eq!(skin_tones, ["🙌", "🙌🏻", "🙌🏼", "🙌🏽", "🙌🏾", "🙌🏿"]);
```

You can use the `iter()` function to iterate over all emojis. This only
includes the default skin tone versions.

```rust
let faces: Vec<_> = emojis::iter().map(|e| e.as_str()).take(5).collect();
assert_eq!(faces, ["😀", "😃", "😄", "😁", "😆"]);
```

It is recommended to filter the list by the maximum Unicode version that you
wish to support.

```rust
let iter = emojis::iter().filter(|e| {
    e.unicode_version() < emojis::UnicodeVersion::new(13, 0)
});
```

Using the `Group` enum you can iterate over all emojis in a group.

```rust
let fruit: Vec<_> = emojis::Group::FoodAndDrink.emojis().map(|e| e.as_str()).take(5).collect();
assert_eq!(fruit, ["🍇", "🍈", "🍉", "🍊", "🍋"]);
```

#### Storing the [`Emoji`][Emoji] type

If you want to store the [`Emoji`][Emoji] type in a data structure, you should
store it as static reference: `&'static Emoji`. This crate intentionally
does not provide any constructors or implement `Clone` or `Copy` for
[`Emoji`][Emoji]. `&'static Emoji` supports `serde` serialization and
deserialization, *not* `Emoji`.

For example:

```rust
#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize)]
enum Example {
    Rocket {
        value: &'static emojis::Emoji
    },
}

Example::Rocket { value: emojis::get("🚀").unwrap() };
```

[gemoji]: https://github.com/github/gemoji
[get]: https://docs.rs/emojis/latest/emojis/fn.get.html
[get_by_shortcode]: https://docs.rs/emojis/latest/emojis/fn.get_by_shortcode.html
[unicode_version]: https://docs.rs/emojis/latest/emojis/struct.Emoji.html#method.unicode_version
[examples/replace.rs]: https://github.com/rossmacarthur/emojis/blob/trunk/examples/replace.rs
[Emoji]: https://docs.rs/emojis/latest/emojis/struct.Emoji.html
[skin_tones]: https://docs.rs/emojis/latest/emojis/struct.Emoji.html#method.skin_tones

## License

This project is distributed under the terms of both the MIT license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
