// generated by diplomat-tool
import { BidiPairedBracketType } from "./BidiPairedBracketType.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `BidiMirroringGlyph`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiMirroringGlyph.html) for more information.
 */


export class BidiMirroringGlyph {
    #mirroringGlyph;
    get mirroringGlyph() {
        return this.#mirroringGlyph;
    }
    set mirroringGlyph(value){
        this.#mirroringGlyph = value;
    }
    #mirrored;
    get mirrored() {
        return this.#mirrored;
    }
    set mirrored(value){
        this.#mirrored = value;
    }
    #pairedBracketType;
    get pairedBracketType() {
        return this.#pairedBracketType;
    }
    set pairedBracketType(value){
        this.#pairedBracketType = value;
    }
    /** Create `BidiMirroringGlyph` from an object that contains all of `BidiMirroringGlyph`s fields.
    * Optional fields do not need to be included in the provided object.
    */
    static fromFields(structObj) {
        return new BidiMirroringGlyph(structObj);
    }

    #internalConstructor(structObj) {
        if (typeof structObj !== "object") {
            throw new Error("BidiMirroringGlyph's constructor takes an object of BidiMirroringGlyph's fields.");
        }

        if ("mirroringGlyph" in structObj) {
            this.#mirroringGlyph = structObj.mirroringGlyph;
        } else {
            this.#mirroringGlyph = null;
        }

        if ("mirrored" in structObj) {
            this.#mirrored = structObj.mirrored;
        } else {
            throw new Error("Missing required field mirrored.");
        }

        if ("pairedBracketType" in structObj) {
            this.#pairedBracketType = structObj.pairedBracketType;
        } else {
            throw new Error("Missing required field pairedBracketType.");
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [...diplomatRuntime.optionToArgsForCalling(this.#mirroringGlyph, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue, Uint32Array)]), this.#mirrored, /* [3 x i8] padding */ 0, 0, 0 /* end padding */, this.#pairedBracketType.ffiValue]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof BidiMirroringGlyph) {
            return obj;
        }

        return BidiMirroringGlyph.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeOptionToArrayBuffer(arrayBuffer, offset + 0, this.#mirroringGlyph, 4, 4, (arrayBuffer, offset, jsValue) => diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue, Uint32Array));
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 8, this.#mirrored, Uint8Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 12, this.#pairedBracketType.ffiValue, Int32Array);
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("BidiMirroringGlyph._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const mirroringGlyphDeref = ptr;
        structObj.mirroringGlyph = diplomatRuntime.readOption(wasm, mirroringGlyphDeref, 4, (wasm, offset) => { const deref = (new Uint32Array(wasm.memory.buffer, offset, 1))[0]; return deref });
        const mirroredDeref = (new Uint8Array(wasm.memory.buffer, ptr + 8, 1))[0] === 1;
        structObj.mirrored = mirroredDeref;
        const pairedBracketTypeDeref = diplomatRuntime.enumDiscriminant(wasm, ptr + 12);
        structObj.pairedBracketType = new BidiPairedBracketType(diplomatRuntime.internalConstructor, pairedBracketTypeDeref);

        return new BidiMirroringGlyph(structObj);
    }


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 16, 4, false);


        const result = wasm.icu4x_BidiMirroringGlyph_for_char_mv1(diplomatReceive.buffer, ch);

        try {
            return BidiMirroringGlyph._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(structObj) {
        return this.#internalConstructor(...arguments)
    }
}