"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VueScriptCache = void 0;
const transformVueSfcFile_1 = require("./transformVueSfcFile");
class VueScriptCache {
    constructor(tsImpl, getHostScriptSnapshot, getScriptVersion) {
        this.tsImpl = tsImpl;
        this.getHostScriptSnapshot = getHostScriptSnapshot;
        this.getScriptVersion = getScriptVersion;
        this.cache = new Map();
    }
    getScriptKind(fileName) {
        var _a;
        return (_a = this.getUpToDateInfo(fileName)) === null || _a === void 0 ? void 0 : _a.kind;
    }
    getScriptSnapshot(fileName) {
        var _a;
        return (_a = this.getUpToDateInfo(fileName)) === null || _a === void 0 ? void 0 : _a.snapshot;
    }
    getUpToDateInfo(fileName) {
        const fromCache = this.cache.get(fileName);
        const currentVersion = this.getScriptVersion(fileName);
        if ((fromCache === null || fromCache === void 0 ? void 0 : fromCache.version) === currentVersion) {
            return {
                kind: fromCache.kind,
                snapshot: fromCache.snapshot
            };
        }
        const snapshot = this.getHostScriptSnapshot(fileName);
        if (snapshot === undefined || snapshot === null)
            return undefined;
        const result = this.handleVueFile(snapshot.getText(0, snapshot.getLength()));
        this.cache.set(fileName, Object.assign(Object.assign({}, result), { version: currentVersion }));
        return result;
    }
    handleVueFile(contents) {
        const { result, scriptKind } = transformVueSfcFile_1.transformVueSfcFile(this.tsImpl, contents);
        const snapshot = this.tsImpl.ScriptSnapshot.fromString(result);
        // Allow retrieving script kind from snapshot
        snapshot.scriptKind = scriptKind;
        return {
            snapshot,
            kind: scriptKind
        };
    }
}
exports.VueScriptCache = VueScriptCache;
