/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.vcs.frontend.split.diff.ChangedBlock;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffMarkModelSupportKt;
import com.intellij.platform.vcs.frontend.split.diff.SideBySideChangeModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002J(\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0\u001f2\u0006\u0010$\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/SideBySideBlocksModel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor1", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editor2", "onBlocksChanges", "Lkotlin/Function0;", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function0;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getOnBlocksChanges", "()Lkotlin/jvm/functions/Function0;", "isUpdateScheduled", "", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "value", "", "Lcom/intellij/platform/vcs/frontend/split/diff/ChangedBlock;", "changedBlocks", "getChangedBlocks", "()Ljava/util/List;", "scheduleBlockUpdate", "clearBlocks", "rebuildBlocks", "collectBlockHighlighters", "", "", "Lkotlin/Pair;", "Lcom/intellij/platform/vcs/frontend/split/diff/SideBySideChangeModel;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "editor", "BlocksMarkupModelListener", "intellij.platform.vcs.frontend.split"})
public final class SideBySideBlocksModel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor1;
    @NotNull
    private final EditorEx editor2;
    @NotNull
    private final Function0<Unit> onBlocksChanges;
    private boolean isUpdateScheduled;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private List<ChangedBlock> changedBlocks;

    public SideBySideBlocksModel(@NotNull Lifetime lifetime, @NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull Function0<Unit> onBlocksChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter(onBlocksChanges, (String)"onBlocksChanges");
        this.lifetime = lifetime;
        this.editor1 = editor1;
        this.editor2 = editor2;
        this.onBlocksChanges = onBlocksChanges;
        this.highlighters = new ArrayList();
        this.changedBlocks = CollectionsKt.emptyList();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        BlocksMarkupModelListener markupListener = new BlocksMarkupModelListener();
        this.editor1.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)markupListener);
        this.editor2.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)markupListener);
        this.scheduleBlockUpdate();
        this.lifetime.onTermination(() -> SideBySideBlocksModel._init_$lambda$0(this));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function0<Unit> getOnBlocksChanges() {
        return this.onBlocksChanges;
    }

    @NotNull
    public final List<ChangedBlock> getChangedBlocks() {
        return this.changedBlocks;
    }

    private final void scheduleBlockUpdate() {
        if (this.isUpdateScheduled) {
            return;
        }
        this.isUpdateScheduled = true;
        ActionsKt.invokeLater$default(null, () -> SideBySideBlocksModel.scheduleBlockUpdate$lambda$1(this), (int)1, null);
    }

    private final void clearBlocks() {
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        this.highlighters.clear();
        this.changedBlocks = CollectionsKt.emptyList();
    }

    private final void rebuildBlocks() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime) || this.editor1.isDisposed() || this.editor2.isDisposed()) {
            return;
        }
        this.clearBlocks();
        Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> map1 = this.collectBlockHighlighters(this.editor1);
        Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> map2 = this.collectBlockHighlighters(this.editor2);
        List newBlocks = new ArrayList();
        Iterator iterator = CollectionsKt.sorted((Iterable)CollectionsKt.union((Iterable)map1.keySet(), (Iterable)map2.keySet())).iterator();
        while (iterator.hasNext()) {
            Pair<SideBySideChangeModel, RangeHighlighterEx> pair;
            Pair<SideBySideChangeModel, RangeHighlighterEx> pair2;
            long changeId = ((Number)iterator.next()).longValue();
            if (map1.get(changeId) == null) continue;
            SideBySideChangeModel model1 = (SideBySideChangeModel)pair2.component1();
            RangeHighlighterEx highlighter1 = (RangeHighlighterEx)pair2.component2();
            if (map2.get(changeId) == null) continue;
            SideBySideChangeModel model2 = (SideBySideChangeModel)pair.component1();
            RangeHighlighterEx highlighter2 = (RangeHighlighterEx)pair.component2();
            ((Collection)newBlocks).add(new ChangedBlock(highlighter1, highlighter2, model1, model2));
        }
        this.changedBlocks = newBlocks;
        this.onBlocksChanges.invoke();
    }

    private final Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> collectBlockHighlighters(EditorEx editor) {
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        Map blockMap = new LinkedHashMap();
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, document.getTextLength(), arg_0 -> SideBySideBlocksModel.collectBlockHighlighters$lambda$3(arg_0 -> SideBySideBlocksModel.collectBlockHighlighters$lambda$2(blockMap, arg_0), arg_0));
        return blockMap;
    }

    private static final Unit _init_$lambda$0(SideBySideBlocksModel this$0) {
        this$0.clearBlocks();
        return Unit.INSTANCE;
    }

    private static final Unit scheduleBlockUpdate$lambda$1(SideBySideBlocksModel this$0) {
        this$0.isUpdateScheduled = false;
        this$0.rebuildBlocks();
        return Unit.INSTANCE;
    }

    private static final boolean collectBlockHighlighters$lambda$2(Map $blockMap, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        SideBySideChangeModel blockModel = FrontendDiffMarkModelSupportKt.getSideBySideChangeModel((RangeHighlighter)it);
        if (blockModel != null) {
            $blockMap.put(blockModel.getChangeId(), new Pair((Object)blockModel, (Object)it));
        }
        return true;
    }

    private static final boolean collectBlockHighlighters$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/SideBySideBlocksModel$BlocksMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "<init>", "(Lcom/intellij/platform/vcs/frontend/split/diff/SideBySideBlocksModel;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "onHighlighterModified", "intellij.platform.vcs.frontend.split"})
    private final class BlocksMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        private final void onHighlighterModified(RangeHighlighterEx highlighter) {
            if (FrontendDiffMarkModelSupportKt.getSideBySideChangeModel((RangeHighlighter)highlighter) != null) {
                SideBySideBlocksModel.this.scheduleBlockUpdate();
            }
        }
    }
}

